<?php

use App\Http\Controllers\AcademyRegistrationController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\IndexController;
use App\Http\Controllers\LoginController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::controller(IndexController::class)->group( function() {
    Route::get('/','index')->name('home_page');
    Route::get('academy','academy_page')->name('academy_page');
    Route::get('academy/register','academy_registration_page')->name('academy_registration_page');
});

Route::controller(AcademyRegistrationController::class)->group( function(){
    Route::post('academy-sign-up', 'sign_up')->name('sign_up');
    Route::get('verify/p-{ref_number}', 'verify_payment')->name('verify_payment');
});

Route::controller(LoginController::class)->group( function(){
    Route::prefix('a')->group( function(){
        Route::get('login', 'login_page')->name('login');
        Route::post('login-user', 'login_user')->name('login_user');
    });
});

Route::middleware('auth','admin_only')->controller(AdminController::class)->group( function(){
    Route::prefix('a')->group( function(){
        Route::get('dashboard', 'index')->name('dashboard');
        Route::get('logout', 'logout')->name('logout');
        Route::get('send-program-details-email', 'send_program_details_email')->name('send_program_details_email');
    });
});
