@extends("layouts.app")
@section("page_title", 'All users - sp360 Academy')
@section("page_description", 'Admin Dashboard')

@section('page_content')
@include('layouts.page_banner')


<section class="mt-5 text-center container-fluid">
@include('layouts.messages')
<h3 class="text-center intro"> All Registered users ({{all_users()->count()}}) </h3>
<p> <a href="{{ route('logout')}}" class="btn btn-outline-info"> Logout </a> </p>
<p> <a href="{{ route('send_program_details_email')}}" class="btn btn-outline-success"> Send program details email </a> </p>
<hr>

<div class="table-responsive">
    <table class="table table-hover table-striped table-bordered table-hover">
        <thead>
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Email</th>
                <th>Gender </th>
                <th>Phone</th>
                <th>Amount Paid</th>
                <th>Payment Mode</th>
                <th>Status</th>
                <th>Trnx Ref</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            @forelse(all_users() as $index=>$user)
            <tr>
                <td>{{++$index }}</td>
                <td>{{$user->fullnames() }}</td>
                <td>{{$user->email}}</td>
                <td>{{$user->gender}}</td>
                <td>{{$user->phone_number}}</td>
                <td>{{number_format($user->amount_paid )}}</td>
                <td>{{$user->payment_mode}}</td>
                <td>{{$user->payment_status() }}</td>
                <td>{{$user->payment_reference}}</td>
                <td>
                    <a href="{{ route('verify_payment',['ref_number'=> $user->payment_reference, 'mode' => $user->payment_mode])}}" class="btn btn-outline-info">Verify</a> &nbsp;
                    @if ($proof = $user->proof_of_payment )
                    <a href="{{ asset( proof_of_payment_docs_folder().$proof )}}" class="btn btn-outline-success">View file </a>
                    @endif
                </td>
            </tr>
            @empty
            <tr>
                <td></td>
            </tr>
            @endforelse
        </tbody>
    </table>
</div>

</section>
@stop