@extends("layouts.app")
@section("page_title", 'Sp360 Academy Registration')
@section("page_description", academy_program()->theme .' - '. academy_program()->project .' - Sp360 Academy')

@section('page_content')
@include('layouts.academy_registration_banner')

<section class="text-white container mt-3 mb-3">

@include("layouts.messages")

    @if( academy_program()->is_on )
    <form action="{{ route('sign_up')}}" method="post" class="form_" enctype="multipart/form-data">
        @csrf()
        <h4 class="text-center font-weight-bold"> {{ academy_program()->theme }} <br> ({{ academy_program()->project }}) </h4>
        <p class="text-center font-weight-bold"> <?php echo academy_program()->fee_info ?? ''; ?> </p>
        <section class="row">

            <div class="col-md-12">
                <div class="form-group">
                <label for=""> Lastname</label>
                <input type="text" name="lastname" spellcheck="true" class="form-control" placeholder="Surname" required>
                </div>
            </div>

            <div class="col-md-12">
                <div class="form-group">
                <label for=""> Firstname </label>
                <input type="text" name="firstname" class="form-control" placeholder="Firstname" >
                </div>
            </div>

            <div class="col-md-12">
                <div class="form-group">
                <label for=""> Email </label>
                <input type="email" name="email" class="form-control" placeholder="Email" required>
                </div>
            </div>

            <div class="col-md-12">
                <div class="form-group">
                <label for=""> Phone Number </label>
                <input type="number" name="phone_number" class="form-control" placeholder="Phone Number" required>
                </div>
            </div>

            <div class="col-md-12">
                <p class=""> <span class="font-weight-bold"> Gender </p>
                <div class="form-group">
                   <label for="male_">
                    <input type="radio" checked name="gender" class="gender_" required value="Male" id="male_">
                    Male
                    </label> <br>

                    <label for="female_">
                    <input type="radio" name="gender" class="gender_" required value="Female" id="female_">
                     Female
                    </label> <br>
                </div>
            </div>

            <div class="col-md-12">
                <p class=""> <span class="font-weight-bold"> Select Payment Method </span> <br>Amount Due - NGN {{ number_format(academy_program()->naira_fee)}} / ${{ number_format(academy_program()->dollar_fee )}} </p>
                <div class="form-group">
                   <label for="paystack">
                    <input type="radio" checked name="payment_mode" class="payment_mode_" required value="Paystack" id="paystack">
                    Paystack
                    </label> <br>

                    {{-- <label for="direct_bank_transfer">
                    <input type="radio" name="payment_mode" class="payment_mode_" required value="Direct Bank Transfer" id="direct_bank_transfer">
                     Direct Bank Transfer 
                    </label> <br> --}}

                    <label for="crypto">
                    <input type="radio" name="payment_mode" class="payment_mode_" required value="Crypto" id="crypto">
                     Crypto
                    </label>
                </div>
            </div>

            <div class="col-md-12 hide _payment_method bank_details_">
                <div class="form-group">
                    <h5> Bank Details: </h5>
                    <p> Make an exact transfer of NGN {{ number_format( academy_program()->naira_fee ) }} to the Account below. </p>
                    <?php echo academy_program()->bank_details ?>
                </div>
            </div>

            <div class="col-md-12 hide _payment_method crypto_details_">
                <div class="form-group">
                    <h6> Transfer {{ academy_program()->dollar_fee }} USDT to the Address below. </h6>
                    <a href="javascript:void(0)" class='scrollto'>
                     <img class="img-fluid img-thumbnail img-100" src="{{ asset('assets/img/usdt_barcode.jpeg') }}">
                    </a>
                  
                    <p class="mt-2"> USDT Wallet Address </p>
                    <div class="input-group">
                      <input type="text" readonly class="form-control crypto_wallet_address" value="0x547c7a2a3d7936c6f0fa3e4558d2893c30e47b17">
                      <div class="input-group-append">
                        <a href="javascript:void(0)" class="btn btn-sm btn-primary copy_link_" type="button"> Copy Link </a>
                      </div>
                    </div>
                    <P class="font-weight-bold"> Network: Binance Smart Chain (BEP20) </P>

                </div>
            </div>

            <div class="col-md-12 hide _payment_method proof_of_payment_">
                <div class="form-group">
                <label for=""> Upload proof of payment </label>
                <input type="file" name="proof_of_payment" class="form-control" placeholder="Proof of payment">
                </div>
            </div>

            <div class="col-md-12">
                <div class="form-group">
                <center> <button type="submit" class="btn btn-success"> Register me </button> </center>
                </div>
            </div>

        </section>
    </form>
    @else
    <h4 class="text-center"> {{ academy_program()->message }} </h4>

    @endif

</section>

@if( session()->has('pay_with_paystack') )
<script>
    
    $( function(){

        ///PAYSTACK
    var email = "{{ session()->get('email') }}",
        amount = "{{session()->get('amount') }}",
        ref_number = "{{ session()->get('ref_number') }}";
    let pay_with_paystack = (email, amount, ref_number, action_btn = '', redirect_url = '') => {
        var paystack_public_key = "{{ paystack_public_key() }}";
       //confirm_trnx_url = $('#verify_paystack_payment_transaction_url').attr('href')+`?ref_number=${ref_number}`;
        var handler = PaystackPop.setup({
             key: paystack_public_key,
             email: email,
             amount: parseFloat(amount) * 100,
             currency: 'NGN',
             ref: ref_number,
             callback: function(response) {
               if( response.status == 'success'){
                   window.location.href = "{{ route('verify_payment',['ref_number' => session()->get('ref_number'), 'mode' => 'Paystack']) }}";
               }else{
                   alert('Something went wrong !');
                   if( redirect_url ){
                       window.location.href = redirect_url;
                     }
               }
             },
             onClose: function() {
                alert('Transaction was not completed, window closed.');
                if( redirect_url ){
                    window.location.href = redirect_url;
                }
            },
        });
        handler.openIframe();
    };

    setTimeout(() => {
        pay_with_paystack(email, amount, ref_number);
    }, 1000);

    });
    
</script>
@endif

<script type="text/javascript">
    $( function(){
        $('.payment_mode_').on('change', (payment) => {
            $('._payment_method').hide();
            $('.copy_link_').text('Copy');
            let selected_payment = payment.target.id;

            if( selected_payment == "direct_bank_transfer"){
                    return pay_with_bank_transfer();
                }
                else if( selected_payment == "crypto" ){
                    return pay_with_crypto();
                }
        });

        let pay_with_crypto = () => {
            $('.crypto_details_').show();
            $('.proof_of_payment_').show();
        };

        let pay_with_bank_transfer = () => {
            $('.bank_details_').show();
            $('.proof_of_payment_').show();
        };

        $('.copy_link_').on('click', (e) => {
			  e.preventDefault();
			  var link_ = $('.crypto_wallet_address').val();
			  var inputc = document.body.appendChild(document.createElement("input"));
                        inputc.value = link_;
				    	inputc.focus();
                        inputc.select();
                        document.execCommand('copy');
                        inputc.parentNode.removeChild(inputc);
                        $('.copy_link_').text('Copied...');
						var div = document.querySelector(".crypto_details_");
						    div.scrollIntoView();
		        });
    });
</script>
@stop

