<?php
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;  
use App\Models\User;
use Illuminate\Support\Facades\Http;

include("paystack.php");
include("file_uploads.php");
include("mail.php");
include("send_emails.php");

    function password_corresponds($value, $hashed_value )
    {
       return Hash::check($value, $hashed_value);
    }

    function all_users()
    {
        return User::latest()->get();
    }

    function academy_program()
    {
        return json_decode( json_encode([
            "is_on" => false,
            "theme" => "40 Days of Laravel",
            "project" => "Building a Fintech wallet system",
            "project_features" => "Fund Deposits, Withdrawals, Transfers, Transactions record tracking, 
                                   Email Notifications of Transactions, User and Admin Dashboard, etc...",
            "message" => "No Active Program yet...",
            "requirements" => "A working Computer, Basic Knowledge of Html, Javascript and PHP",
            "starts_in" => "Dec 1 - Dec 21, 2022",
            "fee_info" => " NGN <del> 120,000 </del>  &nbsp; NGN 50,000",
            "dollar_fee" => 70,
            "naira_fee" =>  50000,
            "discount" => '',
            "class_time" => "Morning: 9am - 12pm. Afternoon: 2pm - 4pm",
            "slack_link" => "https://join.slack.com/t/sp360academy/shared_invite/zt-1isshpbcy-Nvj7hDFnT_AvzqmuxuU9Bg",
            "venue" => "Online ( Slack and Google Meet )",
            "venue_link" => "",
            'bank_details' => " <br> Bank Name: Abbey Mortgage Bank <br> Account Number: 0006032522 <br> Account Name: Fusol Global Technology" 
        ]));
    }

    function app_name()
    {
        return "Sp360 Academy";
    }

    function find_user( $user_id )
    {
        return User::whereId( $user_id )->first();
    }

    function query_model($model, $user_id, $is_deleted = 0)
    {
        return $model->whereUser_id( $user_id )->whereIs_deleted( $is_deleted )->latest();
    }

    function find_data( $model, $id )
    {
        return $model->whereId($id)->first();
    }

    function short_name( $content, $max_number = 15)
    {
        return ( strlen( $content ) > $max_number ) ? substr( $content, 0, ($max_number - 1) ).'...' : $content ;
    }

    function acronym( $word = "" )
    {
        $text = "";
        $words = explode(" ", trim( $word ) );
        try{
             foreach( $words as $word ){
              $text .= $word[0];
            }
        }
        catch(Exception $err){
            //
        }
        return $text;
    }
    
    function random_strings($length = 40)
    {
        return time().'_'.Str::random($length).'_'.uniqid('');
    }

    function code_number()
    {
        return uniqid().random_strings(10);
    }

    function current_user()
    {
        return auth()->user();
    }

    function json_response($data = [])
    {
        return response()->json($data);
    }

    function slug( $text = '', $seperator = '-')
    {
        return Str::slug( $text, $seperator );
    }

    function view_page( $page, $folder = '' )
    {
        $dir = "pages/";
        return ( $folder ) ? $dir.$folder.'/'.$page : $dir.'/'.$page;
    }

    function error_msg($msg='Failed, an error Occured...')
    {
        return back()->withErrors( $msg );
    }

    function success_msg($msg = 'Success...')
    {
        return back()->withSuccess( $msg );
    }

    function error_response($msg='Failed, an error Occured...')
    {
        return response()->json(['error' => $msg ]);
    }

    function success_response($msg = 'Success...')
    {
        return response()->json(['success' => $msg ]);
    }

    function user_device_details()
    {
        return '';
    }

    function user_ip_details($ip_info = "")
    {
        $info = $ip_info ? $ip_info : user_ip_address_info();
        return json_decode( $info );
    }

    function user_ip_address_info($ip_address_ = '')
    { 
      $ip_info = '';
      try{
      $api_key = "2d9a7d6c0c9144dbaf7135717221002";
      $request_uri = 'http://api.weatherapi.com/v1/ip.json';
      $ip_address = ($ip_address_) ? $ip_address_ : request()->ip();
      $url = $request_uri."?key=".$api_key."&q=".$ip_address;
      $data = Http::get($url);
      $data = $data->object();
      $ip_info = json_encode([
          'state' => $data->region,
          'ip_address' => $ip_address,
          'country_code' => $data->country_code,
          'continent' => $data->continent_name,
          'city' => $data->city,
          'timezone' => $data->tz_id,
          'longitude' => $data->lon,
          'latitude' => $data->lat,
          'currency' => '',
          'country' => $data->country_name
        ]);
      }
      catch(Exception $err ){
          //return 'error '.$err;
          //$ip_info = [];
      }
      return $ip_info;
    }

    function all_countries()
    {
        //return country::orderBy('name')->get();
        // $url = 'http://www.geognos.com/api/en/countries/info/all.json';
        $url = 'https://restcountries.com/v3.1/all';
        $countries = collect([]);
        try{
            $countries = Http::get($url);
        }
        catch(Exception $err){}
        return $countries;
    }