<?php

namespace App\Http\Controllers;

use App\Models\User;
use Exception;
use Illuminate\Http\Request;

class AcademyRegistrationController extends Controller
{
    function sign_up()
    {
        $this->validate_data();
        $amount_paid = floatval(academy_program()->naira_fee);
        if( request()->payment_mode != "Paystack" ){
            if(! request()->hasFile('proof_of_payment')){
                return error_msg("Please upload your proof of payment before proceeding...");
            }
            if( request()->payment_mode == "Crypto") $amount_paid = academy_program()->dollar_fee;
        }
        $email = request()->email;
        $data = request()->except('_token');
        $data['program'] = academy_program()->theme;
        $data['ip_address'] = request()->ip();
        $data['ip_info'] = user_ip_address_info();
        $data['password'] = bcrypt('uc123456');
        $data['amount_paid'] = $amount_paid;
        
        if( request()->hasFile('proof_of_payment') ){
            $data['proof_of_payment'] = upload_file_( request()->proof_of_payment, proof_of_payment_docs_folder() );
        }
        if( User::whereEmail($email)->exists() ){
            $user = User::whereEmail($email)->first();
                   $user->update( $data );
        }else{
            $data['payment_reference'] = code_number();
            $user = User::create( $data );
        }
        if( ! $user ) return error_msg();
        if( request()->payment_mode == "Paystack"){
            session()->put([ 
                             "pay_with_paystack" => 1,
                             "email" => $user->email,
                             "ref_number" => $user->payment_reference,
                            "amount" => $user->amount_paid]);
        }
        return success_msg("Your Registration has been received and it's been processed...");
    }

    function verify_payment($ref_number)
    {
        session()->flush();
        if( request()->mode != "Paystack" ) return $this->update_payment( $ref_number );
        $payment = verify_paystack_payment( $ref_number );
        try{
            if( $payment->data->status == "success" && $payment->data->amount == ( academy_program()->naira_fee * 100 ) ){
                return $this->update_payment( $ref_number );
            }
        }catch( Exception $e){
            return error_msg("Network Error ! ");
        }
        return error_msg();
    }

    function update_payment( $ref_number )
    {
        $user = User::wherePayment_reference( $ref_number )->first();
        $user->update(['payment_st' => 1]);
        send_welcome_email($user);
        return ! $user ? error_msg("Payment not verified...") : success_msg("Congratulations, Your Registration was successful...");
    }

    function validate_data()
    {
        return $this->validate(request(), [
            "lastname" => "required",
            "firstname" => "required",
            "email" => "required",
            "phone_number" => "required"
        ]);
    }
}
