<?php
// Automatically Generate a Manfiest.webmaifest page and insert auto generated contents
  $school = auth()->user()->school;
  if( $school->logo ):
    $img_src = "/uploaded_files/school_logo/".$school->id."/".$school->logo;
  else:
    $img_src = "/dist/img/sp360_logo.png";
  endif;
  $manifest_page = fopen("manifests_/manifest-".$school->id.".json", 'w');
  $content = '{
    "short_name": " School Portal",
    "name": "'. $school->name .' Portal ",
    "description": "School Portal",
    "icons": 
    [
      {
        "src": "'.$img_src. ' ",
        "type": "image/png",
        "sizes": "96x96"
      },
      {
        "src":"'. $img_src. ' ",
        "type": "image/png",
        "sizes": "192x192"
      },
      {
        "src": "'. $img_src. ' ",
        "type": "image/png",
        "sizes": "512x512"
      }
    ],
    "start_url": "/page/dashboard",
    "background_color": "#ebeefa",
    "display": "standalone",
    "theme_color": "#ebeefa"
  }';
  fwrite( $manifest_page, $content );
  fclose( $manifest_page );
 ?>

 <script>
     $(function() {
        if ('serviceWorker' in navigator) {
            navigator.serviceWorker
            .register('/service-worker.js')
            .then(() => { console.log('Service Worker Registered'); });
        }
        let deferredPrompt;
        var addBtn = document.querySelector('.add_to_homescreen_');
        addBtn.style.display = 'none';

        window.addEventListener('beforeinstallprompt', (e) => {
  // Prevent Chrome 67 and earlier from automatically showing the prompt
  e.preventDefault();
  // Stash the event so it can be triggered later.
  deferredPrompt = e;
  // Update UI to notify the user they can add to home screen
  addBtn.style.display = 'block';

  addBtn.addEventListener('click', (e) => {
    // hide our user interface that shows our A2HS button
    addBtn.style.display = 'none';
    // Show the prompt
    deferredPrompt.prompt();
    // Wait for the user to respond to the prompt
    deferredPrompt.userChoice.then((choiceResult) => {
        if (choiceResult.outcome === 'accepted') {
          console.log('User accepted the A2HS prompt');
        } else {
          console.log('User dismissed the A2HS prompt');
        }
        deferredPrompt = null;
      });
  });

});
     });
 </script>
<?php /**PATH /home/naijalan/sp360/app/sp360_app/resources/views/partials/addtohomescreen.blade.php ENDPATH**/ ?>