<?php if(auth()->guard()->check()): ?>
<?php if(auth()->user()->admin || auth()->user()->student): ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <?php if( auth()->user()->school->logo): ?>
    <link rel="shortcut icon" href="<?php echo e(asset('uploaded_files/school_logo/'.auth()->user()->school_id.'/'.auth()->user()->school->logo)); ?>" type="image/x-icon">
   <?php else: ?>
   <link rel="shortcut icon" href="<?php echo e(asset('dist/img/sp360_logo.png')); ?>" type="image/x-icon">
  <?php endif; ?>
  <title> Termly Result Report - <?php echo e(auth()->user()->school->name); ?> </title>

    <?php echo $__env->make('partials.app_css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<?php echo $__env->make('results.result_css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<body>
    <br>
    <section class="container-fluid"> <!-- container-fluid -->
        <div class="justify-content-center p-1 d-flex ">
            <button class="btn btn-primary print_docs"><i class="fa fa-print"></i>  Print Result </button>
        </div>
<?php $__empty_1 = true; $__currentLoopData = $student_results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

<?php if( $student->result_published_date() ): ?>
        <section class="card border_color page-break"> <!-- card -->   
            <section class="card-body"> <!-- card-body -->
            
            <?php echo $__env->make('results.result_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <h5 class="text-center text_color"> <b> PROGRESS REPORT </b> </h5>
                <p class="text-info text-center">
                   <b> 
                   C.A - Continuous Assessment | C/Av - Class Average <?php if( $student->show_subject_position() ): ?> | H/S - Highest Score | L/S - Lowest Score <?php endif; ?> <br>
                   <?php if($st = $student->fetch_result_assessment_format( $student->classes, $student->arms ) ): ?>
                  <span>
                   1st C.A - <?php echo e((float) $st->ca1); ?> | 
                   2nd C.A - <?php echo e((float) $st->ca2); ?> | 
                   3rd C.A - <?php echo e((float) $st->ca3); ?> |  
                   4th C.A - <?php echo e((float) $st->ca4); ?> | 
                   Exam -    <?php echo e((float) $st->exam); ?>|
                   Total - <?php echo e($st->ca1 + $st->ca2 + $st->ca3 + $st->ca4 + $st->exam); ?>

                  </span>
                   <?php endif; ?>
                 </b> 
               </p>

              <section class="row"><!-- row -->
                <section class="col-md-9"><!-- col -->
                <div class="card card-secondary card-outline"> <!-- card result sheet table -->
                        <div class="table-responsive">
                            <table class="table-striped ">
                                <thead class='text-uppercase word_no_wrap'>
                                    <tr>
                                        <th> s/n </th>
                                        <th> Subject </th>
                                        <th> 1st C.A </th>
                                        <th> 2nd C.A </th>
                                        <th> 3rd C.A </th>
                                        <th> 4th C.A </th>
                                        <th> Exam </th>
                                        <th> Total </th>
                                        <th> c/av </th>
                                        <th> Grade </th>
                                        <th> Remark </th>
                                        <?php if( $student->show_subject_position() ): ?>
                                        <th> Position </th>
                                        <th> H/S</th>
                                        <th> L/S</th>
                                        <?php endif; ?>
                                       <!-- <th> Remarks </th> -->
                                    </tr>
                                </thead>

                                <tbody class='text-capitalize'>

                                  <?php $__currentLoopData = $student->get_associated_subject_results($student->student_id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td> <?php echo e($loop->index + 1); ?> </td>
                                        <td class="text-uppercase"> <?php echo e($result->subjects); ?> </td>
                                        <td> <?php if($r1 = $result->field1): ?> <?php echo e((float) $r1); ?> <?php endif; ?> </td>
                                        <td> <?php if($r2 = $result->field2): ?> <?php echo e((float) $r2); ?> <?php endif; ?> </td>
                                        <td> <?php if($r3 = $result->field3): ?> <?php echo e((float) $r3); ?> <?php endif; ?> </td>
                                        <td> <?php if($r4 = $result->field4): ?> <?php echo e((float) $r4); ?> <?php endif; ?> </td>
                                        <td> <?php echo e((float) $result->exam_score); ?>  </td>
                                        <td> <?php echo e((float) $result->total_score); ?> </td> 
                                        <td> <?php echo e((float) $result->class_average); ?> </td>
                                        <td> <?php echo e($result->grade); ?> </td>
                                        <td> <?php echo e(strtolower( $result->comment )); ?> </td>
                                        <?php if( $student->show_subject_position() ): ?>
                                        <td class='ordinal' id='<?php echo e($result->position); ?>'> <?php echo e($result->position); ?> </td>
                                        <td> <?php echo e((float) $result->highest_score); ?> </td>
                                        <td> <?php echo e((float) $result->lowest_score); ?> </td>
                                        <?php endif; ?>
                                       <!-- <td class=''> <small> <?php echo e(strtolower($result->teachers_comment)); ?> </small> </td> -->
                                    </tr>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                   </div> <!-- /card result sheet table -->

                </section><!-- //col -->
              <?php echo $__env->make("results.key_grades", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </section> <!-- //row -->

                <?php echo $__env->make("results.result_footer", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                
            </section>
            <!-- /card-body -->
        </section> <!-- /card -->

        <?php else: ?>

        <br>
        <h6 class="text-center text-danger"><b> Result has not been Published yet! </b> </h6>

        <?php endif; ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <br>
        <h6 class="text-center text-danger"><b> Result Not Found! </b> </h6>

    <?php endif; ?>

    </section>  <!-- /container-fluid -->


</body>
</html>

<?php else: ?>
<script> window.location.href= "/logout" </script> 
<?php endif; ?>

<?php endif; ?>
<?php /**PATH /home/naijalan/sp360/app/sp360_app/resources/views/results/student_result_sheet.blade.php ENDPATH**/ ?>