<?php if(auth()->guard()->check()): ?>
<?php $user = auth()->user(); ?>
<?php if($user->admin || $user->student): ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <?php if( $user->school->logo): ?>
  <link rel="shortcut icon" href="<?php echo e(asset('uploaded_files/school_logo/'.$user->school_id.'/'.$user->school->logo)); ?>" type="image/x-icon">
  <?php else: ?>
  <link rel="shortcut icon" href="<?php echo e(asset('dist/img/sp360_logo.png')); ?>" type="image/x-icon">
  <?php endif; ?>
    <title> Annual Result Report - <?php echo e($user->school->name); ?> </title>

    <?php echo $__env->make('partials.app_css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<style>  
input, textarea, select{
  outline: none !important;
  border-top: 0 !important;
  border-left: 0 !important;
  border-right: 0 !important;
}

textarea:focus, input:focus, select:focus{
  border-color: #17a2b8 !important;
  box-shadow: 1 5px 5px 0px #17a2b8;
  -moz-box-shadow: 1 5px 5px 0px #17a2b8;
  -webkit-box-shadow: 1 5px 5px 0px #17a2b8;
  -o-box-shadow: 1 5px 5px 0px #17a2b8;
  -ms-box-shadow: 1 5px 5px 0px #17a2b8;
  -webkit-transition: all 0.4s;
  -o-transition: all 0.4s;
  -moz-transition: all 0.4s;
  transition: all 0.4s;
}
.word_no_wrap{ white-space: nowrap !important; }    
.hide{display:none;}
.img_logo_style{
 	max-height:100px !important; 
	max-width:100px !important; 
	opacity:.9;
}

<?php 
  $school = $user->school;
  $zoom_size = .85;
  $font_size = '14px';
  $font_color = "rgb(2, 2, 54)";
  $font_family = 'Verdana, Geneva, Tahoma, sans-serif';
  if( $fs = $school->css_font_size ) $font_size = $fs;
  if( $fc = $school->css_font_color ) $font_color = $fc;
  if( $ff = $school->css_font_family ) $font_family = $ff;
  if( $zs = $school->css_zoom_size ) $zoom_size = $zs;
?>
    body{zoom: <?php echo $zoom_size ?>;
         font-size: <?php echo $font_size ?>; 
         font-family: <?php echo $font_family ?>;
         font-weight: 550;
    }
    p{  
       font-size:   <?php echo $font_size   ?>; 
       font-family: <?php echo $font_family ?>;
       font-weight: 550;
    }
    h5,h6{ font-weight: 550; }
    table{ width: 100% !important;}
    th,td{ padding: 5px; 
           font-size: <?php echo $font_size ?>;
         }
    .text_color{ color: <?php echo $font_color ?>; }
    table,tr,th,td,.border_color{ border: 2px solid <?php echo $font_color ?> !important; }
    .page-break{ page-break-after: always; }
</style>

<body>
    <section class="container-fluid">
       <div class="justify-content-center d-flex mt-3 mb-1">
            <button class="btn btn-primary no_print print_docs"><i class="fa fa-print"></i>  Print Result </button>
        </div>

        <?php $__currentLoopData = $fetch_annual_results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

         <?php if( $student->result_is_published() ): ?>

        <section class="card page-break border_color">
            <div class="card-body">

              <div class="row"><!-- row Header-->
                    <div class="col-md-4"> <!-- col -->           
                      <div class="justify-content-center d-flex">
                        <?php if($user->school->logo): ?>
                         <img style="height:140px; width:auto;" class="img-thumbnil" src="<?php echo e(asset('/uploaded_files/school_logo/'.$user->school_id.'/'.$user->school->logo)); ?>"/>
                        <?php else: ?>
                        <p><i class="fa fa-flag fa-4x text_color"></i></p>
                        <?php endif; ?> 
                        </div>                
                    </div> <!-- /col -->

                    <div class="col-md-4 text-center text-capitalize text_color"> <!-- col -->
                       <h5 class='text-uppercase'> <b> <?php echo e($user->school->name); ?> </b> </h5>
                       <h6 class='text-lowercase'> <?php echo e(strtolower($user->school->motto)); ?> </h6>
                       <h6> <?php echo e(strtolower($user->school->address)); ?> </h6>
                       <h6> <?php echo e(strtolower($user->school->website)); ?> </h6>
                       <h6> <?php echo e($user->school->phone); ?>  </h6>
                    </div> <!-- /col -->

                    <div class="col-md-4"> <!-- col -->   
                       <div class="justify-content-center d-flex">
                         <?php if($passport = $student->profile($student->student_id)->photo ): ?>
                         <img style="height:140px; width:150px;" class="img-thumbnail" src="<?php echo e(asset('/uploaded_files/passports/'.$user->school_id.'/'.$passport)); ?>"/>
                         <?php else: ?>
                         <p><i class="fa fa-user-circle fa-4x text_color"></i></p>
                         <?php endif; ?>
                       </div>
                  
                    </div> <!-- /col -->
                </div> <!-- /row header -->


                <section class="card border_color mt-1"> <!-- card -->
                    <div class="card-body">
                        <div class="row text-capitalize"> <!-- row -->

                           <div class="col-md-4"><!-- col  -->
                            <?php if($s = $student->profile($student->student_id)): ?>
                             <h6> Name: <?php echo e(strtolower($s->last_name.' '.$s->first_name.' '.$s->other_name)); ?></h6>
                                <?php else: ?>
                             <h6> Name: </h6>
                             <?php endif; ?>
                           </div> <!--///col  -->

                           <div class="col-md-3"><!-- col  -->
                             <h6> Class: <?php echo e($student->classes); ?> <?php echo e($student->arms); ?></h6>    
                           </div> <!--///col  -->


                           <div class="col-md-3"><!-- col  -->
                             <h6> Session: <?php echo e(request()->sessions); ?> </h6>
                           </div> <!--///col  -->

                           <div class="col-md-2"><!-- col  -->
                            <?php if($s = $student->profile($student->student_id)): ?>
                             <h6> Gender: <?php echo e($s->gender); ?></h6>
                                <?php else: ?>
                             <h6> Gender: </h6>
                             <?php endif; ?>
                           </div> <!--///col  -->

                        </div> <!-- //row -->
                        
                    </div>
                </section> <!-- ///end card -->


                <h6 class='text_color text-center'><b> ANNUAL PROGRESS REPORT </b></h6>

                <section class="row"><!-- row -->
                    <div class="col-md-9"><!-- col -->
                    <section class="table-responsive">
                        <table class="table-condensed table-striped">
                            <thead class='text-uppercase'>
                                <tr>
                                    <th> S/N </th>
                                    <th> SUBJECT </th>
                                    <th> 1st Term <br> (100) </th>
                                    <th> 2nd Term <br> (100) </th>
                                    <th> 3rd Term <br> (100) </th>
                                    <th> Total <br> (300) </th>
                                    <th> Average Score <br> (100) </th>
                                    <th> Grade </th>
                                    <?php if( $student->show_subject_position() ): ?>
                                    <th> Subject Position </th>
                                    <?php endif; ?>
                                    <th> Remark</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $student->get_associated_subjects($student->student_id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->index + 1); ?> </td>
                                    <td class="text-uppercase"> <?php echo e($result->subject); ?> </td>
                                    <td> <?php echo e(($first = $result->first_term_score ) ? (float) $first : '-'); ?> </td>
                                    <td> <?php echo e(($second = $result->second_term_score) ? (float) $second : '-'); ?> </td>
                                    <td> <?php echo e(($third = $result->third_term_score ) ? (float) $third : '-'); ?> </td>
                                    <td> <?php echo e((float) $result->total_score); ?> </td>
                                    <td> <?php echo e((float) $result->average_score); ?> </td>
                                    <td> <?php echo e($result->grade); ?> </td>
                                    <?php if( $student->show_subject_position() ): ?>
                                    <td> <?php echo e($result->position); ?> </td>
                                    <?php endif; ?>
                                    <td> <?php echo e($result->comment); ?> </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th></th>
                                    <th> TOTAL </th>
                                    <th> <?php echo e((float) $student->first_term_subject_total); ?> </th>
                                    <th> <?php echo e((float) $student->second_term_subject_total); ?>  </th>
                                    <th> <?php echo e((float) $student->third_term_subject_total); ?> </th>
                                    <th> <?php echo e((float) $student->total_subject_score); ?> </th>
                                    <th colspan="4"> AVERAGE =  <?php echo e((float) $student->average_score); ?> % </th>
                                </tr>
                            </tfoot>
                        </table>
                        </section>
                    </div><!-- //col -->

                    <div class="col-md-3"><!-- col -->

                    <p class="text-center text_color"> <b> KEY GRADES </b> </p>
                    <div class="table-responsive">
                        <table class="table-condensed table-striped">
                            <tbody>
                                <?php $__currentLoopData = $grades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class='text-capitalize'>
                                    <td> <?php echo e($grade->grade); ?> </td>
                                    <td> <?php echo e($grade->comment); ?> </td>
                                    <td> <?php echo e((float)$grade->min_score.' - '. (float)$grade->max_score); ?> </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    </div><!-- //col -->
                </section> <!-- //row -->


               <section class="border_color mt-2 card card-secondary card-outline">
                   <div class="card-body">
                       <div class="row"> <!-- row -->
                       
                           <!-- <div class="col-md-12"> 
                             <h6 class=""> Class Teacher's Remark: </h6>
                               <form id="teachers_comment_form-<?php echo e($student->id); ?>">
                                   <?php echo csrf_field(); ?>
                                   <input type="hidden" value="<?php echo e($student->id); ?>" name="user_id">
                                   <input type="hidden" value="<?php echo e($user->school->id); ?>" name="school_id">
                                   <input type="hidden" value="1" name="status">
                                   <input type="hidden" value="<?php echo e(request()->classes); ?>" name="classes">
                                   <input type="hidden" value="<?php echo e(request()->sessions); ?>" name="sessions">
                                   <input type="hidden" value="1" name="annual_result_comment">
                                <div class="input-group">
                                <div class="custom-file"> 
                                  <?php if($user->student): ?>
                                  <p class='pl-2'> <em> <?php echo e($student->annual_result_teachers_comment($student->id)); ?> </em> </p>
                                  <?php else: ?>
                                  <input type="text" name='teachers_comment' value="<?php echo e($student->annual_result_teachers_comment( $student->id )); ?>" class="form-control">
                                  <?php endif; ?> 
                            
                                </div>

                                <div class="input-group-append">
                                 <?php if($user->staff): ?>
                                   <button type="button" onClick="update_teachers_comment(<?php echo $student->id ?>)"  class="no_print btn-block btn btn-success btn-sm">
                                    <i class="fa fa-spin fa-spinner hide" id="teachers_loader-<?php echo e($student->id); ?>"></i>  
                                    <i class="fa fa-check hide" id="success_icon1-<?php echo e($student->id); ?>"></i> Save 
                                  </button>
                                <?php endif; ?>
                               </div>
                           </form>
                            </div>
                            <br>
                            </div>  -->



                            
                            <div class="col-md-12"> <!-- col -->
                               <h6 class=""> <?php if($user->school->type == "secondary"): ?> Principal's Remark:  <?php else: ?> Head Teacher's Remark: <?php endif; ?> </h6>
                               <form id='admin_comment_form-<?php echo e($student->id); ?>'>
                                   <?php echo csrf_field(); ?>
                                   <input type="hidden" value="<?php echo e($student->id); ?>" name="user_id">
                                   <input type="hidden" value="<?php echo e($user->school->id); ?>" name="school_id">
                                   <input type="hidden" value="1" name="status">
                                   <input type="hidden" value="<?php echo e(request()->classes); ?>" name="classes">
                                   <input type="hidden" value="<?php echo e(request()->sessions); ?>" name="sessions">
                                   <input type="hidden" value="1" name="annual_result_comment">
                               <div class="input-group">
                              <div class="custom-file">  
                                 <?php if($user->student): ?>
                                 <p class='pl-2'> <em> <?php echo e($student->annual_result_admin_comment( $student->id )); ?> </em>  </p>
                                 <?php else: ?>
                                 <input value="<?php echo e($student->annual_result_admin_comment( $student->id )); ?>" type="text" name='principal_comment' class="form-control">
                                 <?php endif; ?>
                              </div>

                              <div class="input-group-append">
                                 <?php if($user->admin): ?>
                                  <button type="button" onClick="update_admin_comment(<?php echo $student->id ?>)" class="no_print btn-block btn btn-info btn-sm">
                                  <i class="fa fa-spin fa-spinner hide" id="admin_loader-<?php echo e($student->id); ?>"></i>  
                                  <i class="fa fa-check hide" id="success_icon2-<?php echo e($student->id); ?>"></i> Save 
                                  </button>
                                 <?php endif; ?>
                               </div>
                            </form>

                            </div>

                            </div> <!-- //col -->

                            <div class="col-md-6 mt-2">
                             <?php if( $s = $student->result_signature() ): ?>
                              <img src="<?php echo e(asset('/uploaded_files/signatures/'.auth()->user()->school_id.'/'.$s)); ?>" style='height:40px; width:100px;'> <br>
                              <em> <?php echo e(date('d/m/Y')); ?> </em>
                              <br> <span class=""> <b> <?php if($user->school->type == "secondary"): ?> Principal's <?php else: ?> Head Teacher's <?php endif; ?> Sign/Date </b> </span>
                             <?php endif; ?>
                            </div>

                            <div class="col-md-6 mt-2">
                                <h6 class=''> Promotion Status: <em> <?php echo $student->promotion_status($student->average_score) ?>  </em></h6>
                            </div>

                       </div><!-- ///row -->       
                   </div>
               </section>

            </div>
        </section>
        <?php else: ?>
        <p class="text-center text-danger"> RESULT HAS NOT BEEN PUBLISHED !</p>
        <?php endif; ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </section>

      
    <script>
        $(function(){
           $(window).click( () => { $('.no_print').show()});
            $('.print_docs').click( () => {
                $('.no_print').hide();
                window.print();
            });
        });
              
        function update_admin_comment(id){
            var loader = $('#admin_loader-'+id);
                loader.show();
            var url = "/zytwshn3y88w832bd7-glsgvg151816nmjklyp";
            var data = $('#admin_comment_form-'+id).serialize();
            $.post(url, data, function(res){
                if(res.error) return alert('Comment did not save, Something went wrong...');
                loader.hide();
                $('#success_icon2-'+id).show();
            });
        }

        function update_teachers_comment(id){
            var loader = $('#teachers_loader-'+id);
                loader.show();
            var url = "/zytwshn3y88w832bd7-glsgvg151816nmjklyp";
            var data = $('#teachers_comment_form-'+id).serialize();
            $.post(url, data, function(res){
                if(res.error) return alert('Comment did not save, Something went wrong...');
                loader.hide();
                $('#success_icon1-'+id).show();
            });
        }
       
    </script>
</body>

</html>
<?php endif; ?>

<?php endif; ?>
<?php /**PATH /home/naijalan/sp360/app/sp360_app/resources/views/results/annual_result_sheet.blade.php ENDPATH**/ ?>