<?php

use App\Http\Controllers\Traits\my_school_data;
use App\models\fee_revenue;
use App\User;
use Illuminate\Support\Facades\Route;



//====start ====///

/// === RUN AUTO RESULT GRADING AND COMMENTS/REMARKS ====///
use App\models\grade;
use App\models\subject_result;

Route::get("_ugr_", function(){
    $results = subject_result::whereSchool_id( auth()->user()->school_id )->get();
    $grades = grade::whereSchool_id( auth()->user()->school_id )->get();
    $grade = "";
    $grade_comment = "";

    foreach( $results as $index => $student ){
        foreach($grades as &$g):
            if($student->total_score >= $g->min_score && $student->total_score <= $g->max_score):
                $grade = $g->grade;
                $grade_comment = $g->comment;
            else:
                continue;
            endif;
            $student->update(['grade'=> $grade, 'comment' => $grade_comment]) ;
            if ( ! $student ): 
                echo $index." - Failed: \n". $student->student_name. " \n".$student->classes. ' '.$student->arms. " \n ". $student->subjects . " \n ".$student->total_score;
            else:
                echo $index. " - Success: \n". $student->student_name. " \n".$student->classes. ' '.$student->arms. " \n ". $student->subjects . " \n ".$student->total_score;
                echo "<hr> <hr>";
            endif;
        endforeach; 
    }
    echo " <hr>";
    echo " Total Computed records : (".$results->count().")";
    return " Transaction completed";
});

///====== END =====////




// zytwshn3y88w832bd7-glsgvg(100)816nmjklyp // This is the initial route hashed format with the number in bracket incrementing by 1 for each routes
/**
 * Login / Logout, ACTIVITY LOGS and dashboard route
 */
Route::get('/page/dashboard/{any?}', 'HomeController@index')->name('dashboard');
Route::get('/zytwshn3y88w832bd7-glsgvg101816nmjklyp', 'HomeController@fetch_my_activity_logs');
Route::get('/', 'LoginController@index')->name('login');
Route::post('/zytwshn3y88w832bd7-glsgvg102816nmjklyp', 'LoginController@login_user')->name('login_user');
Route::get('/logout', 'HomeController@logout')->name('logout');
Route::get('/password_reset', 'LoginController@password_reset_page')->name('password_reset_page');
Route::post('/y343twshn3y88w832bd7', 'LoginController@reset_password')->name('reset_password');
Route::get('/account_suspended', function(){
      return view("account_deactivated");
});

/**
 * fetch user profile routes / fetch_all_class_subject_arm_sessions_data
 */
Route::get('/zytwshn3y88w832bd7-glsgvg103816nmjklyp', 'HomeController@fetch_all_class_subject_arm_sessions_data');
Route::get('/zytwshn3y88w832bd7-glsgvg104816nmjklyp', 'HomeController@fetch_user_profile');
Route::post('/zytwshn3y88w832bd7-glsgvg105816nmjklyp', 'ProfileController@update_user_profile');
Route::post('/zytwshn3y88w832bd7-glsgvg106816nmjklyp', 'ProfileController@update_user_password'); 
Route::post('/zytwshn3y88w832bd7-glsgvg107816nmjklyp', 'ProfileController@update_user_passport'); 
Route::post('/zytwshn3y88w832bd7-glsgvg108816nmjklyp', 'ProfileController@update_school_info'); 

/**
 * Vuejs api Admin Routes 
 */
Route::group(['namespace' => 'Admin'],function(){
    Route::middleware('auth')->group( function() { 
      Route::get('/zytwshn3y88w832bd7-glsgvg109816nmjklyp', 'DashboardController@fetch_dashboard_statistics');
      /**
       * General actions
       * grant_access_to_user_to_edit_profile
       * deny_access_to_user_to_edit_profile
       * delete_users , activate users , de-activate users
       */
      Route::post('/zytwshn3y88w832bd7-glsgvg110816nmjklyp', 'IndexController@grant_access_to_user_to_edit_profile');
      Route::post('/zytwshn3y88w832bd7-glsgvg111816nmjklyp', 'IndexController@deny_access_to_user_to_edit_profile');
      Route::post('/zytwshn3y88w832bd7-glsgvg112816nmjklyp', 'IndexController@delete_users'); 
      Route::post('/zytwshn3y88w832bd7-glsgvg113816nmjklyp', 'IndexController@activate_user');
      Route::post('/zytwshn3y88w832bd7-glsgvg114816nmjklyp', 'IndexController@de_activate_user');
      Route::post('/zytwshn3y88w832bd7-glsgvg115816nmjklyp/{id}', 'IndexController@reset_password');
      Route::post('/zytwshn3y88w832bd7-glsgvg116816nmjklyp', 'IndexController@make_admin');
      Route::post('/zytwshn3y88w832bd7-glsgvg117816nmjklyp', 'IndexController@remove_admin');
      Route::post('/zytwshn3y88w832bd7-glsgvg118816nmjklyp', 'IndexController@make_accountant');
      Route::post('/zytwshn3y88w832bd7-glsgvg119816nmjklyp', 'IndexController@remove_accountant');
      Route::post('/zytwshn3y88w832bd7-glsgvg120816nmjklyp', 'IndexController@class_promotion');
      /***
       * Class settings / Managements
       */
      Route::post('/zytwshn3y88w832bd7-glsgvg121816nmjklyp', 'Class_subjectController@delete_subject_group');
      Route::post('/zytwshn3y88w832bd7-glsgvg122816nmjklyp', 'Class_subjectController@store_subject_group');  
      Route::post('/zytwshn3y88w832bd7-glsgvg123816nmjklyp', 'Class_subjectController@store_class');
      Route::post('/zytwshn3y88w832bd7-glsgvg124816nmjklyp', 'Class_subjectController@store_subject');
      Route::post('/zytwshn3y88w832bd7-glsgvg125816nmjklyp', 'Class_subjectController@delete_subjects');
      Route::post('/zytwshn3y88w832bd7-glsgvg126816nmjklyp', 'Class_subjectController@delete_classes');
      Route::post('/zytwshn3y88w832bd7-glsgvg127816nmjklyp', 'Class_subjectController@store_arm');
      Route::post('/zytwshn3y88w832bd7-glsgvg128816nmjklyp', 'Class_subjectController@delete_arms');
      Route::post('/zytwshn3y88w832bd7-glsgvg129816nmjklyp', 'Class_subjectController@store_houses');
      Route::post('/zytwshn3y88w832bd7-glsgvg130816nmjklyp', 'Class_subjectController@delete_houses');
      Route::post('/zytwshn3y88w832bd7-glsgvg131816nmjklyp', 'Class_subjectController@update_school_subjects');  
      /****
       * ======
       * Students management routes 
       * ============
       */ 
      Route::get('/fetch_all_students', 'StudentsMgtController@fetch_all_students');
      Route::post('/zytwshn3y88w832bd7-glsgvg133816nmjklyp', 'IndexController@register_student');
      Route::post('/zytwshn3y88w832bd7-glsgvg134816nmjklyp', 'IndexController@import_students_via_excel');
      /***
       * =========
       *  Staff Management Routes 
       * ========
       */  
      Route::post('/zytwshn3y88w832bd7-glsgvg136816nmjklyp', 'IndexController@import_staff_via_excel');
      Route::get('/fetch_all_staff', 'StaffMgtController@fetch_all_staff');
      Route::post('/zytwshn3y88w832bd7-glsgvg138816nmjklyp', 'IndexController@register_staff');
      Route::post('/zytwshn3y88w832bd7-glsgvg139816nmjklyp', 'StaffMgtController@assign_class_and_subjects_to_staff');
      Route::get('/view_all_class_and_subjects_assigned_to_this_staff', 'StaffMgtController@view_all_class_and_subjects_assigned_to_this_staff');
      Route::post('/zytwshn3y88w832bd7-glsgvg141816nmjklyp', 'StaffMgtController@delete_staff_class_and_subjects');
      Route::get('/zytwshn3y88w832bd7-glsgvg142816nmjklyp', 'StaffMgtController@fetch_form_teachers');
      Route::post('/zytwshn3y88w832bd7-glsgvg143816nmjklyp', 'StaffMgtController@store_form_teachers');
      Route::post('/zytwshn3y88w832bd7-glsgvg144816nmjklyp', 'StaffMgtController@delete_form_teachers');
      Route::post('/zytwshn3y88w832bd7-glsgvg145816nmjklyp', 'StaffMgtController@fetch_all_attendance_records');
      /***
       * =========================================
       * Result management controller / check students results 
       * =====================================
       */
      Route::get('/available-results','ResultMgtController@available_class_results');
      Route::post('/zytwshn3y88w832bd7-glsgvg146816nmjklyp', 'ResultMgtController@update_annual_result_teachers_comment');
      Route::post('/zytwshn3y88w832bd7-glsgvg147816nmjklyp', 'ResultMgtController@update_annual_result_admin_comment');
      Route::get('/zytwshn3y88w832bd7-glsgvg148816nmjklyp', 'ResultMgtController@fetch_assessment_scores'); 
      Route::post('/zytwshn3y88w832bd7-glsgvg149816nmjklyp', 'ResultMgtController@delete_assessment_scores');
      Route::post('/zytwshn3y88w832bd7-glsgvg150816nmjklyp', 'ResultMgtController@store_assessment_scores');
      Route::post('/zytwshn3y88w832bd7-glsgvg151816nmjklyp', 'ResultMgtController@update_broad_sheet_result_comment');
      Route::get('/view-class-broad-sheet', 'ResultMgtController@view_class_broad_sheet')->name('view_class_broadsheet');
      Route::get('/class-termly-result-report-sheet', 'ResultMgtController@fetch_class_termly_result');
      Route::get('/class-annual-result-report-sheet', 'ResultMgtController@fetch_class_annual_results');
      Route::get('/check_subject_results', 'ResultMgtController@check_subject_results');
      Route::get('/check_lowest_highest_scores_for_subject_results', 'ResultMgtController@check_lowest_highest_scores_for_subject_results');
      /**
       * Result and Grade management settings ====
       * ==========
       */
      Route::post('/zytwshn3y88w832bd7-glsgvg158816nmjklyp', 'ResultMgtController@delete_term_and_sessions');
      Route::post('/zytwshn3y88w832bd7-glsgvg159816nmjklyp', 'ResultMgtController@create_new_session');
      Route::post('/zytwshn3y88w832bd7-glsgvg160816nmjklyp', 'ResultMgtController@activate_session');
      Route::post('/zytwshn3y88w832bd7-glsgvg161816nmjklyp', 'ResultMgtController@de_activate_session');
      Route::post('/zytwshn3y88w832bd7-glsgvg162816nmjklyp', 'ResultMgtController@publish_result');
      Route::post('/zytwshn3y88w832bd7-glsgvg163816nmjklyp', 'ResultMgtController@undo_publish_result');
      Route::post('/zytwshn3y88w832bd7-glsgvg164816nmjklyp', 'ResultMgtController@delete_result_grading');
      Route::post('/zytwshn3y88w832bd7-glsgvg165816nmjklyp', 'ResultMgtController@store_result_grading');
      Route::post('/zytwshn3y88w832bd7-glsgvg166816nmjklyp', 'ResultMgtController@delete_result_comment');
      Route::post('/zytwshn3y88w832bd7-glsgvg167816nmjklyp', 'ResultMgtController@store_result_comment');
      Route::post('/zytwshn3y88w832bd7-glsgvg168816nmjklyp', 'ResultMgtController@store_new_resumption_date');
      Route::post('/zytwshn3y88w832bd7-glsgvg169816nmjklyp', 'ResultMgtController@delete_resumption_date');
      Route::post('/zytwshn3y88w832bd7-glsgvg170816nmjklyp', 'ResultMgtController@upload_signature');
      Route::post('/zytwshn3y88w832bd7-gvg170816rteqnmjklyp', 'ResultMgtController@update_academic_result_settings');
      
      Route::get('/fetch_sch_sessions', 'ResultMgtController@fetch_sch_sessions');
    });
  });

/**
 * Vuejs api Staff Routes 
 */
Route::group(['namespace' => 'Staff'], function(){
    Route::middleware('auth')->group( function(){ 
      Route::post('/zytww832bd7-glsgvg1416nmjklyp','StaffController@store_cbt_scores_in_subject_result');
      Route::get('/fetch_staff_classes_and_subjects', 'StaffController@fetch_staff_classes_and_subjects');
      Route::get('/get_all_students_of_this_class', 'StaffController@get_all_students_of_this_class');
      Route::post('/zytwshn3y88w832bd7-glsgvg200816nmjklyp', 'StaffController@store_students_result');
      Route::post('/zytwshn3y88w832bd7-glsgvg201816nmjklyp', 'StaffController@fetch_subject_results');
      Route::post('/zytwshn3y88w832bd7-glsgvg202816nmjklyp', 'StaffController@update_subject_result');
      Route::post('/zytwshn3y88w832bd7-glsgvg203816nmjklyp', 'StaffController@delete_subject_result');
      Route::get('/zytwshn3y88w832bd7-glsgvg204816nmjklyp',  'StaffController@fetch_my_form_teacher_classes');
      Route::post('/zytwshn3y88w832bd7-glsgvg205816nmjklyp', 'StaffController@fetch_students_in_this_form_teachers_class');
      Route::post('/zytwshn3y88w832bd7-glsgvg206816nmjklyp', 'StaffController@store_students_attendance');
      Route::post('/zytwshn3y88w832bd7-glsgvg207816nmjklyp', 'StaffController@view_attendance_records');
      Route::post('/zytwshn3y88w832bd7-glsgvg208816nmjklyp', 'StaffController@fetch_students_of_this_class');

      /**
       * LESSON NOTES
       */
      Route::post('/zytwshn3y88w832bd7-glsgvg209816nmjklyp', 'Lesson_noteController@store_lesson_note');
      Route::get('/zytwshn3y88w832bd7-glsgvg210816nmjklyp', 'Lesson_noteController@index');
      Route::post('/zytwshn3y88w832bd7-glsgvg211816nmjklyp', 'Lesson_noteController@update_lesson_note');
      Route::post('/zytwshn3y88w832bd7-glsgvg212816nmjklyp', 'Lesson_noteController@delete_lesson_note');
      Route::get('/zytwshn3y88w832bd7-glsgvg213816nmjklyp', 'Lesson_noteController@view_lesson_note');
      Route::post('/zytwshn3y88w832bd7-glsgvg214816nmjklyp', 'Lesson_noteController@publish_lesson_note');
      Route::post('/zytwshn3y88w832bd7-glsgvg215816nmjklyp', 'Lesson_noteController@undo_publish_lesson_note');
    });
  });

/**
 * Vuejs api Super Admin Routes 
 */
Route::group(['namespace' => 'Super_admin'],function(){
    Route::middleware('auth')->group( function() {
      Route::post('/store_school', 'IndexController@store_school'); 
      Route::post('/acwg7GFCPmfdMEpsht5u841rOkeJnyA30Ljq9vboI6NizxBlHD2K5e5441b8b873esdijifw2468724924uhegfiweexybn3478yutd', 'IndexController@activate_schools'); 
      Route::post('/de_activate_schools', 'IndexController@de_activate_schools');
      Route::get('/fetch_all_schools', 'IndexController@fetch_all_schools'); 
      Route::post('/acwg7GFCPmfdMEpsht5u841rOkeJnyA30Ljq9vboI6NizxBlHD2e5441b8b873esdijifw2468724924uhegfiweexybn3478yutd', 'IndexController@store_school_admin'); 
      Route::get('/fetch_info_and_stats_about_this_school/{school_id}', 'IndexController@fetch_info_and_stats_about_this_school'); 
      Route::post('/PmfdMnyA30Ljq9vboI6NizxBlHD2e5441b8b873esdijifw2__452', 'IndexController@update_school_details'); 
    });
  });

  /**
   * Online classroom routes
  */
Route::group(['namespace' => 'Online_class'], function(){
  Route::middleware('auth')->group( function() {
    Route::post('/zytwshn3y88w832bd7-glsgvg300816nmjklyp', 'ClassroomController@store_classroom'); 
    Route::get('/zytwshn3y88w832bd7-glsgvg301816nmjklyp', 'ClassroomController@fetch_classroom');
    Route::post('/zytwshn3y88w832bd7-glsgvg302816nmjklyp', 'ClassroomController@find_this_online_classroom');
    Route::post('/zytwshn3y88w832bd7-glsgvg303816nmjklyp', 'ClassroomController@delete_this_online_classroom');
    Route::get('/zytwshn3y88w832bd7-glsgvg304816nmjklyp', 'ClassroomController@fetch_all_classrooms_i_belong_to');
    Route::post('/zytwshn3y88w832bd7-glsgvg305816nmjklyp', 'ClassroomController@ensure_user_is_a_member_of_this_class');
    
    /**
     * Classroom posts and file uploads routes
     */
    Route::post('/zytwshn3y88w832bd7-glsgvg400816nmjklyp', 'ClassroomController@store_post');
    Route::post('/zytwshn3y88w832bd7-glsgvg401816nmjklyp', 'ClassroomController@fetch_this_classroom_posts');
    Route::post('/zytwshn3y88w832bd7-glsgvg402816nmjklyp', 'ClassroomController@delete_this_post');
    Route::post('/zytwshn3y88w832bd7-glsgvg403816nmjklyp', 'ClassroomController@remove_user_from_classroom');
    Route::post('/zytwshn3y88w832bd7-glsgvg405816nmjklyp', 'ClassroomController@add_user_to_classroom');
    Route::post('/zytwshn3y88w832bd7-glsgvg406816nmjklyp', 'ClassroomController@store_classroom_post_files'); 
    Route::post('/zytwshn3y88w832bd7-glsgvg407816nmjklyp', 'ClassroomController@delete_classroom_files');
    Route::post('/zytwshn3y88w832bd7-glsgvg408816nmjklyp', 'ClassroomController@check_if_user_can_upload_file_and_make_posts');
    Route::post('/zytwshn3y88w832bd7-glsgvg409816nmjklyp', 'ClassroomController@update_classroom_user_upload_settings');
    Route::post('/zytwshn3y88w832bd7-glsgvg410816nmjklyp', 'ClassroomController@update_classroom_user_post_settings'); 
  });
});

/**
 * 
 * CBT/ONLINE EXAM ROUTES
 */
Route::group(['namespace' => "Exams"], function(){
  Route::middleware('auth')->group( function() {
    Route::post("/zytwshn3y88w832bd7-glsgvg500816nmjklyp", "Exam_setupController@store_new_cbt_exam");
    Route::post("/zytwshn3y88w832bd7-glsgvg501816nmjklyp", "Exam_setupController@delete_cbt_exams");
    Route::get("/fetch_my_created_exams", "Exam_setupController@fetch_my_created_exams");
    Route::get("/fetch_all_created_exams", "Exam_setupController@fetch_all_created_exams");
    Route::post("/zytwshn3y88w832bd7-glsgvg502816nmjklyp", "Exam_setupController@publish_cbt_exam");
    Route::post("/zytwshn3y88w832bd7-glsgvg503816nmjklyp", "Exam_setupController@undo_publish_cbt_exam");
    Route::get("/zytwshn3y88w832bd7-glsgvg504816nmjklyp", "Exam_setupController@fetch_this_exam_questions");
    Route::post("/zytwshn3y88w832bd7-glsgvg505816nmjklyp", "Exam_setupController@update_exam_question");
    Route::post("/zytwshn3y88w832bd7-glsgvg506816nmjklyp", "Exam_setupController@store_exam_question");
    Route::post("/zytwshn3y88w832bd7-glsgvg507816nmjklyp", "Exam_setupController@delete_exam_question");
    Route::get("/zytwshn3y88w832bd7-glsgvg508816nmjklyp", "Exam_setupController@fetch_single_question");
    Route::post("/zytwshn3y88w832bd7-glsgvg509816nmjklyp", "ExamController@fetch_student_available_exams");
    Route::post("/zytwshn3y88w832bd7-glsgvg510816nmjklyp", "ExamController@store_student");
    Route::post("/zytwshn3y88w832bd7-glsgvg511816nmjklyp", "ExamController@get_student_exam_detail");
    Route::post("/zytwshn3y88w832bd7-glsgvg512816nmjklyp", "ExamController@store_student_exam_answer");
    Route::get("/zytwshn3y88w832bd7-glsgvg513816nmjklyp", "ExamController@get_number_of_total_questions_answered");
    Route::get("/zytwshn3y88w832bd7-glsgvg514816nmjklyp", "ExamController@get_all_students_who_took_this_exam");
    Route::post("/zytwshn3y88w832bd7-glsgvg515816nmjklyp", "ExamController@fetch_student_exam_answers");
    Route::post("/zytwshn3y88w832bd7-glsgvg516816nmjklyp", "Exam_setupController@update_cbt_exam");
    Route::post("/zytwshn3y88w832bd7-glsgvg517816nmjklyp", "ExamController@remove_student_from_this_exam");
    Route::post("/zytwshn3y88w832bd7-glsgvg518816nmjklyp", "ExamController@delete_student_answer");
  }); 
});

Route::get("/zytwshn3y88w832bd7-glsgvg000816nmjklyprtu6", function(){
  $my_fees = new fee_revenue;
  $user = auth()->user();
  return $my_fees->whereSchool_id( $user->school_id )->whereStudent_id( $user->id )->latest('updated_at')->get();
})->middleware('auth');

///=== MAIL/NEWS LETTER SECTION ===///
Route::post("/zytwshn3y88w832bd7_7ygwdyu54gw-glsgvg100814nmjklyp", "MailController@store_mail");
Route::post("/zytwshn3y88w832bd7_7ygwdyu54gw-glsgvg100815nmjklyp", "MailController@delete_mail");
Route::get("/zytwshn3y88w832bd7_7ygwdyu54gw-glsgvg100816nmjklyp", "MailController@fetch_mail");
Route::get("/zytwshn3y88w832bd7_7ygwdyu54gw-gls314s816nmjklyp", "MailController@view_mail");

///=== SMS MANAGER ====///
Route::get("/zytwshn3y88w832bd7_7T533314s816nmjklyp", "SmsController@fetch_all_students");
Route::get("/zytws692ey88w832bd7_7T533s816nmjklyp", "SmsController@fetch_all_staff");

/***
 * 
 * Incase Students Arms ain't displaying very well, run this url to set all Arms to null instead of "" string =====//
 * 
 **/
Route::get("/update_user_arms_", function(){
    $update = User::whereTarget_arm("")
                  ->orWhere("target_arm", null)
                  ->update(['target_arm'=> null]);
    return ! $update ? "Failed" : "Success";
});

