@auth

@if(auth()->user()->admin || auth()->user()->student)

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    @if( auth()->user()->school->logo)
  <link rel="shortcut icon" href="{{asset('uploaded_files/school_logo/'.auth()->user()->school_id.'/'.auth()->user()->school->logo)}}" type="image/x-icon">
  @else
  <link rel="shortcut icon" href="{{asset('dist/img/sp360_logo.png')}}" type="image/x-icon">
  @endif
    <title> Termly Result Report - {{ auth()->user()->school->name }} </title>

    @include('partials.app_css')
</head>
@include('results.result_css')
<body>
    <br>
    <section class="container-fluid"> <!-- container-fluid -->
        <div class="justify-content-center p-1 d-flex ">
            <button class="btn btn-primary print_docs"><i class="fa fa-print"></i>  Print Result </button>
        </div>

@forelse($student_results as $student)

@if( $student->result_published_date() )
        <section class="card border_color page-break"> <!-- card -->   
            <section class="card-body"> <!-- card-body -->

            @include('results.result_header')

                <h5 class="text-center text_color"> <b> PROGRESS REPORT </b> </h5>
                <p class="text-info text-center">
                   <b> 
                   C.A - Continuous Assessment | C/Av - Class Average @if( $student->show_subject_position() ) | H/S - Highest Score | L/S - Lowest Score @endif <br>
                   @if($st = $student->fetch_result_assessment_format( $student->classes, $student->arms ) )
                  <span>
                   1st C.A ({{ $st->ca1 }}) - 
                   2nd C.A ({{ $st->ca2 }}) - 
                   3rd C.A ({{ $st->ca3 }}) -  
                   Exam ({{ $st->exam }})   -
                   Total = {{ $st->ca1 + $st->ca2 + $st->ca3 + $st->ca4 + $st->exam}}
</span>
                   @endif
                 </b> 
</p>

            <section class="row"><!-- row -->
             <section class="col-md-9"><!-- col -->
                <div class="card card-secondary card-outline"> <!-- card result sheet table -->
                        <div class="table-responsive">
                            <table class="table-striped">
                                <thead class='text-uppercase'>
                                    <tr>
                                        <th> # </th>
                                        <th> Subject </th>
                                        <th> 1st C.A </th>
                                        <th> 2nd C.A </th>
                                        <th> 3rd C.A </th>
                                        <th> Exam </th>
                                        <th> Total </th>
                                        <th> c/av </th>
                                        <th> Grade </th>
                                        <th> Remark </th>
                                        @if( $student->show_subject_position() )
                                        <th> Position </th>
                                        <th> H/S </th>
                                        <th> L/S </th>
                                        @endif
                                        <!-- <th> Remarks </th> -->
                                    </tr>
                                </thead>

                                <tbody class='text-capitalize'>

                                  @foreach( $student->get_associated_subject_results($student->student_id) as $result )
                                    <tr>
                                        <td> {{ $loop->index + 1 }} </td>
                                        <td class="text-uppercase"> {{ strtolower( $result->subjects )}} </td>
                                        <td> @if($r1 = $result->field1) {{ (float) $r1 }} @endif </td>
                                        <td> @if($r2 = $result->field2) {{ (float) $r2 }} @endif </td>
                                        <td> @if($r3 = $result->field3) {{ (float) $r3 }} @endif </td>
                                        <td> {{ (float) $result->exam_score }}  </td>
                                        <td> {{ (float) $result->total_score }} </td> 
                                        <td> {{ (float) $result->class_average }} </td>
                                        <td> {{ $result->grade }} </td>
                                        <td> {{ strtolower( $result->comment ) }} </td>
                                        @if( $student->show_subject_position() )
                                        <td class='ordinal' id='{{ $result->position }}'> {{ $result->position }} </td>
                                        <td> {{ (float) $result->highest_score }} </td>
                                        <td> {{ (float) $result->lowest_score }} </td>
                                        @endif
                                        <!-- <td class=''> <small> {{ strtolower($result->teachers_comment) }} </small> </td> -->
                                    </tr>

                                  @endforeach

                                </tbody>
                            </table>
                        </div>
                </div> <!-- /card result sheet table -->

                </section><!-- //col -->
              @include("results.key_grades")
            </section> <!-- //row -->
                @include("results.result_footer")

            </section>
            <!-- /card-body -->
        </section> <!-- /card -->

        @else

        <br>
        <h6 class="text-center text-danger"><b> Result has not been Published yet! </b> </h6>

        @endif

        @empty
        <br>
        <h6 class="text-center text-danger"><b> Result Not Found! </b> </h6>

    @endforelse

    </section>  <!-- /container-fluid -->

</body>
</html>

@else
<script> window.location.href= "/logout" </script>
@endif

@endauth


