@auth
<!DOCTYPE html>
<html lang="en">
@if(auth()->user()->staff)

<?php 
$user = auth()->user(); 
$term = "&term=".request()->term;
$session = "&sessions=".request()->sessions;
$class = "&classes=".request()->classes;
$arm = "&arms=".request()->arms;
$school_id = "&school_id=".$user->school_id;
$url = "/class-termly-result-report-sheet?view_class_results=1".$arm.$class.$term.$school_id.$session;
$school_logo = asset("/uploaded_files/school_logo/".$user->school_id."/".$user->school->logo);
?>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="shortcut icon" href="{{$school_logo}}" type="image/x-icon"> 
    <title> Class Broadsheet - {!! auth()->user()->school->name !!} </title>
    @include('partials.app_css')
</head>

<style>
body{ zoom:90%; font-size: 14px; font-weight: 550;}
table{ width:100% !important}
.word_no_wrap{ white-space: nowrap !important; }
thead tr th div, .vertical{
        writing-mode: vertical-rl;
        text-orientation: sideways-right;
        transform: rotate(180deg);
        text-align:left;
        height:auto;
        width:auto;
        display: block;
        padding-left:5px; 
}
.hide{display:none;}
.img_logo_style{
 	max-height:100px !important; 
	max-width:100px !important; 
	opacity:.9;
}
.bg_img{
    background:url({{$school_logo}});
    background-repeat: no-repeat;
    background-position:center;
    display: auto;
    opacity:1;
}
table,tr,th,td{ border: 2px solid rgb(3, 3, 73) !important; }  
</style>

<body>
    <section class="container-fluid mt-4" id="print_div">
        <h4 class="text-center">
            @if($user->school->logo)
            <img class='img_logo_style' src="{{$school_logo}}">
            @endif
            <br>
            <span class="text-uppercase"> <b> {!! $user->school->name !!} </b> </span>
        </h4>
    <h6 class='text-center text-uppercase '> {{ request()->term }} REPORT SHEET ({{ request()->sessions }} ACADEMIC SESSION) </h6>
    <h6 class='text-center text-uppercase '> Summary Scores and Positions for <b> {{ request()->classes}} {{ request()->arms }} </b> </h6>
               <div class="justify-content-center d-flex">
                   <a href="{{url()->previous()}}" class="toggle_docs btn btn-outline-secondary"> <i class="fa fa-arrow-left"></i> Go back </a> &nbsp;
                   <button class="btn btn-outline-info toggle_docs print_docs"> <i class="fa fa-print"></i> Print Broad sheet </button> &nbsp;
                   <button class="btn btn-outline-primary toggle_docs toggle_class_position"> <i class="fa fa-edit"></i> Show/Hide Positions </button> &nbsp;
                   @if($user->admin)
                   <a href="{{$url}}" target="_blank" class="toggle_docs btn btn-outline-success"> <i class="fa fa-list-alt"></i> View Progress Report </a>
                   @endif
               </div>

               @if($user->admin)
                <section class='text-center remarks mt-3 mb-2 row'>
                    <div class="col-md-12">
                       <h6 title="Publishing your school result will allow students have access to it...">
                         Do you want to publish your school result now? <br>
                        <a href="/page/dashboard/results-management-settings" class="btn btn-sm btn-outline-info"> Yes, i want to </a>
                       </h6>
                    </div>           
                </section>
                @endif
    </section>

    <section class='mt-4 mb-5 container-fluid'>
       @if($students->count()) 

       <table class='table_custom_bordered table-striped table-hover table-condensed'>
            <thead class='word_no_wrap'>
                <tr>
                    <th> S/N </th>
                    <th> Names </th> 
                    <th class='remarks'> <div class="vertical"> Class </div> </th>             
                    @foreach($subjects as $subject)
                    <th class=' text-uppercase text-center word_no_wrap'> <div class="vertical"> {{ $subject }} </div> </th>
                    @endforeach
                    <th class='text-capitalize text-center'> <div class="vertical"> Total </div> </th>
                    <th class='text-capitalize text-center'> <div class="vertical"> Average score </div> </th>
                    <th class='text-capitalize text-center toggle_class_position hide'> <div class="vertical"> Position </div> </th>
                    <th class='remarks word_no_wrap'> Class Teacher's remark </th>
                    @if($user->admin)
                    <th class='word_no_wrap remarks'> Admin Remarks </th>
                    @endif
                    <th class='remarks word_no_wrap'> Action </th>
                </tr>
            </thead>
            <tbody>
            @foreach( $students->sortBy('class_position') as $index => $student )
                <tr>          
                    <td> {{ ++$index }} </td>          
                    <td>
                    @if( $s = $student->profile )
                         {{ ucwords( strtolower( $s->last_name.' '.$s->first_name.' '.$s->other_name ) )  }}
                    @endif
                   </td>
                   <td class='remarks text-capitalize'> {{$student->classes}} {{$student->arms}} </td>
                   @foreach($subjects as $subject)
                    <td class='text-capitalize'> 
                        <?php $subject_score_  =  $student->get_subject_score($subject, $student->student_id) ; ?>
                        @if( $subject_score_ == '-' )
                          -
                        @else
                        {{  floatval($subject_score_) }} 
                        @endif
                    </td>
                    @endforeach
                    <td> {{ floatval($student->total_score) }} </td>
                    <td> {{ floatval($student->average_score) }} </td>
                    <td class="toggle_class_position hide"> {{$student->class_position}} </td>
                    <form id="save_comments_form-{{$student->id}}">
                        @csrf()
                        <input type="hidden" name="user_id" value="{{$student->student_id}}">
                        <input type="hidden" name="sessions" value="{{request()->sessions}}">
                        <input type="hidden" name="classes" value="{{request()->classes}}">
                        <input type="hidden" name="term" value="{{request()->term}}">
                        <input type="hidden" name="school_id" value="{{ auth()->user()->school_id }}">
                    <td class='remarks'> 
                         <textarea style="min-width:250px;" class='form-control' placeholder='Comment here...' name='teachers_comment'>{{$student->get_teachers_comment( $student->student_id ) }}</textarea> 
                    </td>

                    @if($user->admin)
                     <td class='remarks'> 
                         <textarea class='form-control' style="min-width:250px;" placeholder='Comment here...' name='principal_comment'>{{$student->get_principal_comment( $student->student_id ) }}</textarea>
                    </td>
                    @endif
                    
                     <td class='remarks word_no_wrap'> 
                         <button type='button' id="{{$student->id}}" class="word_no_wrap save_btn btn btn-sm btn-success">
                             <i id="btn_spinner-{{$student->id}}" class="fa fa-spinner fa-spin btn_spinner hide"></i>
                              Save Comment 
                         </button>
                           <span class="text-center">
                               <i id="success_info-{{$student->id}}" class="fa fa-check-circle hide text-success"> Success </i> 
                               <i id="failed_info-{{$student->id}}" class="fa hide fa-warning text-danger"> Failed </i> 
                          </span>
                     </td>

                    </form>
                </tr>
                @endforeach
            </tbody>
        </table>
        @else
        <h5 class="text-center text-danger"> This Class has No Result yet... </h5>
        @endif
   
    </section>

    <script>
        $(function(){
            $('.toggle_class_position').click( () => {
                $('.toggle_class_position').toggle();
            });
           $(window).click( () => { 
               $('.toggle_docs').show();
                $('.remarks').show(); 
            });
            $('.print_docs').click( () => {
                $('.toggle_docs').hide()
                $('.remarks').hide();
                window.print();
            });
            /****
             * Save comments for admin 
             */
            $('.save_btn').click( (e) => {
                e.preventDefault();
                var $update_broad_sheet_result_comment_url = "/zytwshn3y88w832bd7-glsgvg151816nmjklyp";
                var id = e.target.id;
                var spinner = $('#btn_spinner-'+id),
                    success_info = $('#success_info-'+id);
                    failed_info = $('#failed_info-'+id);
                    spinner.show();
                var form_data = $('#save_comments_form-'+id).serialize();
                $.post($update_broad_sheet_result_comment_url, form_data, (res) => {
                    res.error ? failed_info.show() : success_info.show();
                    spinner.hide();
                });
            });

        });
    </script>
</body>

@else

<script> window.location.href = '/logout' </script>" 

@endif

</html>

@endauth
