@auth
<?php $user = auth()->user(); ?>
@if($user->admin || $user->student)

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    @if( $user->school->logo)
  <link rel="shortcut icon" href="{{asset('uploaded_files/school_logo/'.$user->school_id.'/'.$user->school->logo)}}" type="image/x-icon">
  @else
  <link rel="shortcut icon" href="{{asset('dist/img/sp360_logo.png')}}" type="image/x-icon">
  @endif
    <title> Annual Result Report - {{ $user->school->name }} </title>

    @include('partials.app_css')
</head>

<style>  
input, textarea, select{
  outline: none !important;
  border-top: 0 !important;
  border-left: 0 !important;
  border-right: 0 !important;
}

textarea:focus, input:focus, select:focus{
  border-color: #17a2b8 !important;
  box-shadow: 1 5px 5px 0px #17a2b8;
  -moz-box-shadow: 1 5px 5px 0px #17a2b8;
  -webkit-box-shadow: 1 5px 5px 0px #17a2b8;
  -o-box-shadow: 1 5px 5px 0px #17a2b8;
  -ms-box-shadow: 1 5px 5px 0px #17a2b8;
  -webkit-transition: all 0.4s;
  -o-transition: all 0.4s;
  -moz-transition: all 0.4s;
  transition: all 0.4s;
}
.word_no_wrap{ white-space: nowrap !important; }    
.hide{display:none;}
.img_logo_style{
 	max-height:100px !important; 
	max-width:100px !important; 
	opacity:.9;
}

<?php 
  $school = $user->school;
  $zoom_size = .85;
  $font_size = '14px';
  $font_color = "rgb(2, 2, 54)";
  $font_family = 'Verdana, Geneva, Tahoma, sans-serif';
  if( $fs = $school->css_font_size ) $font_size = $fs;
  if( $fc = $school->css_font_color ) $font_color = $fc;
  if( $ff = $school->css_font_family ) $font_family = $ff;
  if( $zs = $school->css_zoom_size ) $zoom_size = $zs;
?>
    body{zoom: <?php echo $zoom_size ?>;
         font-size: <?php echo $font_size ?>; 
         font-family: <?php echo $font_family ?>;
         font-weight: 550;
    }
    p{  
       font-size:   <?php echo $font_size   ?>; 
       font-family: <?php echo $font_family ?>;
       font-weight: 550;
    }
    h5,h6{ font-weight: 550; }
    table{ width: 100% !important;}
    th,td{ padding: 5px; 
           font-size: <?php echo $font_size ?>;
         }
    .text_color{ color: <?php echo $font_color ?>; }
    table,tr,th,td,.border_color{ border: 2px solid <?php echo $font_color ?> !important; }
    .page-break{ page-break-after: always; }
</style>

<body>
    <section class="container-fluid">
       <div class="justify-content-center d-flex mt-3 mb-1">
            <button class="btn btn-primary no_print print_docs"><i class="fa fa-print"></i>  Print Result </button>
        </div>

        @foreach($fetch_annual_results as $student)

         @if( $student->result_is_published() )

        <section class="card page-break border_color">
            <div class="card-body">

              <div class="row"><!-- row Header-->
                    <div class="col-md-4"> <!-- col -->           
                      <div class="justify-content-center d-flex">
                        @if($user->school->logo)
                         <img style="height:140px; width:auto;" class="img-thumbnil" src="{{asset('/uploaded_files/school_logo/'.$user->school_id.'/'.$user->school->logo)}}"/>
                        @else
                        <p><i class="fa fa-flag fa-4x text_color"></i></p>
                        @endif 
                        </div>                
                    </div> <!-- /col -->

                    <div class="col-md-4 text-center text-capitalize text_color"> <!-- col -->
                       <h5 class='text-uppercase'> <b> {{$user->school->name}} </b> </h5>
                       <h6 class='text-lowercase'> {{strtolower($user->school->motto)}} </h6>
                       <h6> {{ strtolower($user->school->address) }} </h6>
                       <h6> {{ strtolower($user->school->website) }} </h6>
                       <h6> {{ $user->school->phone }}  </h6>
                    </div> <!-- /col -->

                    <div class="col-md-4"> <!-- col -->   
                       <div class="justify-content-center d-flex">
                         @if($passport = $student->profile($student->student_id)->photo )
                         <img style="height:140px; width:150px;" class="img-thumbnail" src="{{asset('/uploaded_files/passports/'.$user->school_id.'/'.$passport)}}"/>
                         @else
                         <p><i class="fa fa-user-circle fa-4x text_color"></i></p>
                         @endif
                       </div>
                  
                    </div> <!-- /col -->
                </div> <!-- /row header -->


                <section class="card border_color mt-1"> <!-- card -->
                    <div class="card-body">
                        <div class="row text-capitalize"> <!-- row -->

                           <div class="col-md-4"><!-- col  -->
                            @if($s = $student->profile($student->student_id))
                             <h6> Name: {{strtolower($s->last_name.' '.$s->first_name.' '.$s->other_name)  }}</h6>
                                @else
                             <h6> Name: </h6>
                             @endif
                           </div> <!--///col  -->

                           <div class="col-md-3"><!-- col  -->
                             <h6> Class: {{ $student->classes }} {{ $student->arms }}</h6>    
                           </div> <!--///col  -->


                           <div class="col-md-3"><!-- col  -->
                             <h6> Session: {{request()->sessions }} </h6>
                           </div> <!--///col  -->

                           <div class="col-md-2"><!-- col  -->
                            @if($s = $student->profile($student->student_id))
                             <h6> Gender: {{$s->gender }}</h6>
                                @else
                             <h6> Gender: </h6>
                             @endif
                           </div> <!--///col  -->

                        </div> <!-- //row -->
                        
                    </div>
                </section> <!-- ///end card -->


                <h6 class='text_color text-center'><b> ANNUAL PROGRESS REPORT </b></h6>

                <section class="row"><!-- row -->
                    <div class="col-md-9"><!-- col -->
                    <section class="table-responsive">
                        <table class="table-condensed table-striped">
                            <thead class='text-uppercase'>
                                <tr>
                                    <th> S/N </th>
                                    <th> SUBJECT </th>
                                    <th> 1st Term <br> (100) </th>
                                    <th> 2nd Term <br> (100) </th>
                                    <th> 3rd Term <br> (100) </th>
                                    <th> Total <br> (300) </th>
                                    <th> Average Score <br> (100) </th>
                                    <th> Grade </th>
                                    @if( $student->show_subject_position() )
                                    <th> Subject Position </th>
                                    @endif
                                    <th> Remark</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($student->get_associated_subjects($student->student_id) as $result)
                                <tr>
                                    <td>{{ $loop->index + 1}} </td>
                                    <td class="text-uppercase"> {{ $result->subject }} </td>
                                    <td> {{ ($first = $result->first_term_score ) ? (float) $first : '-'  }} </td>
                                    <td> {{ ($second = $result->second_term_score) ? (float) $second : '-' }} </td>
                                    <td> {{ ($third = $result->third_term_score ) ? (float) $third : '-' }} </td>
                                    <td> {{ (float) $result->total_score }} </td>
                                    <td> {{ (float) $result->average_score }} </td>
                                    <td> {{ $result->grade }} </td>
                                    @if( $student->show_subject_position() )
                                    <td> {{ $result->position}} </td>
                                    @endif
                                    <td> {{ $result->comment }} </td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th></th>
                                    <th> TOTAL </th>
                                    <th> {{ (float) $student->first_term_subject_total}} </th>
                                    <th> {{(float) $student->second_term_subject_total}}  </th>
                                    <th> {{(float) $student->third_term_subject_total}} </th>
                                    <th> {{(float) $student->total_subject_score}} </th>
                                    <th colspan="4"> AVERAGE =  {{ (float) $student->average_score}} % </th>
                                </tr>
                            </tfoot>
                        </table>
                        </section>
                    </div><!-- //col -->

                    <div class="col-md-3"><!-- col -->

                    <p class="text-center text_color"> <b> KEY GRADES </b> </p>
                    <div class="table-responsive">
                        <table class="table-condensed table-striped">
                            <tbody>
                                @foreach($grades as $grade)
                                <tr class='text-capitalize'>
                                    <td> {{$grade->grade}} </td>
                                    <td> {{$grade->comment}} </td>
                                    <td> {{(float)$grade->min_score.' - '. (float)$grade->max_score}} </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    </div><!-- //col -->
                </section> <!-- //row -->


               <section class="border_color mt-2 card card-secondary card-outline">
                   <div class="card-body">
                       <div class="row"> <!-- row -->
                       
                           <!-- <div class="col-md-12"> 
                             <h6 class=""> Class Teacher's Remark: </h6>
                               <form id="teachers_comment_form-{{$student->id}}">
                                   @csrf()
                                   <input type="hidden" value="{{$student->id}}" name="user_id">
                                   <input type="hidden" value="{{$user->school->id}}" name="school_id">
                                   <input type="hidden" value="1" name="status">
                                   <input type="hidden" value="{{request()->classes}}" name="classes">
                                   <input type="hidden" value="{{request()->sessions}}" name="sessions">
                                   <input type="hidden" value="1" name="annual_result_comment">
                                <div class="input-group">
                                <div class="custom-file"> 
                                  @if($user->student)
                                  <p class='pl-2'> <em> {{ $student->annual_result_teachers_comment($student->id) }} </em> </p>
                                  @else
                                  <input type="text" name='teachers_comment' value="{{$student->annual_result_teachers_comment( $student->id )}}" class="form-control">
                                  @endif 
                            
                                </div>

                                <div class="input-group-append">
                                 @if($user->staff)
                                   <button type="button" onClick="update_teachers_comment(<?php echo $student->id ?>)"  class="no_print btn-block btn btn-success btn-sm">
                                    <i class="fa fa-spin fa-spinner hide" id="teachers_loader-{{$student->id}}"></i>  
                                    <i class="fa fa-check hide" id="success_icon1-{{$student->id}}"></i> Save 
                                  </button>
                                @endif
                               </div>
                           </form>
                            </div>
                            <br>
                            </div>  -->



                            
                            <div class="col-md-12"> <!-- col -->
                               <h6 class=""> @if($user->school->type == "secondary") Principal's Remark:  @else Head Teacher's Remark: @endif </h6>
                               <form id='admin_comment_form-{{$student->id}}'>
                                   @csrf()
                                   <input type="hidden" value="{{$student->id}}" name="user_id">
                                   <input type="hidden" value="{{$user->school->id}}" name="school_id">
                                   <input type="hidden" value="1" name="status">
                                   <input type="hidden" value="{{request()->classes}}" name="classes">
                                   <input type="hidden" value="{{request()->sessions}}" name="sessions">
                                   <input type="hidden" value="1" name="annual_result_comment">
                               <div class="input-group">
                              <div class="custom-file">  
                                 @if($user->student)
                                 <p class='pl-2'> <em> {{$student->annual_result_admin_comment( $student->id )}} </em>  </p>
                                 @else
                                 <input value="{{$student->annual_result_admin_comment( $student->id )}}" type="text" name='principal_comment' class="form-control">
                                 @endif
                              </div>

                              <div class="input-group-append">
                                 @if($user->admin)
                                  <button type="button" onClick="update_admin_comment(<?php echo $student->id ?>)" class="no_print btn-block btn btn-info btn-sm">
                                  <i class="fa fa-spin fa-spinner hide" id="admin_loader-{{$student->id}}"></i>  
                                  <i class="fa fa-check hide" id="success_icon2-{{$student->id}}"></i> Save 
                                  </button>
                                 @endif
                               </div>
                            </form>

                            </div>

                            </div> <!-- //col -->

                            <div class="col-md-6 mt-2">
                             @if( $s = $student->result_signature() )
                              <img src="{{asset('/uploaded_files/signatures/'.auth()->user()->school_id.'/'.$s)}}" style='height:40px; width:100px;'> <br>
                              <em> {{ date('d/m/Y') }} </em>
                              <br> <span class=""> <b> @if($user->school->type == "secondary") Principal's @else Head Teacher's @endif Sign/Date </b> </span>
                             @endif
                            </div>

                            <div class="col-md-6 mt-2">
                                <h6 class=''> Promotion Status: <em> <?php echo $student->promotion_status($student->average_score) ?>  </em></h6>
                            </div>

                       </div><!-- ///row -->       
                   </div>
               </section>

            </div>
        </section>
        @else
        <p class="text-center text-danger"> RESULT HAS NOT BEEN PUBLISHED !</p>
        @endif

        @endforeach

    </section>

      
    <script>
        $(function(){
           $(window).click( () => { $('.no_print').show()});
            $('.print_docs').click( () => {
                $('.no_print').hide();
                window.print();
            });
        });
              
        function update_admin_comment(id){
            var loader = $('#admin_loader-'+id);
                loader.show();
            var url = "/zytwshn3y88w832bd7-glsgvg151816nmjklyp";
            var data = $('#admin_comment_form-'+id).serialize();
            $.post(url, data, function(res){
                if(res.error) return alert('Comment did not save, Something went wrong...');
                loader.hide();
                $('#success_icon2-'+id).show();
            });
        }

        function update_teachers_comment(id){
            var loader = $('#teachers_loader-'+id);
                loader.show();
            var url = "/zytwshn3y88w832bd7-glsgvg151816nmjklyp";
            var data = $('#teachers_comment_form-'+id).serialize();
            $.post(url, data, function(res){
                if(res.error) return alert('Comment did not save, Something went wrong...');
                loader.hide();
                $('#success_icon1-'+id).show();
            });
        }
       
    </script>
</body>

</html>
@endif

@endauth
