import Vue from "vue";
import Vuex from "vuex";
import api from '../api/api'; 

Vue.use(Vuex); 

export default new Vuex.Store({
    state:{
        user:{}, stats:{}, school:{}, settings:{}, classroom_posts:[], active_classes:[], my_classes:[]
    },

    mutations:{
        SET_USER_PROFILE: (state, {profile}) => {
            state.user=profile;
        },
        SET_DASHBOARD_STATISTICS: (state, {stats}) => {
            state.stats=stats;
        },
        SET_SCHOOL_INFO: (state, {school}) => {
            state.school=school ;
        },
        SET_ALL_CLASS_SUBJECT_ARM_SESSIONS_DATA: (state, {settings}) => {
            state.settings = settings;
        },
        SET_CLASSROOM_POSTS: (state, {classroom_posts}) => {
            state.classroom_posts = classroom_posts;
        },
        SET_ACTIVE_CLASSES: (state, {active_classes}) => {
            state.active_classes = active_classes;
        },
        SET_CLASSROOM_LISTS: (state, {my_classes}) => {
            state.my_classes = my_classes;
        }, 
    },
    
    actions:{
    
        FETCH_USER_PROFILE: ( {commit}) => {
            api.fetch_user_profile().then( response => {
                commit('SET_USER_PROFILE', {profile: response.data});
            }); 
        },       
        FETCH_DASHBOARD_STATISTICS: ( {commit}) => {
            api.fetch_dashboard_statistics().then( response => {
                commit('SET_DASHBOARD_STATISTICS', {stats: response.data});
            });
        },
        FETCH_SCHOOL_INFO: ( {commit}) =>{
            api.fetch_school_info().then( response => {
                commit('SET_SCHOOL_INFO', {school: response.data});
            });
        },
        FETCH_ALL_CLASS_SUBJECT_ARM_SESSIONS_DATA: ( {commit} ) => {
            api.fetch_all_class_subject_arm_sessions_data().then(response => {
                commit('SET_ALL_CLASS_SUBJECT_ARM_SESSIONS_DATA', {settings: response.data})
            });
        },  
        FETCH_THIS_CLASSROOM_POSTS: ( {commit} , class_id) => {
            api.fetch_this_classroom_posts(class_id).then( response => {
                commit('SET_CLASSROOM_POSTS', {classroom_posts: response.data});
            }); 
        },

        fetch_all_classrooms_i_belong_to: ( {commit}) => {
            api.fetch_all_classrooms_i_belong_to().then( response => {
                commit('SET_ACTIVE_CLASSES', {active_classes: response.data});
            }); 
        },

        fetch_classroom_lists: ( {commit}) => {
            api.fetch_online_classroom().then( response => {
                commit('SET_CLASSROOM_LISTS', {my_classes: response.data});
            }); 
        },
    }, 

}) 

