require('./bootstrap');
window.Vue = require('vue');
import VueRouter from 'vue-router';
import routes from './routes';
import store from "./vuex/store";
import sidebarUserPhoto from "./partials/sidebar_photo";
import sidebarSchoolLogo from "./partials/sidebarSchoolLogo";
import {mixin_sweet_alert} from './mixins/sweet_alert';
import currentTermAndSession from './partials/current_term_and_session';

Vue.use(VueRouter); 
require('./helper_variables');
const app = new Vue({
    components:{ currentTermAndSession, sidebarUserPhoto, sidebarSchoolLogo },
    mixins:[mixin_sweet_alert],
    el: '#main_app_page',
    store,
    router: new VueRouter(routes),
    updated(){
       // $('.modal').modal({backdrop:'static',keyboard:false, show:false});`
        $('.modal').on('show.bs.modal', function(e) {
            window.location.hash = "modal";
        });
        $(window).on('hashchange', function (event) {
            if(window.location.hash != "#modal") {
                $('.modal').modal('hide');
            }
        });
    }
});
