import user_access from './routes_auth_access/user_auth_access_';
import dashboard from './pages/admin/dashboard';
import profile from './pages/my_profile';
import students_management from './pages/admin/students_management';
import staff_management from './pages/admin/staff_management';
import academic_settings from './pages/admin/academic_settings';
import class_management from './pages/admin/class_management';
import check_results from './pages/admin/check_results';
import assign_class_to_staff from './pages/admin/assign_class_to_staff';
import select_computation_class from './pages/staff/select_computation_class';
import result_computation from './pages/staff/result_computation';
import class_teacher_result_computation from './pages/staff/class_teacher_result_computation';
import result_remarks from './pages/staff/result_remarks';
import all_schools from './pages/super_admin/all_schools';
import school_stats from './pages/super_admin/school_stats';
import general_dashboard from './pages/super_admin/general_dashboard';
import my_termly_results from './pages/students/termly_results';
import my_annual_results from './pages/students/annual_results';
import form_teachers from './pages/admin/form_teachers';
import attendance from './pages/staff/form_teacher_class';
import classroom_index_page from './pages/online_class/index';
import classroom_forum from './pages/online_class/classroom';
import class_result_broad_sheet from './pages/admin/class_result_broad_sheet';
import result_assessment_format from './pages/admin/result_assessment_format';
import sms_management from './pages/sms/sms_management';
import exam_setup_page from './pages/exams/set_exam';
import exam_question_setup_page from './pages/exams/set_questions'; 
import exam_page from './pages/exams/exam'; 
import students_cbt_exam_result_page from './pages/exams/students_cbt_exam_result_page';
import edit_questions from './pages/exams/edit_questions';
import view_exam_essay_answers from './pages/exams/view_exam_essay_answers'; 
import student_fee_payment_history from './pages/student_fees/student_fee_payment_history';
import mail_inbox from "./pages/mail/inbox";
import view_mail from "./pages/mail/view_mail";
import add_new_mail from "./pages/mail/add_new";
import create_new_lesson_note from "./pages/lesson_notes/add_new";
import my_lesson_notes from "./pages/lesson_notes/index";
import view_lesson_note from "./pages/lesson_notes/view_lesson_note";
import activity_logs from "./partials/activity_logs";
//SP360 AI
import ai_career_choice from "./pages/sp360_ai/career_choice"; 

export default {
    base:'/page/dashboard/',
    mode: 'history',
    routes:[
        //SP360 AI CAREER CHOICE
        {
            path: '/career-choice', 
            component: ai_career_choice, 
            name: 'ai_career_choice',
            async beforeEnter(to, from, next) { 
                await user_access.change_page_title(" Career choice");
                next();
           },                     
        }, 

        {
            path: '/profile', 
            component: profile, 
            name: 'profile',
            async beforeEnter(to, from, next) {
                await user_access.change_page_title(" Profile");
                next();
           },                     
        },
        /**
         * ACTIVITY LOGS
         */
        {
            path: '/activity-logs', 
            component: activity_logs, 
            name: 'activity_logs',
            async beforeEnter(to, from, next) {
                await user_access.change_page_title(" Activity Log");  
                next();
           },                     
        },
        /**
         * LESSON NOTES 
         */
        {
            path: '/add-new-lesson-note-index', 
            component: create_new_lesson_note, 
            name: 'create_new_lesson_note',
            async beforeEnter(to, from, next) {
                 await user_access.change_page_title(" Create New Lesson Note ");
                 await user_access.staff_only__(next);
            },                    
        },

        {
            path: '/view-lesson-note', 
            component: view_lesson_note, 
            name: 'view_lesson_note',
            async beforeEnter(to, from, next) {
                 await user_access.change_page_title(" View Lesson Note ");
                 next();
            },                    
        },

        {
            path: '/lesson-notes-index', 
            component: my_lesson_notes, 
            name: 'my_lesson_notes',
            async beforeEnter(to, from, next) {
                 await user_access.change_page_title(" Lesson Notes ");
                 next();
            },                    
        },
        /**
         ===== NEWSLETTER ======
        **/
        {
            path: '/view-mail', 
            component: view_mail,
            name: 'view_mail',
            async beforeEnter(to, from, next) {
                 await user_access.change_page_title(" View Mail ");
                 next();
            },                    
        },

        {
            path: '/mail-inbox', 
            component: mail_inbox, 
            name: 'mail_inbox',
            async beforeEnter(to, from, next) {
                 await user_access.change_page_title(" Mail inbox ");
                 next();
            },                    
        },

        {
            path: '/compose-mail', 
            component: add_new_mail, 
            name: 'add_new_mail',
            async beforeEnter(to, from, next) {
                 await user_access.change_page_title(" Compose Mail ");
                 await user_access.admin_only__(next);
            },                    
        },

        /**
         * STUDENT FEES PAYMENT HISTORY ======
         */
        {
            path: '/fee-payment-history', 
            component: student_fee_payment_history, 
            name: 'student_fee_payment_history',
            async beforeEnter(to, from, next) {
                 await user_access.change_page_title(" Payment History"); 
                 await user_access.student_only__(next);
            },                    
        },

        /**
         * EXAMINATION ROUTES
         */
        
        {
            path: '/view-student-exam-answers', 
            component: view_exam_essay_answers, 
            name: 'view_exam_essay_answers',
            async beforeEnter(to, from, next) {
                 await user_access.change_page_title(" Online Cbt / Examination"); 
                 await user_access.staff_only__(next);
            },                    
        },

        {
            path: '/exams', 
            component: exam_page, 
            name: 'exam_page',
            async beforeEnter(to, from, next) {
                 await user_access.change_page_title(" Online Cbt / Examination"); 
                 await user_access.student_only__(next);
            },                    
        },

        {
            path: '/edit-question', 
            component: edit_questions,  
            name: 'edit_exam_question',
            async beforeEnter(to, from, next) {
                 await user_access.change_page_title(" Edit Question");
                 await user_access.staff_only__(next);
            },                    
        },

        {
            path: '/cbt_exam_result_page', 
            component: students_cbt_exam_result_page,   
            name: 'students_cbt_exam_result_page',
            async beforeEnter(to, from, next) {
                 await user_access.change_page_title(" CBT Examination Result ");
                 await user_access.staff_only__(next);
            },                    
        },

        {
            path: '/exam-question-setup', 
            component: exam_question_setup_page,  
            name: 'exam_question_setup_page',
            async beforeEnter(to, from, next) {
                 await user_access.change_page_title(" Examination Questions Setup ");
                 await user_access.staff_only__(next);
            },                    
        },

        {
            path: '/exam-management', 
            component: exam_setup_page, 
            name: 'exam_setup_page',
            async beforeEnter(to, from, next) {
                 await user_access.change_page_title(" Examination Management");
                 await user_access.staff_only__(next);
            },                    
        },

        /**
         * Admin routes 
         */
        {
            path: '/', 
            component: dashboard, 
            name: 'dashboard',
            async beforeEnter(to, from, next) {
                 await user_access.change_page_title(" Dashboard");
                 await user_access.user_is_admin__(next);
            },                    
        },

        {
            path: '/form-teachers-class', 
            component: attendance, 
            name: 'form_teachers_class',
            async beforeEnter(to, from, next) {
                 await user_access.change_page_title(' Form teachers class');
                 await user_access.staff_only__(next);
            },                    
        },

        {
            path: '/class-teachers', 
            component: form_teachers, 
            name: 'form_teachers',
            async beforeEnter(to, from, next) {
                 await user_access.change_page_title(" Class Teachers");
                 await user_access.admin_only__(next);
            },                    
        },
      
        {
            path: '/assign-class-to-staff', 
            component: assign_class_to_staff, 
            name: 'assign_class_to_staff', 
            async beforeEnter(to, from, next) {
               await user_access.change_page_title(" Manage Staff Classes / Subjects ");
               await user_access.admin_only__(next);
            }                          
        },
        
        {
            path: '/staff-management', 
            component: staff_management, 
            name: 'staff_management', 
            async beforeEnter(to, from, next) {
               await user_access.change_page_title(" Staff Records");
               await user_access.admin_only__(next);
            }                          
        },

        {
            path: '/students-management', 
            component: students_management, 
            name: 'students_management', 
            async beforeEnter(to, from, next) {
               await user_access.change_page_title(" Students Record");
               await user_access.admin_only__(next);
            }                          
        },
        {
            path: '/results-management-settings', 
            component: academic_settings, 
            name: 'results_management_settings', 
            async beforeEnter(to, from, next) {
               await user_access.change_page_title(" Academic Settings");
               await user_access.admin_only__(next);
            }                          
        },

        {
            path: '/class-result-broad-sheet', 
            component: class_result_broad_sheet, 
            name: 'class_broad_sheet', 
            async beforeEnter(to, from, next) {
               await user_access.change_page_title(" Class Result broad sheet");
               await user_access.admin_only__(next);
            }                          
        },

        {
            path: '/result-assessment-formats', 
            component: result_assessment_format, 
            name: 'result_assessment_format', 
            async beforeEnter(to, from, next) {
               await user_access.change_page_title(" Result Assessment Format");
               await user_access.admin_only__(next);
            }                          
        },    

        {
            path: '/check-results', 
            component: check_results, 
            name: 'check_results', 
            async beforeEnter(to, from, next) {
               await user_access.change_page_title(" Students Result Report");
               await user_access.admin_only__(next);
            }                          
        },
        {
            path: '/classes-subjects-settings', 
            component: class_management, 
            name: 'class_management', 
            async beforeEnter(to, from, next) {
               await user_access.change_page_title(" School settings");
               await user_access.admin_only__(next);
            }                          
        },
        /***
         * Staff section routes
         */
        {
            path: '/select-class', 
            component: select_computation_class, 
            name: 'select_computation_class', 
            async beforeEnter(to, from, next) {
               await user_access.change_page_title(' Select class for Computation, Checking and Editing of Results');
               await user_access.staff_only__(next);
            }                          
        },

        {
            path: '/class-result-computation', 
            component: class_teacher_result_computation, 
            name: 'class_teacher_result_computation', 
            async beforeEnter(to, from, next) {
               await user_access.change_page_title(' Class teacher result computation');
               await user_access.staff_only__(next);
            }                          
        },

        {
            path: '/results', 
            component: result_computation, 
            name: 'result_computation', 
            async beforeEnter(to, from, next) {
               await user_access.change_page_title(' Compute | Check | Edit Results');
               await user_access.staff_only__(next);
            }                          
        },
        {
            path: '/result_remarks', 
            component: result_remarks, 
            name: 'result_remarks', 
            async beforeEnter(to, from, next) {
               await user_access.change_page_title(' Result Remarks/Comments Settings');
               await user_access.staff_only__(next);
            }                          
        },
        /***
         * Super Admin route
         */
        {
            path: '/_all-schools__', 
            component: all_schools, 
            name: 'super_admin_all_schools', 
            async beforeEnter(to, from, next) {
               await user_access.change_page_title(' All schools management');
               await user_access.super_admin_only__(next);
            }                          
        },
        {
            path: '/_school-stats__', 
            component: school_stats, 
            name: 'school_stats', 
            async beforeEnter(to, from, next) {
               await user_access.change_page_title(' School Information and Stats ');
               await user_access.super_admin_only__(next);
            }                          
        },
        {
            path: '/_general-dashboard__', 
            component: general_dashboard, 
            name: 'super_admin_general_dashboard', 
            async beforeEnter(to, from, next) {
               await user_access.change_page_title(' General Dashboard ');
               await user_access.super_admin_only__(next);
            }                          
        },

        /***
         * 
         * Students routes section
         */
        {
            path: '/my-termly-results', 
            component: my_termly_results, 
            name: 'my_termly_results', 
            async beforeEnter(to, from, next) {
               await user_access.change_page_title(' Student Termly Results');
               await user_access.student_only__(next);
            }                          
        },

        {
            path: '/my-annual-results', 
            component: my_annual_results, 
            name: 'my_annual_results', 
            async beforeEnter(to, from, next) {
               await user_access.change_page_title(' Students Annual Results');
               await user_access.student_only__(next);
            }                          
        },

        /**
         * ONLINE CLASSROOM ROUTES
         */

        {
            path: '/online-classroom', 
            component: classroom_index_page, 
            name: 'online_classroom', 
            async beforeEnter(to, from, next) {
                await user_access.change_page_title(" Online Classroom ");
                next();
           },                          
        },

        {
            path: '/forum', 
            component: classroom_forum, 
            name: 'classroom_forum', 
            async beforeEnter(to, from, next) {
                await user_access.change_page_title(" Online Classroom - Forums ");
                next();
           },                          
        },

        /**
         * == SMS ROUTES (SHORT MESSAGE SERVICE)
         */

        {
            path: '/sms-management', 
            component: sms_management, 
            name: 'sms_management', 
            async beforeEnter(to, from, next) {
                  await user_access.change_page_title(" SMS Management ");
                  await user_access.admin_only__(next);
           },                         
        },

    ]

}
