export const mixin_sweet_alert = {
    methods:{
        alert_success(msg){
            this.Toast().fire({
                type: 'success',
                title: msg
              });
        },

        alert_error(msg){   
                this.Toast().fire({
                  type: 'error',
                  title: msg
                });   
        },

        alert_network_error(msg = 'Network Error ! '){
          return this.alert_error(msg);
        },

        alert_msg( response ){
          return ( response.data.error ) ? this.alert_error( response.data.error ) : this.alert_success( response.data.success ) ; 
        },
          
        Toast(){
            return Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: true,
                timer: 12000
              });
        }
    },
        
}