import axios from 'axios';

export default{
    /**
     * Dashboard routes
     */
    fetch_dashboard_statistics(){  
        return axios.get('/zytwshn3y88w832bd7-glsgvg109816nmjklyp' );  
    },
    /**
     * ACTIVITY LOGS
     */
    fetch_my_activity_logs(page_number){
        return axios.get("/zytwshn3y88w832bd7-glsgvg101816nmjklyp"+"?page="+page_number);
    },
    /***
     * LESSON NOTES
     */
    store_lesson_note(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg209816nmjklyp', data);
    },
    delete_lesson_note(id){
        return axios.post('/zytwshn3y88w832bd7-glsgvg212816nmjklyp', id);
    },
    view_lesson_note( $lesson_note_id ){
        return axios.get('/zytwshn3y88w832bd7-glsgvg213816nmjklyp?id='+$lesson_note_id);
    },
    fetch_lesson_notes($page_number_){
        return axios.get('/zytwshn3y88w832bd7-glsgvg210816nmjklyp'+"?page="+$page_number_);
    },
    publish_lesson_note(id){
        return axios.post('/zytwshn3y88w832bd7-glsgvg214816nmjklyp', id);
    },
    undo_publish_lesson_note(id){
        return axios.post('/zytwshn3y88w832bd7-glsgvg215816nmjklyp', id);
    },
    /***
     * SCHOOL MAIL ROUTES
    */
    store_mail($data){
        return axios.post('/zytwshn3y88w832bd7_7ygwdyu54gw-glsgvg100814nmjklyp', $data);
    },
    delete_mail($id_){
        return axios.post('/zytwshn3y88w832bd7_7ygwdyu54gw-glsgvg100815nmjklyp', $id_);
    },
    fetch_mail($page_number_){
        return axios.get('/zytwshn3y88w832bd7_7ygwdyu54gw-glsgvg100816nmjklyp'+"?page="+$page_number_);
    },
    view_mail($mail_code){
        return axios.get('/zytwshn3y88w832bd7_7ygwdyu54gw-gls314s816nmjklyp?mid='+$mail_code);
    },
    /***
     * STUDENT FEE PAYMENT HISTORY ROUTE
     */  
    fetch_student_fee_payment_history(){
        return axios.get('/zytwshn3y88w832bd7-glsgvg000816nmjklyprtu6');
    },
    /****
     *  ROUTE FOR ONLINE EXAM / CBT
     */
    delete_student_answer(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg518816nmjklyp', data);
    },
    store_new_cbt_exam(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg500816nmjklyp', data);
    },
    delete_cbt_exams(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg501816nmjklyp', data);
    },
    publish_cbt_exam(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg502816nmjklyp', data);
    },
    undo_publish_cbt_exam(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg503816nmjklyp', data);
    },
    fetch_this_exam_questions(exam_id){
        return axios.get('/zytwshn3y88w832bd7-glsgvg504816nmjklyp'+exam_id);
    },
    store_exam_question(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg506816nmjklyp', data);
    },
    delete_exam_question(question_id){
        return axios.post('/zytwshn3y88w832bd7-glsgvg507816nmjklyp', question_id);
    },
    fetch_single_question(question_id){
        return axios.get('/zytwshn3y88w832bd7-glsgvg508816nmjklyp?qid='+question_id);
    },
    fetch_student_available_exams(query){
        return axios.post("/zytwshn3y88w832bd7-glsgvg509816nmjklyp", query);
    },
    store_student(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg510816nmjklyp", data);
    },
    get_student_exam_detail(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg511816nmjklyp", data);
    },
    store_student_exam_answer(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg512816nmjklyp", data);
    },
    get_number_of_total_questions_answered(exam_id){
        return axios.get("/zytwshn3y88w832bd7-glsgvg513816nmjklyp?exam_id="+exam_id);
    },
    get_all_students_who_took_this_exam(exam_id){
        return axios.get("/zytwshn3y88w832bd7-glsgvg514816nmjklyp?exam_id="+exam_id);
    },
    update_exam_question(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg505816nmjklyp", data);
    },
    fetch_student_exam_answers(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg515816nmjklyp", data);
    },
    update_cbt_exam(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg516816nmjklyp", data);
    },
    remove_student_from_this_exam(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg517816nmjklyp", data);
    },
    
    /**
     * user profiles and school info
     */
    update_school_info(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg108816nmjklyp', data);
    },

    fetch_all_class_subject_arm_sessions_data(){
        return axios.get("/zytwshn3y88w832bd7-glsgvg103816nmjklyp");
    },
    update_user_profile(data) {
        return axios.post("/zytwshn3y88w832bd7-glsgvg105816nmjklyp", data);
    },
    update_user_passport(data) {
        return axios.post("/zytwshn3y88w832bd7-glsgvg107816nmjklyp", data );
    },
    update_password(data) {
        return axios.post("/zytwshn3y88w832bd7-glsgvg106816nmjklyp", data);
    },
    fetch_user_profile() {
        return axios.get("/zytwshn3y88w832bd7-glsgvg104816nmjklyp");
    },
    fetch_school_info() {
        return axios.get("/zytwshn3y88w832bd7-glsgvg104816nmjklyp?school_info=1");
    },
    reset_password(id){
        return axios.post("/zytwshn3y88w832bd7-glsgvg115816nmjklyp/"+id);
    },
    /**
       * General actions
       * grant_access_to_user_to_edit_profile
       * deny_access_to_user_to_edit_profile
       * delete_users
    **/
    grant_access_to_user_to_edit_profile(data){  
        return axios.post('/zytwshn3y88w832bd7-glsgvg110816nmjklyp', data); 
    },
    deny_access_to_user_to_edit_profile(data){  
        return axios.post('/zytwshn3y88w832bd7-glsgvg111816nmjklyp', data); 
    },
    delete_users(data){  
        return axios.post('/zytwshn3y88w832bd7-glsgvg112816nmjklyp', data); 
    },
    activate_user(data){  
        return axios.post('/zytwshn3y88w832bd7-glsgvg113816nmjklyp', data); 
    },
    de_activate_user(data){  
        return axios.post('/zytwshn3y88w832bd7-glsgvg114816nmjklyp', data); 
    },
    /**
     * =======
     * ======= Class Settings / Management ========
     * ======
     */
    
    update_school_subjects(data){  
        return axios.post('/zytwshn3y88w832bd7-glsgvg131816nmjklyp', data); 
    },
    delete_subject_group(data){  
        return axios.post('/zytwshn3y88w832bd7-glsgvg121816nmjklyp', data); 
    },
    store_subject_group(data){  
        return axios.post('/zytwshn3y88w832bd7-glsgvg122816nmjklyp', data); 
    },
    store_class(data){  
        return axios.post('/zytwshn3y88w832bd7-glsgvg123816nmjklyp', data); 
    },
    store_subject(data){  
        return axios.post('/zytwshn3y88w832bd7-glsgvg124816nmjklyp', data); 
    },
    delete_subjects(data){  
        return axios.post('/zytwshn3y88w832bd7-glsgvg125816nmjklyp', data); 
    },
    delete_classes(data){  
        return axios.post('/zytwshn3y88w832bd7-glsgvg126816nmjklyp', data); 
    },
    store_arm(data){  
        return axios.post('/zytwshn3y88w832bd7-glsgvg127816nmjklyp', data); 
    },
    delete_arms(data){  
        return axios.post('/zytwshn3y88w832bd7-glsgvg128816nmjklyp', data); 
    },
    store_houses(data){  
        return axios.post('/zytwshn3y88w832bd7-glsgvg129816nmjklyp', data); 
    },
    delete_houses(data){  
        return axios.post('/zytwshn3y88w832bd7-glsgvg130816nmjklyp', data); 
    },
    /**
     * =======
     * ======= Students Management Routes ========
     * ======
     */
    fetch_this_user_details(id) {
        return axios.get("/zytwshn3y88w832bd7-glsgvg104816nmjklyp?user_id="+id);
    },
    register_student(data) {
        return axios.post("/zytwshn3y88w832bd7-glsgvg133816nmjklyp", data);
    },
    class_promotion(data) {
        return axios.post("/zytwshn3y88w832bd7-glsgvg120816nmjklyp", data);
    },
    
    import_students_via_excel(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg134816nmjklyp", data);
    },
    /***
     * =========
     * ======== Staff Management Routes ======
     * =========
     */
    store_form_teachers(data) {
        return axios.post("/zytwshn3y88w832bd7-glsgvg143816nmjklyp", data);
    },
    fetch_all_attendance_records(data) {
        return axios.post("/zytwshn3y88w832bd7-glsgvg145816nmjklyp", data);
    },
    delete_form_teachers(id) {
        return axios.post("/zytwshn3y88w832bd7-glsgvg144816nmjklyp?id="+id);
    },
    fetch_form_teachers() {
        return axios.get("/zytwshn3y88w832bd7-glsgvg142816nmjklyp");
    },
    register_staff(data) {
        return axios.post("/zytwshn3y88w832bd7-glsgvg138816nmjklyp", data);
    },
    import_staff_via_excel(data) {
        return axios.post("/zytwshn3y88w832bd7-glsgvg136816nmjklyp", data);
    }, 
    make_admin(data) {
        return axios.post("/zytwshn3y88w832bd7-glsgvg116816nmjklyp", data);
    },
    remove_admin(data) {
        return axios.post("/zytwshn3y88w832bd7-glsgvg117816nmjklyp", data);
    },
    make_accountant(data) {
        return axios.post("/zytwshn3y88w832bd7-glsgvg118816nmjklyp", data);
    },
    remove_accountant(data) {
        return axios.post("/zytwshn3y88w832bd7-glsgvg119816nmjklyp", data);
    },
    assign_class_and_subjects_to_staff(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg139816nmjklyp", data );
    },

    delete_staff_class_and_subjects(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg141816nmjklyp", data);
    },
    /***
     * Results management routes / check results
     */
    store_cbt_scores_in_subject_result(data){ 
        return axios.post("/zytww832bd7-glsgvg1416nmjklyp", data);
    },
    check_subject_results(data){ 
        return axios.get("/check_subject_results", data);
    },
    check_lowest_highest_scores_for_subject_results(data){
        return axios.get("/check_lowest_highest_scores_for_subject_results"+data);  
    },
    available_class_results(){
        return axios.get("/available-results");  
    },
    /**
     * Result and Grade management settings 
     **/
    update_academic_result_settings( data ){
        return axios.post("/zytwshn3y88w832bd7-gvg170816rteqnmjklyp", data);
    },

    create_new_session(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg159816nmjklyp", data);
    },
    activate_session(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg160816nmjklyp", data);
    },
    de_activate_session(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg161816nmjklyp", data);
    },
    publish_result(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg162816nmjklyp", data);
    },
    undo_publish_result(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg163816nmjklyp", data);
    },
    delete_term_and_sessions(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg158816nmjklyp", data);
    },
    //Result Grading
    store_result_grading(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg165816nmjklyp", data);
    },
    delete_result_grading(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg164816nmjklyp", data);
    },
    store_result_comment(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg167816nmjklyp", data);
    },
    delete_result_comment(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg166816nmjklyp", data);
    },
    store_new_resumption_date(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg168816nmjklyp", data);
    },
    delete_resumption_date(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg169816nmjklyp", data);
    },
    upload_signature(data){
        return axios.post("/zytwshn3y88w832bd7-glsgvg170816nmjklyp", data);
    },
   
    /****
     * 
     * Staff section begins here
     */
    
    fetch_students_of_this_class(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg208816nmjklyp', data); 
    },

    store_students_result(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg200816nmjklyp', data);
    },
    fetch_subject_results(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg201816nmjklyp'+data);
    },
    update_subject_result(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg202816nmjklyp'+data);
    },
    delete_subject_result(id){
        return axios.post('/zytwshn3y88w832bd7-glsgvg203816nmjklyp', id);
    },
    fetch_my_form_teacher_classes(){
        return axios.get('/zytwshn3y88w832bd7-glsgvg204816nmjklyp');
    },
    fetch_students_in_this_form_teachers_class(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg205816nmjklyp', data);
    },
    store_students_attendance(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg206816nmjklyp', data);
    },
    view_attendance_records(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg207816nmjklyp', data);
    },  
    
    /***
     * ==== Super Admin Section ===== 
     */
    
    update_school_details_(data){
        return axios.post('/PmfdMnyA30Ljq9vboI6NizxBlHD2e5441b8b873esdijifw2__452', data);
    },
    store_school(data){
        return axios.post('/store_school', data);
    },
    activate_schools(data){
        return axios.post('/acwg7GFCPmfdMEpsht5u841rOkeJnyA30Ljq9vboI6NizxBlHD2K5e5441b8b873esdijifw2468724924uhegfiweexybn3478yutd', data);
    },
    de_activate_schools(data){
        return axios.post('/de_activate_schools', data);
    },
    store_school_admin(data){
        return axios.post('/acwg7GFCPmfdMEpsht5u841rOkeJnyA30Ljq9vboI6NizxBlHD2e5441b8b873esdijifw2468724924uhegfiweexybn3478yutd', data);
    },
    all_schools(){
        return axios.get('/all_schools?'); 
    },
    fetch_info_and_stats_about_this_school(school_id){
        return axios.get('/fetch_info_and_stats_about_this_school/'+school_id);
    },

    /****
     * Api Routes for ONLINE CLASSROOM
     * 
     */
    store_online_classroom(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg300816nmjklyp', data);
    },

    fetch_online_classroom(){
        return axios.get('/zytwshn3y88w832bd7-glsgvg301816nmjklyp');
    },
    find_this_online_classroom(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg302816nmjklyp', data);
    },

    delete_this_online_classroom(class_id){
        var data = {class_id : class_id};
        return axios.post('/zytwshn3y88w832bd7-glsgvg303816nmjklyp', data);
    },
    
    fetch_all_classrooms_i_belong_to(){
        return axios.get('/zytwshn3y88w832bd7-glsgvg304816nmjklyp');
    },

    ensure_user_is_a_member_of_this_class(class_code, class_id){
        var data = {class_code: class_code, class_id, class_id};
        return axios.post('/zytwshn3y88w832bd7-glsgvg305816nmjklyp', data);
    },

    store_post(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg400816nmjklyp', data);
    },

    fetch_this_classroom_posts(class_id){
        return axios.post('/zytwshn3y88w832bd7-glsgvg401816nmjklyp', class_id);
    },
    delete_this_post(post_id){
        return axios.post('/zytwshn3y88w832bd7-glsgvg402816nmjklyp', post_id);
    },
    remove_user_from_classroom(member_id){
        return axios.post('/zytwshn3y88w832bd7-glsgvg403816nmjklyp', member_id);
    },
    add_user_to_classroom(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg405816nmjklyp', data);
    },
    store_classroom_post_files(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg406816nmjklyp', data);
    },
    delete_classroom_files(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg407816nmjklyp', data);
    },
    check_if_user_can_upload_file_and_make_posts(class_id){
        return axios.post('/zytwshn3y88w832bd7-glsgvg408816nmjklyp', class_id);
    },
    update_classroom_user_upload_settings(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg409816nmjklyp', data);
    },
    update_classroom_user_post_settings(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg410816nmjklyp', data);
    },

    /**
     * Result Assessment scores settings
     */
    fetch_assessment_scores( query = '' ){
        return axios.get('/zytwshn3y88w832bd7-glsgvg148816nmjklyp'+query );
    },
    delete_assessment_scores(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg149816nmjklyp', data);
    },
    store_assessment_scores(data){
        return axios.post('/zytwshn3y88w832bd7-glsgvg150816nmjklyp', data);
    },

    /***
     * SMS MANAGER 
     */
    sms_fetch_all_students_(){
        return axios.get('/zytwshn3y88w832bd7_7T533314s816nmjklyp');
    },
    sms_fetch_all_staff_(){
        return axios.get('/zytws692ey88w832bd7_7T533s816nmjklyp');
    },
    
}
