<?php

namespace App\models;

use Illuminate\Database\Eloquent\Model;

class subject_group extends Model
{
    protected $guarded = [];

    public function subjects()
    {
        return $this->hasMany(subject::class);
    }

    public function getNameAttribute($value)
    {
        return ucwords(strtolower($value));
    }

    public function setNameAttribute($value)
    {
        $this->attributes['name'] = strtolower($value); 
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function($linked){
            foreach($linked->subjects()->get() as $subject){
                $subject->delete();
            }
        });
    }

}
