<?php

namespace App\models;

use Illuminate\Database\Eloquent\Model;
use App\models\school;

class subject extends Model
{
    protected $guarded=[];

    public function school()
    {
        return $this->belongsTo(school::class)->withDefault(['name'=>'']);
    }

    public function getNameAttribute($value)
    {
        return ucwords(strtolower($value));
    }

    public function setNameAttribute($value)
    {
        $this->attributes['name'] = strtolower($value); 
    }

    public function subject_group()
    {
        return $this->belongsTo(subject_group::class)->withDefault(['name'=>'']);
    }
}
