<?php

namespace App\models;

use Illuminate\Database\Eloquent\Model;
use App\User;
use App\models\arm;
use App\models\sch_class;
use App\models\subject;

class school extends Model
{
    protected $guarded = []; 

    public function user()
    {
        return $this->hasMany(User::class);
    }

    public function arms()
    {
        return $this->hasMany(arm::class);
    }

    public function classes()
    {
        return $this->hasMany(sch_class::class);
    }

    public function subjects()
    {
        return $this->hasMany(subject::class);
    }

    public function getNameAttribute($value)
    {
        return ucwords(strtolower($value));
    }

    // public function getMottoAttribute($value)
    // {
    //     return ucwords(strtolower($value));
    // }

    public function getAddressAttribute($value)
    {
        return ucwords(strtolower($value));
    }

    public function getEmailAttribute($value)
    {
        return ucwords(strtolower($value));
    }

    public function setNameAttribute($value)
    {
        $this->attributes['name'] = ucwords(strtolower($value));
    }

    public function getCreatedAtAttribute($value)
    {
        return date('D, M d, Y - h:ia', strtotime($value) );
    }

}
