<?php

namespace App\models;

use App\User;
use Illuminate\Database\Eloquent\Model;

class lesson_note extends Model
{
    protected $guarded = [];

    public function getCreatedAtAttribute($value)
    {
        return date('D, M d, Y - h:ia', strtotime($value) );
    }

    public function getUpdatedAtAttribute($value)
    {
        return date('D, M d, Y - h:ia', strtotime($value) );
    }

    public function user()
    {
        return $this->belongsTo(User::class)->withDefault(['name'=>'']);
    }
}
