<?php

namespace App\models;

use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class classroom_post extends Model
{
    protected $guarded=[];
    protected $casts = [ 'created_at' => 'date:D, M d - H:ia'];

    function classroom_post_files()
    {
        return $this->hasMany(classroom_post_file::class);
    }

    function user()
    {
        return $this->belongsTo(User::class)->withDefault(['name'=>'']);
    }

    function classroom()
    {
        return $this->belongsTo(classroom::class)->withDefault(['name'=>'']);
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function($classroom_posts){
            foreach($classroom_posts->classroom_post_files()->get() as $classroom_post_file){
                    File::delete('uploaded_files/classroom/'.auth()->user()->school_id.'/videos/'.$classroom_post_file->name);
                    File::delete('uploaded_files/classroom/'.auth()->user()->school_id.'/images/'.$classroom_post_file->name);
                    File::delete('uploaded_files/classroom/'.auth()->user()->school_id.'/documents/'.$classroom_post_file->name);
                    File::delete('uploaded_files/classroom/'.auth()->user()->school_id.'/audios/'.$classroom_post_file->name);
                    $classroom_post_file->delete();
            }
        });
    }

}
