<?php

namespace App\models;

use App\User;
use Illuminate\Database\Eloquent\Model;

class classroom_member extends Model
{
    protected $guarded=[];
	
	public function getCreatedAtAttribute($value)
    {
        return date('D, M d, Y - h:ia', strtotime($value) );
    }

    function classroom()
    {
        return $this->belongsTo(classroom::class)->withDefault(['name'=>'']);
    }

    function user()
    {
        return $this->belongsTo(User::class)->withDefault(['name'=>'']);
    }
}
