<?php

namespace App\models;

use App\User;
use Illuminate\Database\Eloquent\Model;

class classroom extends Model
{
    protected $guarded=[];
	
	public function getCreatedAtAttribute($value)
    {
        return date('D, M d, Y - h:ia', strtotime($value) );
    }

    function classroom_members()
    {
        return $this->hasMany(classroom_member::class);
    }

    function user()
    {
        return $this->belongsTo(User::class)->withDefault(['name'=>'']);
    }

    function classroom_posts()
    {
        return $this->hasMany(classroom_post::class);
    }

    function classroom_post_files()
    {
        return $this->hasMany(classroom_post_file::class);
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function($classrooms){
            foreach($classrooms->classroom_posts()->get() as $classroom_post){
                $classroom_post->delete();
            }
        });

        static::deleting(function($members){
            foreach($members->classroom_members()->get() as $member){
                $member->delete();
            }
        });
    }
}
