<?php

namespace App\models;

use App\Http\Controllers\Traits\my_school_data;
use App\User;
use Illuminate\Database\Eloquent\Model;

class class_final_result extends Model
{
    use my_school_data;

    protected $guarded = [];

    function profile()
    {
        return $this->belongsTo(User::class, "student_id");
    }

    public function getTeachersCommentAttribute($value)
    {
        return ucfirst(strtolower($value));
    }

    public function getPrincipalCommentAttribute($value)
    {
        return ucfirst(strtolower($value));
    }

    public function school()
    {
        return $this->belongsTo( school::class )->withDefault(['name'=>'']);
    }
    
    function result_signature($s='')
    {
        return ( $s = $this->my_school( new school_signature() )->latest()->first() ) ? $s->signature : 0;
    }

    function get_associated_subject_results($student_id)
    {
        return $this->student_subject_results()->whereStudent_id( $student_id )->get()->sortBy('subjects');
    }

    function next_term_begins()
    {
        return ( $s = $this->my_school(new resumption_date)->whereTerm(request()->term)
                            ->whereSessions( request()->sessions)->first() ) ? $s->date : '';
    }

    function result_published_date()
    {
        return ($s = $this->my_school(new sch_session)->whereTerm(request()->term)->whereSessions( request()->sessions )
                          ->whereResult_published(1)->first()) ? date('D, M d, Y', strtotime($s->updated_at) ) : 0;
    }

    function attendance($student_id)
    {
        $find =  $this->my_school(new student_attendance)
                      ->whereTerm( request()->term )
                      ->whereSessions( request()->sessions )
                    //->whereClasses( request()->classes )
                    //->whereArms( request()->arms)
                      ->whereUser_id( $student_id)->first();
        return ($find) ? [$find->days_present , $find->days_absent] : ['',''] ;
    }

    function get_subject_score($subject = null, $student_id)
    {
        $get_subject_score = $this->my_school(new subject_result)->whereTerm( request()->term )
                                                                 ->whereSessions( request()->sessions )
                                                                 ->whereClasses( request()->classes ) 
                                                                 ->whereSubjects( $subject )
                                                                 ->whereStudent_id( $student_id );
        if( request()->arms ) $get_subject_score = $get_subject_score->whereArms( request()->arms );
        $subject_score = $get_subject_score->first();
    
        return ( $subject_score ) ? $subject_score->total_score : '-';
    }

    function fetch_result_assessment_format( $classes, $arms )
    {
        $assesment_score = null;
        $get_format = $this->my_school(new assessment_format)
                           ->whereClasses( $classes )
                           ->latest();
        if( $get_format->exists() ){
            if($arms != ''){
                if( $get_format->whereArms($arms)->exists() ){
                    $format = $get_format->whereArms($arms)->first();
                    $assesment_score = $format;
                }else{
                    $format = $this->my_school(new assessment_format)->whereClasses( $classes )->first();
                    $assesment_score = $format;
                }      
            }else{
                $format = $this->my_school(new assessment_format)->whereClasses( $classes )->first();
                $assesment_score = $format;
            }     
        } 
        return $assesment_score;
    }

    function get_teachers_comment( $student_id )
    {
        $data = $this->request_data(new teachers_comment)->whereUser_id( $student_id )->whereStatus(0)->first();
        if( $data ):
            return ( $remark = $data->teachers_comment ) ? $remark : "Satisfactory";
        endif;
        return "Satisfactory";
    }
    
    function get_principal_comment( $student_id )
    {
        $data = $this->request_data(new teachers_comment)->whereUser_id( $student_id )->whereStatus(0)->first();
        if( $data ):
            return ( $remark = $data->principal_comment ) ? $remark : "Satisfactory";
        endif;
        return "Satisfactory";
    }

    function show_student_portal_id()
    {
        $data = $this->get_academic_result_settings();
        return ( $data ) ? $data->show_student_portal_id : 0;
    }

    function show_class_position()
    {
        $data = $this->get_academic_result_settings();
        return ( $data ) ? $data->show_class_position : 0;
    }

    function show_subject_position()
    {
        $data = $this->get_academic_result_settings();
        return ( $data ) ? $data->show_subject_position : 0;
    }

    function show_attendance()
    {
        $data = $this->get_academic_result_settings();
        return ( $data ) ? $data->show_attendance : 0;
    }

}