<?php

namespace App\models;

use App\Http\Controllers\Traits\my_school_data;
use App\User;
use Illuminate\Database\Eloquent\Model;

class class_annual_final_result extends Model
{
    use my_school_data;
    protected $guarded = [];

    function profile($id)
    {
        return $this->my_school(new User)->whereId($id)->first();
    }

    function annual_result_teachers_comment( $student_id )
    {
        $comment = $this->my_school( new teachers_comment )
                         ->whereUser_id( $student_id )
                         ->whereSessions( request()->sessions )
                         ->whereClasses( request()->classes )
                         ->whereStatus(1)
                         ->first();
        return ( $c = $comment ) ? $c->teachers_comment : " Satisfactory";
    }

    function annual_result_admin_comment($student_id)
    {
        $comment = $this->my_school( new teachers_comment )
                         ->whereUser_id($student_id )
                         ->whereSessions( request()->sessions )
                         ->whereClasses( request()->classes )
                         ->whereStatus(1)
                         ->first();
        return ( $c = $comment ) ? $c->principal_comment : " Satisfactory";
    }

    function get_associated_subjects($student_id)
    {
        return $this->my_school(new class_annual_subject_result)
                    ->whereStudent_id( $student_id )
                    ->whereSessions( request()->sessions )
                    ->whereClasses( request()->classes )
                    ->whereArms( request()->arms )
                    ->get()
                    ->sortBy('subject');
    }

    function show_subject_position()
    {
        $data = $this->get_academic_result_settings();
        return ( $data ) ? $data->show_subject_position : 0;
    }

    function result_is_published()
    {
        return ($s = $this->my_school(new sch_session)
                          ->whereSessions( request()->sessions )
                          ->whereResult_published(1)
                          ->latest()
                          ->first()) 
                          ? date('D, M d, Y', strtotime($s->updated_at) ) : 0;
    }

    function result_signature($s='')
    {
        return ( $s = $this->my_school(new school_signature)->latest()->first() ) ? $s->signature : 0;
    }

    function promotion_status($student_average_score)
    {
        /**
         * Check if promotion score has been set for this class;
         * if this class has an arm/sub-class, check if promotion score has been set for it
         * if promotion hasn't been set for this class with it's arm, check back on the main class only to use it's promotion mark
         * if promotion mark doesn't exist on either requests, return null;
         */
        $result_format = $this->my_school(new assessment_format)->whereClasses( request()->classes )->where('promotion_score', '!=', '');
        $format = $this->my_school(new assessment_format)->whereClasses( request()->classes)->where('promotion_score', '!=', '')->first();
        
        if($arms = request()->arms) $result_format = $result_format->whereArms( $arms );
        $result_format = $result_format->first();

        if( $result_format ):
            if($result_format->promotion_score != ''):
                if($student_average_score >= $result_format->promotion_score): 
                    return " <span class='text-success'>  Promoted </span> ";
                else:
                    return " <span class='text-danger'>  Not Promoted  </b></span>";
                endif;  
        else:      
                if($format):
                    if( $format->promotion_score != ''):
                        if($student_average_score >= $format->promotion_score): 
                            return " <span class='text-success'>  Promoted </span> ";
                        else:
                            return " <span class='text-danger'>  Not Promoted  </b></span>";
                        endif;
                    else:
                        return "<span class='text-muted'> </span>";
                    endif;
                else:
                    return "<span class='text-muted'></span>";
                endif;

            endif;
        else:
           /**
            * Check the main class to use it's promtion score...
            */
            if($format ):
                if( $format->promotion_score != ''):
                    if($student_average_score >= $format->promotion_score): 
                        return " <span class='text-success'>  Promoted </span> ";
                    else:
                        return " <span class='text-danger'>  Not Promoted  </b></span>";
                    endif;
                else:
                    return "<span class='text-muted'> </span>";
                endif;
            else:
                return "<span class='text-muted'> </span>";
            endif;

        endif;
    }

}
