<?php

namespace App\models;

use App\User;
use Illuminate\Database\Eloquent\Model;

class activity_log extends Model
{
    protected $guarded = [];

    public function getCreatedAtAttribute($value)
    {
        return date('D, M d, Y - h:ia', strtotime($value) );
    }

    public function getUpdatedAtAttribute($value)
    {
        return date('D, M d, Y', strtotime($value) );
    }

    function user()
    {
        return $this->belongsTo(User::class)->withDefault(['name'=>'']);;
    }
}
