<?php

namespace App\models\Exams;

use App\Http\Controllers\Traits\my_school_data;
use App\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class exam_student extends Model
{
    use my_school_data;

    protected $guarded = [];
    protected $dates = ['start_time', 'expected_end_time'];

    public function getCreatedAtAttribute($value)
    {
        return date('D, M d, Y - h:ia', strtotime($value) );
    }

    function exam_timer( $start_time_ , $stop_time_ )
    {
        $start_time = date('h:i A', strtotime($start_time_) );
        $end_time = date('h:i A', strtotime($stop_time_) );
        $now = carbon::now();
        $stop_time = Carbon::parse( $stop_time_ );
        $timer_in_secs = $now->diffInSeconds($stop_time);
        if( $now->gte($stop_time) ){
            $timer_in_secs = 0;
        }
        return [ $timer_in_secs , $start_time, $end_time ];
    }

    function user()
    {
        return $this->belongsTo(User::class)->withDefault(['name'=>'']);
    }

    function exam_answer()
    {
        return $this->hasMany(exam_answer::class);
    }

    function exam()
    {
        return $this->belongsTo(exam::class)->withDefault(['name'=>'']);
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function($students){
            foreach($students->exam_answer()->get() as $exam_answer){
                $exam_answer->delete();
            }
        });
    }

}
