<?php

namespace App\models\Exams;

use App\Http\Controllers\Traits\my_school_data;
use Illuminate\Database\Eloquent\Model;

class exam extends Model
{
    use my_school_data;

    protected $guarded = [];

    function exam_question()
    {
        return $this->hasMany(exam_question::class)->whereDeleted(0)->latest('updated_at');
    }

    function exam_student()
    {
        return $this->hasMany(exam_student::class)->latest();
    }

    public function getCreatedAtAttribute($value)
    {
        return date('D, M d, Y - h:ia', strtotime($value) );
    }

    public function getUpdatedAtAttribute($value)
    {
        return date('D, M d, Y - h:ia', strtotime($value) );
    }

    public function getDaateAttribute($value)
    {
        return date('D, M d, Y - h:ia', strtotime($value) );
    }

    public function getDurationAttribute($value)
    {
        return (float) $value;
    }
}
