<?php
namespace App;

use App\Http\Controllers\Traits\my_school_data;
use App\models\result_comment;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use App\models\school;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Authenticatable
{
    use my_school_data;
    use Notifiable;
   // use SoftDeletes;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [ 'password', 'remember_token', 'pwd_reset' ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function school()
    {
        return $this->belongsTo(school::class)->withDefault(['name'=>'']);
    }

    public function result_comments()
    {
        return $this->hasMany(result_comment::class);
    }

    public function getLastNameAttribute($value)
    {
        return ucwords(strtolower($value));
    }

    public function getFirstNameAttribute($value)
    {
        return ucwords(strtolower($value));
    }

    public function getOtherNameAttribute($value)
    {
        return ucwords(strtolower($value));
    }

    public function getHouseAttribute($value)
    {
        return ucwords(strtolower($value));
    }

    public function getSponsorNameAttribute($value)
    {
        return ucwords(strtolower($value));
    }

    public function getAddressAttribute($value)
    {
        return ucwords(strtolower($value));
    }

    public function getBloodGroupAttribute($value)
    {
        return strtoupper( strtolower($value) );
    }

    public function getGenotypeAttribute($value)
    {
        return strtoupper( strtolower($value) );
    }

    public function setTargetArmAttribute($value)
    {
        if($value == '' || $value == null ):
            $this->attributes['target_arm'] = null;
        else:
            $this->attributes['target_arm'] = strtolower( $value );
        endif;
    }

    public function setTargetClassAttribute($value)
    {
        $this->attributes['target_class'] = strtolower( $value );
    }

    public function getTargetClassAttribute($value)
    {
        return ucwords(strtolower($value));
    }

    public function getTargetArmAttribute($value)
    {
        return ucwords(strtolower($value)) ;
    }

    public function setHouseAttribute($value)
    {
        if($value == ''):
            $this->attributes['house'] = '';
        else:
            $this->attributes['house'] = strtolower($value);
        endif;
    }

    public function setFirstNameAttribute($value)
    {
        $this->attributes['first_name'] = ucwords(strtolower($value));
    } 

    public function setLastNameAttribute($value)
    {
        $this->attributes['last_name'] = ucwords(strtolower($value));
    } 

    public function setOtherNameAttribute($value)
    {
        if($value == ''):
            $this->attributes['other_name'] = '';
        else:
            $this->attributes['other_name'] = ucwords(strtolower($value));
        endif;
    }

    public function setSponsorSocialMediaAttribute($value)
    {
        $this->attributes['sponsor_social_media'] = strtolower($value);
    }

    public function getStateOfOriginAttribute($value)
    {
        return ucwords(strtolower($value));
    }

    public function getCountryAttribute($value)
    {
        return ucwords(strtolower($value));
    }

    public function getLgaAttribute($value)
    {
        return ucwords(strtolower($value));
    }

    public function getTownAttribute($value)
    {
        return ucwords(strtolower($value));
    }

    public function getAdminAttribute($value)
    {
        return $value ? 1 : 0;
    }

    public function getSuperAdminAttribute($value)
    {
        return $value ? 1 : 0;
    }

    public function getStaffAttribute($value)
    {
        return $value ? 1 : 0;
    }

    public function getStudentAttribute($value)
    {
        return $value ? 1 : 0;
    }

    public function getActiveAttribute($value)
    {
        return $value ? 1 : 0;
    }

    public function getAccountantAttribute($value)
    {
        return $value ? 1 : 0;
    }

    public function getDeletedAttribute($value)
    {
        return $value ? 1 : 0;
    }

    public function getEditProfileAttribute($value)
    {
        return $value ? 1 : 0;
    }

    public function account_management_url()
    {
        //return "http://accounting.schoolportal360.local?uid=".auth()->user()->id;
        return "https://accounting.schoolportal360.com.ng?uid=".auth()->id();
    }

    function my_total_mails()
    {
        return $this->fetch_my_mails()->count();
    }

}

