<?php

namespace App\Imports;

use App\User;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use App\Http\Controllers\Traits\my_school_data;

class StudentsDataImport implements ToModel, WithHeadingRow
{
    use my_school_data;
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row) 
    { 
        if($this->current_session() ):
         if(! array_filter($row)) return null;
        return new User([
            'first_name' =>  trim( $row['first_name']),
            'last_name' =>   trim( $row['surname']),
            'other_name' => trim( $row['other_name'] ) ?? null,
            //'email' => trim( strtolower( $row['email'] ) ) ?? null,
            'target_class' => trim( strtolower( $row['class'] ) ),
            'target_arm' =>  trim(strtolower( $row['arm'] ) ) ?? null,
            'target_session' =>  $this->korent_session(),
            'school_id' => auth()->user()->school_id,
            // 'house' => trim( strtolower( $row['house'] ) ) ?? null,
            'password' => bcrypt( trim( strtolower( $row['surname']) ) ),
            'gender' => $this->format_gender( trim(strtolower($row['gender']) ) ),
            // 'address' => trim( strtolower($row['address']) ) ?? trim( strtolower($row['home_address']) ) ?? null,
            // 'sponsor_name'  => trim( strtolower($row['sponsor_name']) )  ?? null,
            // 'sponsor_phone' => trim( strtolower($row['sponsor_phone']) ) ?? null,
            // 'sponsor_email' => trim( strtolower($row['sponsor_email']) ) ?? null,
            // 'sponsor_relationship' => trim( strtolower($row['sponsor_relationship']) ) ?? null,
            // 'lga' => trim( strtolower($row['lga']) ) ?? null,
            // 'town' => trim( strtolower($row['town']) ) ?? null,
            // 'state_of_origin' => trim( strtolower($row['state_of_origin']) ) ?? null,
            //'genotype' => trim( strtoupper( $row['genotype']) ) ?? null,
            //'blood_group' => trim( strtoupper( $row['blood_group']) )  ??  null,
            // 'height' => trim( $row['height'] ) ?? null,
            // 'weight' => trim( $row['weight'] ) ?? null,
            //'country' => trim( ucwords(strtolower($row['country'])) ) ?? null,
            'student' => 1
        ]);
    endif;
    }

    function korent_session()
    {
        return $this->current_session()->sessions;
    }

    function format_user_fname( $name = null)
    {
        $value = '';
        if($name){
            $n= '';
            $array =  explode(' ', $name);
             foreach( $array as &$k):
                if($k == "") continue;
                $n.=$k.' ';
             endforeach;
             unset($k);
            $split_name = explode(' ', $n );
            if(isset($split_name[1])){
                $value = $split_name[1] ;
            }
        }
        return $value;
    }

    function format_user_oname($name = null)
    {
        $value = '';
        if($name)
        {
            $n= '';
            $array =  explode(' ', $name);
            foreach( $array as &$k):
                if($k == "") continue;
                $n.=$k.' ';
            endforeach;
            unset($k);
            $split_name = explode(' ', $n);
            if(isset($split_name[2]) ){
                $value = $split_name[2];
            }
        }
        return $value;
    }

    function format_user_surname($name = null)
    {
        $value = '';
        if($name){
            $n= '';
            $array =  explode(' ', $name);
             foreach( $array as &$k):
                if($k == "") continue;
                $n.=$k.' ';
             endforeach;
             unset($k);
            $value = explode(' ', $n)[0];
        }
        return $value;
    }

    function format_gender($gender)
    {
        if( $gender == 'm' || $gender == 'male'){
             return 'male';
        }
        if($gender == 'f' || $gender == 'female'){
             return 'female';
        }
        return 'male';
    }
    
    function format_user_dates($dob = null)
    {
        $value = null;
        $first = ''; $second = ''; $third = '';
        if($dob){
            //==== $dob = Month/Day/Year ====///
            $split_date =  explode('/', $dob); 
            if( isset($split_date[0])) { $first  =  trim( $split_date[0] );  } //Month 
            if( isset($split_date[1])) { $second =  trim( $split_date[1] );  } //Day
            if( isset($split_date[2])) { $third  =  trim( $split_date[2] );  } //Year  
            $value  =  trim($third)."-".$this->prefix_zero_number( trim($first) )."-". $this->prefix_zero_number( trim($second) );
        }
        else{
            $value = null; //trim( $dob_year) ."-".trim( $dob_month ) ."-". trim( $dob_day );
        }
        return $value;
    }

    function prefix_zero_number($number)
    {
        return ( strlen($number) == 1) ? '0'.$number : $number ;
    }

    function exc()
    {
        /****
         * 
         *  'first_name' => $this->format_user_fname( trim( $row['name']) ),
            'last_name' =>  $this->format_user_surname( trim( $row['name']) ) ,
            'other_name' =>  $this->format_user_oname( trim( $row['name']) ) ,
            'target_class' => trim( strtolower( $row['class'] ) ) ?? null,
            'target_arm' =>  trim( $row['arm'] ) ?? null,
            'target_session' =>  trim( $row['session'] ) ?? null,
            'school_id' => auth()->user()->school_id,
            'house' => trim( strtolower( $row['house'] ) ) ?? null,
            'password' => bcrypt( $this->format_user_surname( trim( strtolower( $row['name']) ) ) ),
            'gender' => $this->format_gender( trim(strtolower($row['gender']) ) ),
            'birth_date' => $this->format_user_dates( trim( $row['dob'] ) ),
            'address' => trim( strtolower( $row['address']) ) ?? trim( strtolower($row['home_address']) ) ?? null,
            'sponsor_name'  => trim( strtolower( $row['sponsor_name']) )  ?? null,
            'sponsor_phone' => trim( strtolower( $row['sponsor_phone']) ) ?? null,
            'sponsor_relationship' => trim( strtolower( $row['sponsor_relationship']) ) ?? null,
            'lga' => trim( strtolower( $row['lga']) ) ?? null,
            'state_of_origin' => trim( strtolower($row['state_of_origin']) ) ?? null,
            'student' => 1
         */
    }

}


