<?php

namespace App\Imports;

use App\User;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class StaffDataImport implements ToModel, WithHeadingRow
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        return new User([
            'first_name' => trim( strtolower( $row['first_name'] ) ),
            'last_name' =>  trim( strtolower( $row['surname'] ) ),
            'other_name' => trim( strtolower( $row['other_name'] ) ) ?? null,
            'email' => trim( strtolower( $row['email']  ) ) ?? null,
            'phone' => trim(  $row['phone'] ) ?? null,          
            'school_id' => auth()->user()->school_id,
            'password' => bcrypt(trim( strtolower($row['surname']) )),
            'gender' => $this->format_gender( trim(strtolower($row['gender']) ) ),
            // 'address' => trim( $row['address'] ) ?? trim( $row['home_address'] ) ?? '',
            // 'lga' => trim( $row['lga'] ) ??  '',
            // 'town' => trim( $row['town'] ) ??  '',
            // 'state_of_origin' => trim( $row['state_of_origin'] ) ?? '',
            //'country' => trim( $row['country'] ) ?? '',
            'staff' => 1
        ]);
    }

    function format_gender($gender)
    {
        if( $gender == 'm' || $gender == 'male'){
             return 'male';
        }
        if($gender == 'f' || $gender == 'female'){
             return 'female';
        }
        return 'male';
    }
}
