<?php
namespace App\Http\Controllers\Traits;

trait validate_data{

    function validate_classroom_image_upload($data) 
    {
        $rules=['image.*' => 'image|mimes:png,jpg,jpeg,gif'];
        $validate=validator()->make($data, $rules);
        return ( $validate->fails() ) ? 0: 1; 
    }

    function validate_classroom_audio_upload($data)
    {
        $rules=['audio.*' => 'file|mimetypes:audio/*'];
        $validate=validator()->make($data, $rules);
        return ( $validate->fails() ) ? 0: 1; 
    }

    function validate_classroom_video_upload($data)
    {
        $rules=['video.*' => 'file|mimetypes:video/*'];
        $validate=validator()->make($data, $rules);
        return ( $validate->fails() ) ? 0: 1; 
    }

    function validate_classroom_document_upload($data)
    {
        $rules=['document.*' => 'file|mimes:csv,pdf,docx,doc,xlxs,xlx,zip,pptx,txt'];
        $validate=validator()->make($data, $rules);
        return ( $validate->fails() ) ? 0: 1; 
    }
    
    function validate_online_new_classroom_request($data)
    {
        $rules= ['class_name' => 'required', 'class_subject' => 'required' ];
        $validate=validator()->make($data, $rules);
        return ( $validate->fails() ) ? 0 : 1; 
    }

    function validate_user_data($user_data)
    {
        $rules= ['last_name'=> 'required', 'first_name' => 'required', 'gender' => 'required'];
        $validate=validator()->make($user_data, $rules);
        return ( $validate->fails() ) ? 0 : 1; 
    }

    function validate_user_photo($photo_file, $img_name='photo') 
    {
         $rules=[$img_name => 'image|max:3300|mimes:png,jpg,jpeg,gif'];
         $validate=validator()->make($photo_file, $rules);
         return ( $validate->fails() ) ? 0: 1;
    }

    function validate_class_subject_term_and_session_data($request_data)
    {
        $rules=[
            'sessions'  => 'required',
            'classes'   => 'required',
            'school_id' => 'required'
        ];
        $validate=validator()->make($request_data, $rules);
        return ( $validate->fails() ) ? 0 : 1; 
    }

    function validate_term_and_session($request_data)
    {
        $rules = ['sessions' => 'required', 'term' => 'required'];
        $validate=validator()->make($request_data, $rules);
        return ( $validate->fails() ) ? 0 : 1; 
    }

    function validate_accounts($data) 
    {
        $rules=[
            'sessions' => 'required',
            'term'=> 'required',
            'created_by' => 'required',
            'school_id' => 'required|numeric',
            'amount' => 'required|numeric',
            'description' => 'required'
        ];
        $validate=validator()->make($data, $rules); 
        return ( $validate->fails() ) ? 0 : 1;
    }

    function validate_result_computation_requests($data)
    {
        $rules=[
            'field1' => 'required|numeric',
            // 'exam_score' => 'required|numeric',
            'total_score' => 'required|numeric',
        ];
        $validate=validator()->make($data, $rules);
        return ( $validate->fails() ) ? 0 : 1;
    }

}