<?php
namespace App\Http\Controllers\Traits;

use App\models\activity_log;
use App\models\result_comment;
use App\models\result_setting;
use App\models\sch_session;
use App\models\school_mail_inbox;
use App\models\school_signature;
use App\models\subject_group;
use App\models\subject_result;
use App\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Image;

trait my_school_data{ 
    use validate_data; 

    function current_user_names()
    {
        $user = auth()->user();
        $other_name = '';
        if( $oname = $user->other_name ) $other_name = $oname ;
        return $user->last_name.' '.$user->first_name.' '.$other_name ;
    }

    function random_strings( $length = 30 )
    {
        return Str::random( $length );
    }
    
    function get_this_current_term_and_session_accounts_records( $query )
    {
        $current = $this->current_session();
        if($current):
            return $this->my_school($query)->whereTerm( $current->term )->whereSessions( $current->sessions );
        endif;
        return 0;
    }

    function my_school( $query )
    {
        return $query->whereSchool_id( auth()->user()->school_id );
    }

    function my_data_only( $query )
    {
        return $this->my_school( $query )->whereUser_id( auth()->id() ); 
    }

    function current_session()
    {
       return ($c = $this->my_school( new sch_session )->whereActive( 1 ) ) ? $c->latest('updated_at')->first() : null;
    }

    function get_current_students()
    {
        $current = $this->current_session();
        return  ($current)  ? $this->my_school(new User)
                                   ->whereStudent(1)
                                   ->whereTarget_session($current->sessions)
                                   ->whereDeleted(0)
                            :false; 
    }

    function get_current_staff() 
    {
        return $this->my_school(new User)->whereStaff(1)->whereDeleted(0);
    }

    function admin_signature()
    {
        $signature = $this->my_school(new school_signature)->latest()->first();
        return ( $signature != null ) ? $signature->signature : false;
    }

    function admin_result_comments()
    {
        return $this->my_school(new result_comment)->whereStaff('0');
    }

    function teacher_result_comments()
    {
        return $this->my_data_only(new result_comment)->whereStaff('1');
    }

    function selected_user( $query, $id )
    {
        return $this->my_school( $query )->whereUser_id($id); 
    }

    function user( $query, $id )
    {
        return $this->my_school( $query )->whereId($id)->first(); 
    }

    function student_subject_results()
    {
        if(! $this->validate_class_subject_term_and_session_data( request()->all()) ) return $this->error_msg(' Please, ensure all fields are properly Selected...');
        $find_result = $this->my_school(new subject_result)->whereTerm( request()->term)
                                                           ->whereSessions( request()->sessions)
                                                           ->whereClasses( request()->classes);                                                     
        if( request()->arms) $find_result = $find_result->whereArms( request()->arms) ;
        if( request()->subjects)$find_result = $find_result->whereSubjects( request()->subjects );
        return $find_result;
    }

    function ordinal( $position )
    {
        $j = $position % 10;  
        $k = $position % 100; 
        $str = '';     
        if ($j == 1 && $k != 11) {
            $str = "st";
        } elseif ($j == 2 && $k != 12) {
            $str = "nd";
        } elseif ($j == 3 && $k != 13) {
            $str = "rd";
        } else {
            $str = "th";
        }
        return $position.$str;
    }
    
    function error_msg($msg='Failed, an error Occured...')
    {
        return response()->json(['error'=> $msg]);
    }

    function success_msg($msg = 'Success...')
    {
        return response()->json(['success'=> $msg]);
    }
    
    function online_class($query)
    {
        return $this->my_school($query)->whereDeleted(0);
    }

    function my_classroom_only($query)
    {
        return $this->my_data_only($query)->whereDeleted(0);
    }

    public function resize_and_save_image($img, $path, $insert_watermark = false, $width = 300, $height = 250)
    {
        $school = auth()->user()->school;
        $image  = Image::make($img)->resize($width, $height, function($constraint){
                        $constraint->aspectRatio();
                    });
        if($insert_watermark):
            if($school->logo):
                $watermark_url = public_path().'/uploaded_files/school_logo/'.$school->id.'/'.$school->logo;
                $watermark = Image::make( $watermark_url )->resize( 40, 40, function( $constraint ){
                    $constraint->aspectRatio();
                });   
                $image->insert($watermark, 'bottom-left');
            endif;
        endif;
        $image->save( $path );
    }

    function file_size_in_mb( $file_size )
    {
        return number_format( $file_size / 1048576, 2 );
    }

    function file_size_in_kb( $file_size )
    {
        return number_format( $file_size / 1025, 2 ); 
    }

    function query_school_data( $model )
    {
        $term = request()->term;
        $sessions = request()->sessions;
        $arms = request()->arms;
        $classes = request()->classes;

        $data = $this->my_school($model)->whereTerm( $term ) 
                                        ->whereSessions( $sessions )
                                        ->whereClasses( $classes );
        if( $arms != '' ) $data  = $data->whereArms( $arms );
        return $data;
    }

    function request_data($model)
    {
        $term = request()->term;
        $sessions = request()->sessions;
        //$arms = request()->arms;
        $classes = request()->classes;

        $data = $this->my_school($model)->whereTerm( $term ) 
                                        ->whereSessions( $sessions )
                                        ->whereClasses( $classes );
        return $data;
    }

    function get_subject_groups()
    {
        return $this->my_school( new subject_group )->latest()->get();
    }

    function get_academic_result_settings()
    {
        $data = null;
            $find = $this->my_school(new result_setting)->latest('updated_at');
            if( $find->exists() ):
                $data = $find->first();
            endif;
        return $data;
    }

    function activity_log( $description, $status = 0 )
    {
        $current = $this->current_session();
        $user = auth()->user();
        $activity = new activity_log();
        $activity->user_id = $user->id;
        $activity->school_id = $user->school_id;
        $activity->description = $description;
        $activity->status = $status;
        $activity->ip_address = request()->ip();
        if( $current ):
            $activity->term = $current->term;
            $activity->sessions = $current->sessions;
        endif;
        $activity->save();
    }

    function fetch_my_mails()
    {
        return $this->my_school( new school_mail_inbox )->whereUser_id( auth()->id() )->with("school_mail")->latest();
    }

}


