<?php

namespace App\Http\Controllers\Super_admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\my_school_data;
use App\models\sch_session;
use App\models\school;
use App\User;
use Illuminate\Http\Request;

class IndexController extends Controller
{
    use my_school_data;

    function activate_schools(Request $request)
    {
        $data = $request->id;
        foreach($data as &$school_id):    
            if(! school::whereId($school_id)->update(['active' => 1 ])) $this->error_msg() ;
        endforeach;
        unset($school_id);
        $msg = ( count($data) == 1) ? "Activated a School " : "Activated ".count($data)." Schools " ;
        $this->activity_log($msg);
        return $this->success_msg(); 
    }

    function de_activate_schools(Request $request)
    {
        $data = $request->id;
        foreach($data as &$school_id):    
            if(! school::whereId($school_id)->update(['active' => 0 ])) $this->error_msg() ;
        endforeach;
        unset($school_id);
        $msg = ( count($data) == 1) ? "De-Activated a School " : "De-Activated ".count($data)." Schools " ;
        $this->activity_log($msg);
        return $this->success_msg(); 
    }

    function store_school(Request $request)
    {
        $store = school::create($request->all() );
        $this->activity_log("Added a New School - ".$store->name." - with School ID - ". $store->id);
        return (! $store ) ? $this->error_msg() : $this->success_msg();
    }

    function store_school_admin(Request $request)
    {
        ($request->has('super_admin')) ? $super_admin = 1 : $super_admin = 0;
        $store = User::create([
                          'school_id' => $request->school_id,
                          'last_name' => $request->last_name,
                          'first_name' => $request->first_name,
                          'gender' => $request->gender,
                          'password' => bcrypt( strtolower($request->last_name) ),
                          'admin' => 1,
                          'staff' => 1,
                          'super_admin' => $super_admin,
                          'accountant' => 1,
                          'phone' => $request->phone
                   ]);
        $user_name = $store->last_name. " ".$store->first_name. " ". $store->other_name ;
        $msg = ( $super_admin ) ? "Added ".$user_name." as a New Super Admin to School with ID - ".request()->school_id 
                                : "Added ".$user_name." as a New Admin to School with ID - ".request()->school_id ;
        $this->activity_log( $msg );
        return (! $store ) ? $this->error_msg() : $this->success_msg();
    }

    function school_current_session($school_id)
    {
        $active = sch_session::whereSchool_id($school_id)->whereActive(1)->latest('updated_at')->first();
        return ($active) ? $active->sessions : null;
    }

    function fetch_info_and_stats_about_this_school($school_id)
    { 
        $total_staff    = User::whereSchool_id($school_id)->whereStaff(1)->whereDeleted(0)->latest('updated_at')->get();
        $total_students = User::whereSchool_id($school_id)->whereTarget_session($this->school_current_session($school_id))
                                                          ->whereStudent(1)->whereDeleted(0)->get()->toArray();
        $school = school::find( $school_id );
        $total_boys = array_filter($total_students, function($total){
            return ($b = $total['gender'] == 'male')? $b : 0;
        });
        $total_girls = array_filter($total_students, function($total){
            return ($b = $total['gender'] == 'female')? $b : 0;
        });
        $data = 
        [
            'total_students' => count($total_students),
            'school' => $school,
            'total_staff' => $total_staff,
            'total_girls' => count($total_girls),
            'total_boys' => count($total_boys)
        ];
        return response()->json( $data );
    }

    function fetch_all_schools()
    {
        $schools = school::latest('updated_at')->get();
        return datatables()->of($schools)
                           ->addColumn('checkbox', function($schools){
                               return "<input type='checkbox' class='checkSingle form-control check_btn' name='id[]' value='$schools->id' >" ;
                           })
                           ->editColumn('active', function ($schools) {
                                return ($schools->active) ? "<i class=' fa fa-check text-success'></i>" : "<i class='fa fa-ban text-danger'></i>" ;
                           })
                           ->editColumn('type', function ($schools) {
                               return "<span class='font-12'>" . $schools->type ."</span>" ;
                            })
                           ->addColumn('actions', function($schools) {
                                return "<button type='button' class='school_info_btn btn-sm btn btn-outline-info' id='$schools->id'> View </button>";
                            })
                           ->rawColumns(['checkbox', 'active', 'actions', 'created_by', 'type'])
                           ->make(true);
    }

    function update_school_details()
    {
        //return request()->all();
        $update = school::whereId( request()->id )->update( request()->except("created_at") );
        return ! $update ? $this->error_msg() : $this->success_msg();
    }

}
