<?php

namespace App\Http\Controllers\Staff;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\my_school_data;
use App\models\form_teacher;
use App\models\grade;
use App\models\Staff_class;
use App\models\student_attendance;
use App\models\subject_result;
use App\User;
use Illuminate\Http\Request;

class StaffController extends Controller
{
    use my_school_data;

    function fetch_staff_classes_and_subjects()
    {
        $fetch = $this->my_data_only( new Staff_class )->latest()->get();
        return datatables()->of( $fetch )
                           ->addColumn('actions', function($fetch){
                               $url = "classes=".$fetch->classes."&arms=".$fetch->arms."&subjects=".$fetch->subjects."&school_id=".$fetch->school_id. "&term=".$fetch->term."&sessions=".$fetch->sessions;
                               return "<button type='button' id='$url' class='_actions word_no_wrap btn btn-outline-info btn-sm'> View </button>" ;
                           })
                           ->editColumn('classes', function($fetch){
                               return "<span class='text-capitalize'> ". strtolower($fetch->classes.' '.$fetch->arms) . "</span>";
                           })
                           ->editColumn('subjects', function($fetch){
                              return "<span class='text-capitalize'> ". strtolower($fetch->subjects) . "</span>";
                             })
                           ->rawColumns(['actions', 'classes', 'subjects'])
                           ->make(true);
    }

    function fetch_students_of_this_class()
    {
        return $this->my_school( new User )->whereTarget_session( request()->sessions )
                                                ->whereTarget_arm( request()->arms )
                                                ->whereTarget_class( request()->classes )
                                                ->whereStudent(1)
                                                ->whereDeleted(0)
                                                ->orderBy('last_name')
                                                ->select('last_name', 'first_name', 'other_name','id')
                                                ->get();
    }

    function get_all_students_of_this_class( Request $request ) 
    {
        $students = $this->fetch_students_of_this_class();
        return datatables()->of($students)
                           ->addColumn('name', function($students){ 
                                $name= strtolower( $students->last_name.' '.$students->first_name.' '.$students->other_name );
                                return "<span id='name-$students->id'> ". ucwords( $name) ."</span>";
                           })
                           ->addColumn('field_1', function($students){
                               return "<input type='number' required step='any' id='field1-$students->id' value='' class='form-control form-width-80' name='field1' placeholder='0.00'>";
                           })
                           ->addColumn('field_2', function($students){
                               return "<input type='number' required step='any' id='field2-$students->id' value='' class='form-control form-width-80' name='field2' placeholder='0.00'>";
                            })
                            ->addColumn('field_3', function($students){
                                return "<input step='any' type='number' id='field3-$students->id' class='form-control form-width-80' name='field3' placeholder='0.00'>";
                            })
                            ->addColumn('field_4', function($students){
                                return "<input step='any' type='number' id='field4-$students->id' class='form-control form-width-80' value='' name='field4' placeholder='0.00'>";
                            })
                            ->addColumn('exam', function( $students){
                                return "<input type='number' step='any' required id='exam-$students->id' class='form-control form-width-80' name='exam_score' placeholder='0.00'>";
                            })
                            ->addColumn('total', function($students){
                                return "<input type='number' step='any' required id='total-$students->id' class='form-control form-width-80' readonly name='total_score' placeholder='0.00'>";
                            })
                            ->addColumn('teachers_comment', function($students){
                                return "<input type='text' style='width:100%;' maxlength='65' id='teachers_comment-$students->id' class='form-control' name='teachers_comment' placeholder='Comment here...'>";
                            })
                            ->addColumn('actions', function($students){
                                return "<button id='btn-$students->id' class='word_no_wrap btn btn-success btn-sm compute_submit_btn'> Upload </button>".
                                        "<span id='compute_btn_uploading-$students->id' class='hide word_no_wrap>
                                        <i class='fa fa-spin fa-spinner'></i> Uploading... </span> 
                                        <span id='compute_btn_response-$students->id'></span>";
                                 
                            })
                           ->rawColumns(['actions', 'name', 'field_1', 'field_2', 'field_3', 'field_4', 'exam', 'total', 'teachers_comment'])
                           ->make(true);
    }
	
    function store_students_result()
    {
        /**
         * 1. check if this student result exists already and return error, else store the result
         * 2. using the student total_score, find the corresponding teacher's remark/comment, grading, grading comment,
         * 3. for each new record, update the entire Class_average, positions, lowest and highest scores
         */
       // if(! $this->validate_result_computation_requests($request->all() ) ) return $this->error_msg('All marked fields are required... ');
        if( $this->student_subject_results()->whereStudent_id(request()->student_id)->first() ){
           // return $this->error_msg('Result exists already!');
           return $this->update_subject_result();
        }

        if(! $this->store_this_result() ) return $this->error_msg('error!, please retry');
        if(! $this->assign_remarks_and_grading_to_this_result() ) return $this->error_msg('error!, please retry');
        if(! $this->update_class_average_lowest_and_highest_scores() ) return $this->error_msg('error!, please retry');
        if(! $this->update_student_subject_class_position() ) return $this->error_msg('error!, please retry');   
        return $this->success_msg();
    }

    function store_this_result()
    {  
            $data = request()->except('api_token');
            $data['teachers_name'] = $this->current_user_names(); 
        return (! subject_result::create( $data ) ) ? 0 : 1 ; 
    }

    function update_subject_result( $cbt_data = [] )
    {
        if($cbt_data):
            $data = $cbt_data;
        else:
            $data = request()->except(['api','re_update_subject_result']);
            $data['teachers_name'] = $this->current_user_names(); 
        endif;
       // if(! $this->validate_result_computation_requests( $data ) ) return $this->error_msg('All marked fields are required... ');
        $find = $this->student_subject_results()->whereStudent_id( request()->student_id )->first();
        if(! $find ) return $this->error_msg(' Details Not Found... ');
        if(! $find->update( $data ) ) return $this->error_msg();
        if(! $this->assign_remarks_and_grading_to_this_result() ) return $this->error_msg('error!, please retry');
        if(! $this->update_class_average_lowest_and_highest_scores() ) return $this->error_msg('error!, please retry');
        if(! $this->update_student_subject_class_position() ) return $this->error_msg('error!, please retry'); 
        
        if(! request()->re_update_subject_result ):
            $this->activity_log(" Updated ".request()->student_name.' '.request()->subjects.' subject result of '.request()->classes.' '.request()->arms.' Class');
        endif;
        return $this->success_msg();
    }

    function store_cbt_scores_in_subject_result()
    {
            $cbt_computed_score = request()->cbt_computed_score;
            
            $data = [];
            $field_name = request()->cbt_category_field;
            $data['student_id'] = request()->student_id;
            $data['classes'] = request()->classes;
            $data['arms'] = request()->arms;
            $data['subjects'] = request()->subjects;
            $data['term'] = request()->term;
            $data['school_id'] = request()->school_id;
            $data['sessions'] = request()->sessions;
            $data['student_name'] = request()->student_name;
            $data[$field_name] = $cbt_computed_score;
            $data['teachers_name'] = $this->current_user_names();
        $record = $this->student_subject_results()->whereStudent_id(request()->student_id)->first();
        if( $record ){
            $store = $record->update( $data );
            $this->update_cbt_scores_in_subject_result( $record );
        }else{
            $store = subject_result::create( $data );
            $record = $this->student_subject_results()->whereStudent_id(request()->student_id)->first();
            $this->update_cbt_scores_in_subject_result( $record );
        }
        return ( $store ) ? $this->success_msg() : $this->error_msg();
    }

    function update_cbt_scores_in_subject_result( $record )
    {
        $data = [];
        $data['student_id'] = $record->student_id;
        $data['field1'] = $record->field1;
        $data['field2'] = $record->field2;
        $data['field3'] = $record->field3;
        $data['field4'] = $record->field4;
        $data['exam_score'] = $record->exam_score;
        $data['total_Score'] = (float) $record->field1 + (float) $record->field2 + (float) $record->field3 + (float) $record->field4+ (float) $record->exam_score ;
        $this->update_subject_result( $data );
    }

    function assign_remarks_and_grading_to_this_result()
    {
        $grade = ''; 
        $grade_comment = ''; 
        $remarks = '';
        $student= $this->student_subject_results()->whereStudent_id(request()->student_id)->first();
    
        // /**
        //  * Before updating a subject result remark, ensure the initial comment is not a custom comment 
        //  *  (i.e: teacher inserted the comment manually when computing the result... )
        //  */
        // if( $student->custom_comment == 0):
        //     $teacher_comments = $this->teacher_result_comments()->get();
    
        //     foreach($teacher_comments as &$t):
        //         if($student->total_score >= $t->min_score && $student->total_score <= $t->max_score):
        //             $remarks = $t->comments;
        //         else:
        //             continue;
        //         endif;
        //     endforeach; unset($t);
        // endif;

        $grades = $this->my_school(new grade)->get();
        foreach($grades as &$g):
            if($student->total_score >= $g->min_score && $student->total_score <= $g->max_score):
                $grade = $g->grade;
                $grade_comment = $g->comment;
            else:
                continue;
            endif;
        endforeach; 
        unset($g);

        $update = $student->update(['grade'=> $grade, 'comment' => $grade_comment]) ;
        return (! $update ) ? 0 : 1 ;
    }
 
    function update_class_average_lowest_and_highest_scores()
    {
            $students = $this->student_subject_results()->get();
            $total_scores = $students->pluck('total_score')->toArray();
            $total_number = $students->count();
            $class_average = array_sum($total_scores) / $total_number ;
            $lowest_score = $this->student_subject_results()->min('total_score');
            $highest_score = $this->student_subject_results()->max('total_score');
            $update = $this->student_subject_results()->update([
                      'class_average' => $class_average,
                      'lowest_score' =>  $lowest_score,
                      'highest_score' => $highest_score
                    ]);
            return ( ! $update )? 0 : 1;
    }

    function update_student_subject_class_position()
    {
        $students = $this->student_subject_results()->get();
        foreach($students->pluck('student_id')->toArray() as &$student_id):
            $student = $this->student_subject_results()->whereStudent_id($student_id)->first();
            $position = array_search($student->total_score, $students->sortByDesc('total_score')->pluck('total_score')->toArray() ) + 1 ;
            $position = $this->ordinal($position);
            $update = $student->update(['position' => $position ]);
            //if(! $update) return 0;
        endforeach; 
        unset($student_id); 
        return 1;
    }

    function fetch_subject_results()
    {
        $all_results = $this->student_subject_results()->latest('updated_at')->get();
        $single_result = $this->student_subject_results()->first();
        $data = ['all_results' => $all_results, 'single_result' => $single_result ];
        return response()->json($data);
    }
	
    function delete_subject_result()
    {
        $find = $this->user( new subject_result, request()->id );
        if( ! $find ) return $this->error_msg(" Subject Result does not Exist... ");
        $this->activity_log("Deleted ".$find->student_name.' '.$find->subjects.' Subject result of '.$find->classes.' '.$find->arms.' Class');
        $delete = $find->delete();
        return ( ! $delete ) ? $this->error_msg() : $this->success_msg();
    }

    function fetch_my_form_teacher_classes()
    {
        return $this->my_school( new form_teacher )->whereUser_id( auth()->id() )->latest()->get();
    }

    function fetch_students_in_this_form_teachers_class()
    {
        ( $arms = request()->arms ) ? $arms : $arms = null ;
        $current_session = $this->current_session();
        if(! $current_session) return $this->error_msg('Academic Session Not Active !');
        return $this->my_school(new User)->whereTarget_class( request()->classes )
                                         ->whereTarget_arm( $arms )
                                         ->whereTarget_session( $current_session->sessions )
                                         ->whereDeleted(0)
                                         ->orderBy('last_name')
                                         ->get();
    }

    function store_students_attendance()
    {
        // Check to see if this students attendance has been set already, if true..update it hence, store it.
        $current_session = $this->current_session();
        $check = $this->my_school(new student_attendance)
                                    ->whereUser_id(request()->user_id)
                                    ->whereTerm( $current_session->term)
                                    ->whereSessions( $current_session->sessions);
                if( $check->first() ):
                   return $this->update_students_attendance( $check->first() );
                else:
                    $store = student_attendance::create([
                        'user_id' => request()->user_id,
                        'school_id' => auth()->user()->school_id,
                        'name' => request()->name,
                        'classes' => request()->classes,
                        'arms' => request()->arms,
                        'sessions' => $current_session->sessions,
                        'term' => $current_session->term,
                        'days_present' => request()->days_present,
                        'days_absent' => request()->days_absent,
                    ]);
                    return (! $store) ? $this->error_msg() : $this->success_msg();
                endif;
    }

    function update_students_attendance($query) 
    {
        $update = $query->update(request()->except('api_token') );
        return (! $update) ? $this->error_msg('Failed to update record... ') : $this->success_msg();
    }

    function view_attendance_records()
    {
        $current_session = $this->current_session();
        return $this->my_school(new student_attendance)
                                    ->whereTerm( $current_session->term)
                                    ->whereSessions( $current_session->sessions)
                                    ->whereClasses( request()->classes)
                                    ->whereArms( request()->arms )
                                    ->get();
    }
}