<?php

namespace App\Http\Controllers\Staff;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\my_school_data;
use App\Http\Controllers\Traits\validate_data;
use App\models\lesson_note;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class Lesson_noteController extends Controller
{
    use my_school_data;
    use validate_data;

    function store_lesson_note()
    {
        $file_name = ''; $has_file = 0; $file_extension = '';
        $user = auth()->user();
        $data = request()->except('document');
        $current = $this->current_session();
        if(! $current ) return $this->error_msg( " Current Session Not Active... " );
        
        if( request()->hasFile('document') ):
            if( ! $this->validate_classroom_document_upload( $data ) || ! request()->hasFile('document') ) 
              return $this->error_msg(" Invalid File Format, please upload a PDF, DOCX or ZIP file only ");
            $file = request()->document;
            $file_extension = $file->getClientOriginalExtension();
            $file_name = $file->getClientOriginalName()."_".$user->id."_".time()."_".uniqid()."_".$user->school_id.".".$file_extension;
            $path = public_path("uploaded_files/lesson_notes/");
            $file->move( $path, $file_name);
            $has_file = 1;
        endif;

        $data['term'] = $current->term;
        $data['sessions'] = $current->sessions;
        $data['school_id'] = $user->school_id;
        $data['user_id'] = $user->id;
        $data['file_name'] = $file_name;
        $data['file_type'] = $file_extension;
        $data['has_file'] = $has_file;
        $store = lesson_note::create( $data );
        $this->activity_log("Created new ". request()->subject." Subject Lesson Note for ". request()->classes. ' '. request()->arms );
        return ( ! $store ) ? $this->error_msg() : $this->success_msg();
    }

    function index()
    {
        $current = $this->current_session();
        if( ! $current ) return $this->error_msg("Current Active Session Not Detected... ");
        $user = auth()->user();
        $all_lesson_notes = [];
        $student_lesson_notes = [];
        $student_lesson_notes_lastpage = 0;
        $all_lesson_notes_lastpage = 0;
        $all_lesson_notes_total = 0;
        $student_lesson_notes_total = 0;

        $my_lesson_notes_ = $this->selected_user( new lesson_note, $user->id )->latest('updated_at');
        $my_lesson_notes_total = $my_lesson_notes_->count();
        $my_lesson_notes = $my_lesson_notes_->paginate(20);
        $my_lesson_notes_lastpage = $my_lesson_notes->lastpage();
       
        if($user->admin):
            $all_lesson_notes_ = $this->my_school( new lesson_note )->whereIs_published(1)->with('user')->latest("updated_at");
            $all_lesson_notes_total = $all_lesson_notes_->count();
            $all_lesson_notes = $all_lesson_notes_->paginate(20);
            $all_lesson_notes_lastpage = $all_lesson_notes->lastpage();
        endif;

        if( $user->student ):
            $student_lesson_notes_ = $this->my_school( new lesson_note )->whereIs_published(1)
                                                                       ->whereTerm( $current->term )
                                                                       ->whereSessions( $current->sessions )
                                                                       ->whereClasses( $user->target_class );
            if( $user->target_arm ):
                 $student_lesson_notes_ = $student_lesson_notes_->whereArms( $user->target_arm ); 
            else:
                $student_lesson_notes_ = $student_lesson_notes_->whereArms(null ); 
            endif;  
            $student_lesson_notes_total = $student_lesson_notes_->count();
            $student_lesson_notes = $student_lesson_notes_->latest("updated_at")->paginate(20);
            $student_lesson_notes_lastpage = $student_lesson_notes->lastpage();
        endif;

        $data = ['all_lesson_notes' => $all_lesson_notes, 'my_lesson_notes' => $my_lesson_notes, 
                 'student_lesson_notes' => $student_lesson_notes,
                 'student_lesson_notes_lastpage' => $student_lesson_notes_lastpage,
                 'all_lesson_notes_lastpage' => $all_lesson_notes_lastpage,
                 'my_lesson_notes_lastpage' => $my_lesson_notes_lastpage,
                 'student_lesson_notes_total' => $student_lesson_notes_total,
                 'my_lesson_notes_total' => $my_lesson_notes_total,
                 'all_lesson_notes_total' => $all_lesson_notes_total
                ];
        return response()->json( $data );
    }

    function view_lesson_note()
    {
        return $this->user(new lesson_note, request()->id );
    }

    function update_lesson_note()
    {
        $update = $this->view_lesson_note()->update( request()->all() );
        return ( ! $update) ? $this->error_msg() : $this->success_msg();
    }

    function delete_lesson_note()
    {
        $find = $this->view_lesson_note();
        File::delete("uploaded_files/lesson_notes/".$find->file_name);
        $delete = $find->delete();
        $this->activity_log("Deleted ". $find->classes.' '.$find->arms.' '.$find->subject .' Subject Lesson Note');
        return ( ! $delete ) ? $this->error_msg() : $this->success_msg();
    }

    function publish_lesson_note()
    {
        $find = $this->view_lesson_note();
        $publish = $find->update(['is_published' => 1]);
        $this->activity_log("Published ". $find->classes.' '.$find->arms.' '.$find->subject .' Subject Lesson Note');
        return ( ! $publish ) ? $this->error_msg() : $this->success_msg();
    }

    function undo_publish_lesson_note()
    {
        $find = $this->view_lesson_note();
        $undo_publish = $find->update(['is_published' => 0]);
        $this->activity_log("Undo-Published ". $find->classes.' '.$find->arms.' '.$find->subject .' Subject Lesson Note');
        return ( ! $undo_publish ) ? $this->error_msg() : $this->success_msg();
    }

}


