<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Traits\my_school_data;
use App\User;
use Illuminate\Http\Request;

class SmsController extends Controller
{
    use my_school_data;

    public function __construct()
    {
        $this->middleware('auth');
    }
    
    function fetch_all_students()
    {
        $data = $this->my_school( new User )->whereStudent(1)->whereTarget_session( $this->current_session()->sessions )->pluck('sponsor_phone');
        $data = implode(',', $data->toArray() );
        $data = explode(',', $data);
        $data = array_unique($data);
        $data = $this->format_phone_numbers( $data );
        $data = implode(',', $data);
        return response()->json( $data );
    }

    function fetch_all_staff()
    {
        $data = $this->my_school(new User)->whereStaff(1)->whereActive(1)->pluck('phone');
        $data = implode(',', $data->toArray() );
        $data = explode(',', $data);
        $data = array_unique($data);
        $data = $this->format_phone_numbers( $data );
        $data = implode(',', $data);
        return response()->json( $data );
    }

    function format_phone_numbers( $phone_numbers )
    {
        $data = [];
        foreach( $phone_numbers as &$phone):
            $phone = trim($phone);
            if( substr($phone, 0, 1) == 0 && strlen($phone) == 11):
                $phone = substr($phone, 1);
                $phone = "234".$phone;
            elseif( strlen($phone) == 10 ):
                $phone = "234".$phone;
            else:
                continue;
            endif;
            array_push($data, $phone);
        endforeach;
        unset( $phone );
        return $data;
    }

}

