<?php

namespace App\Http\Controllers;
use App\Http\Controllers\Traits\my_school_data;
use App\models\school;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\File;

class ProfileController extends Controller
{ 
    use my_school_data;
    
    public function __construct() 
    {
        $this->middleware('auth');
    }

    function update_school_info(Request $request)
    {
        if(! $this->validate_user_photo($request->all(), 'logo') ) return $this->error_msg('Please, ensure you are uploading an Image file and it is not more than 2mb...');
        $school= auth()->user()->school;
        if(! $request->hasFile('logo')){
            if(! school::findOrFail($school->id)->update($request->all() ) ) return $this->error_msg();
        }else{
            $img = $request->file('logo');
            $directory_path = "uploaded_files/school_logo/".$school->id;
            if(! File::isDirectory($directory_path) ){
                   File::makeDirectory($directory_path, 0755, true, true);
            };
            File::delete('uploaded_files/school_logo/'.$school->id.'/'. $school->logo);
            $name = $school->id.'_'.uniqid(). '_' . time().'.jpg';
            $file_path = public_path().'/'.$directory_path.'/'.$name;
            //Reduce  Image size
            $this->resize_and_save_image($img, $file_path, false, 300, 250); 

            $update = school::find($school->id)->update([
                'website' => $request->website,
                'name' => $request->name,
                'email' => $request->email,
                'address' => $request->address,
                'lga' => $request->lga,
                'logo' => $name,
                'motto' => $request->motto,
                'country' => $request->country,
                'state' => $request->state,
                'phone' => $request->phone,
            ]);
            if(! $update) return $this->error_msg();
        }
        $this->activity_log("Updated School Information");
        return $this->success_msg();
    }

    public function update_user_profile(Request $request)
    {
        if(! $this->validate_user_data($request->all()) ) return $this->error_msg('Please, ensure all information are very accurate...') ;
        $update=$this->user(new User, $request->id)->update( $request->all() );
        $this->activity_log("Updated a Profile");
        return (! $update) ? $this->error_msg() : $this->success_msg('Profile updated successfully !'); 
    }

    public function update_user_passport(Request $request)
    {   
      if(! $this->validate_user_photo($request->all()) ) return $this->error_msg('Please, ensure you are uploading an Image file and it is not more than 2mb...');
        $img = $request->File('photo');
        $user_id=auth()->id();
        if($request->has('_id')): $user_id=$request->_id; endif;  
        $user = $this->user(new User, $user_id ); 
        if( $user):     
            $name = $user_id.'_'.uniqid(). '_' . time() . '.jpg';
            $directory_path = 'uploaded_files/passports/'.auth()->user()->school_id ; 
             if(! File::isDirectory($directory_path) ){
                   File::makeDirectory($directory_path, 0755, true, true);
             };
             File::delete('uploaded_files/passports/'.auth()->user()->school_id.'/'.$user->photo);
            $file_path = public_path().'/'.$directory_path.'/'.$name;
            //Reduce  Image size
            $this->resize_and_save_image($img, $file_path);
            $update = $user->update([ 'photo' => $name ]);    
            return (! $update) ? $this->error_msg() : $this->success_msg('Passport updated successfully !'); 
        endif;
           return $this->error_msg();
           $this->activity_log("Updated Passport Photo");
    }   

    public function update_user_password(Request $request)
    {
        $rules = ['old_password' => 'required', 'new_password' => 'required|min:6'];

        if (validator()->make($request->all(), $rules)->fails() ) :
            return $this->error_msg( 'All Fields are required (Do ensure the password matches' );
        endif;
        if (!(Hash::check($request->old_password, auth()->user()->password))) :
            return $this->error_msg('Default Password is Incorrect');
        else:
            if( ! $this->user(new User, auth()->id() )->update(['password' => bcrypt($request->new_password)] ) ) :
                return $this->error_msg();
            endif;
        endif;
        $this->activity_log("Updated Personal Password");
            Auth::logoutOtherDevices($request->new_password);
            return $this->success_msg('Password updated successfully, Please Re-Login with this current password!');
    }
}
