<?php

namespace App\Http\Controllers\Online_class;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use App\Http\Controllers\Traits\my_school_data;
use App\models\classroom;
use App\models\classroom_member;
use App\models\classroom_post;
use App\models\classroom_post_file;
use App\User;
use Intervention\Image\Exception\NotReadableException;
use Image;


class ClassroomController extends Controller
{
    use my_school_data;

    function store_classroom(Request $request)
    {
         if(! $this->validate_online_new_classroom_request($request->all()) ) return $this->error_msg('Please, ensure all fields are properly field... ');
         if(! $current_session = $this->current_session()) return $this->error_msg(' Current Term and Session has not been activated... '); 
         $user = auth()->user();
         $class_code = strtoupper( uniqid() );
         $subject = $request->class_subject;
         $class_name = $request->class_name;
         $class_arm = $request->class_arm;
         $term = $current_session->term;
         $sessions = $current_session->sessions;
         $user_id = $user->id;
         $school_id = $user->school_id;
         $store = classroom::create([
             'user_id' => $user_id,
             'school_id' => $school_id,
             'name' => $class_name,
             'arm' => $class_arm,
             'code' => $class_code,
             'term' => $term,
             'sessions' => $sessions,
             'subject' => $subject
         ]); 
         if(! $store) return $this->error_msg() ;
          $data = ['success'=> 'Class created succesfully...' , 'classroom' => $store];
          return response()->json($data);
    }

    function fetch_classroom()
    {
         $my_classrooms = $this->my_classroom_only(new classroom)->latest()->get();
         $all_school_created_classes = $this->online_class(new classroom)
                                      ->latest()
                                      ->with('classroom_post_files', 'classroom_members', 'classroom_posts', 'user' )
                                      ->get();
            $data = ['my_classrooms' => $my_classrooms, 'all_school_created_classes' => $all_school_created_classes];
            return response()->json( $data);
    }

    function find_this_online_classroom(Request $request)
    {
        // == first check if this class code exists , if true, store user in classroom_member model
        $class_code = $request->class_code;
        $find = $this->online_class(new classroom)->whereCode($class_code)->first();
        if( ! $find):
            return $this->error_msg(' Invalid Classroom Code... ');
        endif;
            return $find;
    }

    function delete_this_online_classroom(Request $request)
    {
        $find = $this->my_data_only(new classroom)->whereId( $request->class_id )->first();
        if( $find ):
            $archive = $find->delete();
            return ($archive) ? $this->success_msg(' Classroom deleted successfully...') : $this->error_msg() ;
        endif;
    }

    function fetch_all_classrooms_i_belong_to()
    {
        return $this->my_classroom_only(new classroom_member)->with(['classroom' => function($q){
                      $current_session = $this->current_session();
                      $q->whereSessions($current_session->sessions);
                }])->latest()->get();
    }

    function ensure_user_is_a_member_of_this_class()
    {
        /**
         * 1. Ensure the user accessing this class_code is a member of this school 
         * 2. create or update this user in the classroom_member model
         * 3. Ensure the classroom has not been deleted, if deleted, return false
         */
        $admin = 0;
        $class_code = request()->class_code;
        $class_id = request()->class_id;
        $verify = $this->online_class(new classroom)->whereCode($class_code)->first();
        if(! $verify) return $this->error_msg(' Something seems to be wrong with this link.. ');
        if(! $current_session = $this->current_session()) return $this->error_msg(' Academic Term/Session not Active... ');
        if($verify->sessions !=  $current_session->sessions ) return $this->error_msg(' Something seems to be wrong with this link.. ');
        if( $verify->deleted ) return $this->error_msg(" This Classroom doesn't exist anymore... ");
        $user_exists = $this->my_classroom_only(new classroom_member)->whereClassroom_id( $class_id )->first();
        if(! $user_exists):
            if($verify->user_id == auth()->id()) $admin = 1;
            $store = classroom_member::create([
                'user_id'       => auth()->id(),
                'school_id'     => auth()->user()->school_id,
                'classroom_id'  => $class_id,
                'admin'         => $admin
            ]);
            if($store) return $this->success_msg(' You are now a Partipant of this class.. ');
        endif;
    }

    function store_post()
    {
        $user = auth()->user();
        $class_id = request()->class_id;
        $content = request()->content;
        $store = classroom_post::create([ 
            'classroom_id' => $class_id,
            'school_id' => $user->school_id,
            'user_id' => $user->id,
            'content' => $content
        ]);
        return (! $store) ? $this->error_msg() : $store;
    }

    function classroom_members()
    {
        return $this->online_class(new classroom_member)->whereClassroom_id( request()->class_id )
                                                        ->with('user')
                                                        ->latest()
                                                        ->get();
    }

    function get_suggested_students()
    {
        /**
         * 1. get current session, term, class, arm of this classroom and find students who are likely to be in that class.
         * 2. ensure that students participating already in the classroom should not come up as suggested again...
         */
        $search = [];
        $classroom_participants = $this->classroom_members()->pluck('user_id')->toArray();
        $current_session = $this->current_session();
        $class = $this->online_class(new classroom)->whereId( request()->class_id)->first();
        if( $class ):
            $search = $this->my_school(new User)->whereStudent(1)
                                                ->whereTarget_session($current_session->sessions)
                                                ->whereTarget_class($class->name);
            //($class->arm) ? $search = $search->whereTarget_arm($class->arm) : $search; 
                                    $search = $search->get()
                                                     ->sortBy('last_name')
                                                     ->except($classroom_participants)
                                                     ->take(100);
        endif;
        return $search;
    }

    function fetch_this_classroom_posts()
    {
        /***
         * 1. find the time when this user joined this classroom.
         * 2. fetch records from the time when user joined only...
         */
        $user_joined_date = $this->my_classroom_only(new classroom_member)->whereClassroom_id( request()->class_id )->first()->created_at;
        $posts = $this->online_class(new classroom_post)->whereClassroom_id( request()->class_id )
                      ->where('created_at', '>=' , $user_joined_date)
                      ->with('user', 'classroom_post_files')
                      ->latest()
                      ->get();

        $class_members = $this->classroom_members();
        $suggested_students = $this->get_suggested_students();
        $classroom_shared_files = $this->online_class(new classroom_post_file)->whereClassroom_id(request()->class_id)
                                                                              ->latest()
                                                                              ->get();

        $data = ['posts' => $posts, 'class_members' => $class_members, 'suggested_students' => $suggested_students,
                 'classroom_shared_files' => $classroom_shared_files];

        return response()->json($data);
    }

    function delete_this_post()
    {
        $post_id = request()->post_id;
        $find = $this->my_classroom_only(new classroom_post)->whereId($post_id)->first();
        ($find ) ? $find->delete() : '';
        return $this->success_msg();
    }

    function remove_user_from_classroom()
    {
        $this->online_class(new classroom_member)->whereId( request()->member_id )->delete();
        return $this->success_msg('Removed Successfully...');
    }

    function add_user_to_classroom()
    {
        $user_id = request()->user_id;
        $classroom_id = request()->classroom_id;
        $store = classroom_member::updateOrCreate([
            'user_id' => $user_id,
            'school_id' => auth()->user()->school_id,
            'classroom_id' => $classroom_id
        ]);
        return (! $store) ? $this->error_msg() : $this->success_msg('Student Added successfully...') ;
    }

    function delete_classroom_files()
    {
        $id = request()->id;
        $find = $this->my_classroom_only(new classroom_post_file)->whereId($id)->first();
        $this->delete_classroom_file_from_document_folder( $find->name);
        ($find ) ? $find->delete() : '';
        return $this->success_msg();
    }

    function delete_classroom_file_from_document_folder( $file_name )
    {
        File::delete("uploaded_files/classroom/".auth()->user()->school_id."/images/".$file_name);
        File::delete("uploaded_files/classroom/".auth()->user()->school_id."/audios/".$file_name);
        File::delete("uploaded_files/classroom/".auth()->user()->school_id."/videos/".$file_name);
        File::delete("uploaded_files/classroom/".auth()->user()->school_id."/documents/".$file_name);
    }

    function save_classroom_files($class_id, $class_post_id, $file_name, $ext , $file_size, $file_type)
    {
        $store = classroom_post_file::create([
            'user_id' => auth()->id(),
            'school_id' => auth()->user()->school_id,
            'classroom_id' => $class_id,
            'classroom_post_id' => $class_post_id,
            'name' => $file_name,
            'extension' => $ext,
            'size' => $file_size,
            'type' => $file_type
        ]);
        return (! $store) ? 0 : 1;
    }

    function store_classroom_post_files()
    {
        if( request()->hasFile('image') ) return $this->upload_classroom_file_image();
        if( request()->hasFile('video') ) return $this->upload_classroom_file_video();
        if( request()->hasFile('document') ) return $this->upload_classroom_file_document();
        if( request()->hasFile('audio') ) return $this->upload_classroom_file_audio();
    }

    function upload_classroom_file_video() 
    {
        $videos = request()->file('video');
        if(! $this->validate_classroom_video_upload(request()->all() ) ) return $this->error_msg("Something went wrong, Please ensure you are Uploading a video file..");
        $classroom_post = $this->store_post();
        $class_post_id = $classroom_post->id;
        $class_id = $classroom_post->classroom_id;
        foreach($videos as &$video):
            $file_extension = "mp4"; //strtolower($video->extension() );
            $size = $video->getSize();
            $file_name = auth()->id().'_'.uniqid().'_'.time().'.'.$file_extension;
            $file_path = public_path('/uploaded_files/classroom/'.auth()->user()->school_id.'/videos/');
            $file_size = ( $this->file_size_in_mb( $size) <= 0.9) ? $this->file_size_in_kb( $size) ." Kb" : $this->file_size_in_mb( $size).' Mb' ;
            $file_type = 'video';
            $video->move($file_path, $file_name);
            if(! $this->save_classroom_files($class_id, $class_post_id, $file_name, $file_extension, $file_size, $file_type) ):
                return $this->error_msg();
            endif;
        endforeach;
        unset($video);
        return 'success';
    }

    function upload_classroom_file_document()
    {
        $documents = request()->file('document');
        if(! $this->validate_classroom_document_upload(request()->all() ) ) return $this->error_msg("Please, ensure you are Uploading a file, Supported files.. (.pdf, .docx, .xlxs, .csv, .zip )");
        $classroom_post = $this->store_post();
        $class_post_id = $classroom_post->id;
        $class_id = $classroom_post->classroom_id;
        foreach($documents as &$document):
            $file_extension = strtolower($document->getClientOriginalExtension() );
            $size = $document->getSize();
            $file_name = auth()->id().'_'.uniqid().'_'.time().'.'.$file_extension;
            $file_path = public_path('/uploaded_files/classroom/'.auth()->user()->school_id.'/documents/');
            $file_size = ( $this->file_size_in_mb( $size) <= 0.9) ? $this->file_size_in_kb( $size) ." Kb" : $this->file_size_in_mb( $size).' Mb' ;
            $file_type = 'document';
            $document->move($file_path, $file_name);
            if(! $this->save_classroom_files($class_id, $class_post_id, $file_name, $file_extension, $file_size, $file_type) ):
                return $this->error_msg();
            endif;
        endforeach;
        unset($document);
        return 'success';
    }

    function upload_classroom_file_image() 
    {
        $images = request()->file('image');
        if(! $this->validate_classroom_image_upload( request()->all() ) ) return $this->error_msg("Please ensure you are Uploading an Image...(Supported formats: .png, .jpg,.jpeg,.gif)");
        $classroom_post = $this->store_post();
        $class_post_id = $classroom_post->id;
        $class_id = $classroom_post->classroom_id;
        foreach($images as &$img):
            $file_extension = '.jpg';
            $size = $img->getSize();
            $file_name = auth()->id().'_'.uniqid().'_'.time().$file_extension;
            $directory_path = 'uploaded_files/classroom/'.auth()->user()->school_id.'/images' ;
            if(! File::isDirectory($directory_path) ){
                File::makeDirectory($directory_path, 0755, true, true);
             };
            $file_path = public_path().'/'.$directory_path.'/'.$file_name;
            $file_size = ( $this->file_size_in_mb( $size ) <= 0.9) ? $this->file_size_in_kb( $size ) ." Kb" : $this->file_size_in_mb( $size ).' Mb';
            $file_type = 'image';
            $image = Image::make($img);    
            $image->resize(650, 600, function( $constraint ){
                $constraint->aspectRatio();
            })
            ->save($file_path);
            if(! $this->save_classroom_files($class_id, $class_post_id, $file_name, $file_extension, $file_size, $file_type) ):
                return $this->error_msg();
            endif;
        endforeach;
        unset($img);
        return 'success';
    }

    function upload_classroom_file_audio()
    {
        $audios = request()->file('audio');
        $file_extension = 'mp3';
        if(! $this->validate_classroom_audio_upload( request()->all() ) ) return $this->error_msg(" Please, ensure you are Uploading an audio file... ");
        $classroom_post = $this->store_post();
        $class_post_id = $classroom_post->id;
        $class_id = $classroom_post->classroom_id;
        foreach($audios as &$audio):
           // $ext = $audio->getClientOriginalExtension();
           // ($ext != 'mpga' ) ? $file_extension = $ext : $file_extension ;
            $size = $audio->getSize();
            $file_name = auth()->id().'_'.uniqid().'_'.time().'.'.$file_extension;
            $file_path = public_path('/uploaded_files/classroom/'.auth()->user()->school_id.'/audios/');
            $file_size = ( $this->file_size_in_mb( $size) <= 0.9 ) ? $this->file_size_in_kb( $size) ." Kb" 
                                                                   : $this->file_size_in_mb( $size) ." Mb" ;
            $file_type = 'audio';
            $audio->move($file_path, $file_name);
            if(! $this->save_classroom_files($class_id, $class_post_id, $file_name, $file_extension, $file_size, $file_type) ):
                return $this->error_msg();
            endif;
        endforeach;
        unset($audio);
        return 'success';
    }

    function check_if_user_can_upload_file_and_make_posts()
    {
        return $this->online_class(new classroom)->whereId( request()->class_id)->first();
    }

    function update_classroom_user_upload_settings()
    {
        $user_can_upload = 0;
        $class_id = request()->class_id;
            if(request()->has('allow_file_uploads')) $user_can_upload = 1;
            $update = $this->online_class(new classroom)->whereId( $class_id )
                                                        ->update(['allow_file_uploads' => $user_can_upload ]);
            return (! $update) ? $this->error_msg() : $this->success_msg();
    }

    function update_classroom_user_post_settings()
    {
        $user_can_post = 0;
        $class_id = request()->class_id;
            if(request()->has('allow_posts')) $user_can_post = 1;
            $update = $this->online_class(new classroom)->whereId( $class_id )
                                                        ->update([
                                                             'allow_posts' => $user_can_post,
                                                        ]);
            return (! $update) ?  $this->error_msg() : $this->success_msg();
    }

}

