<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Traits\my_school_data;
use App\models\school_mail;
use App\models\school_mail_inbox;
use App\User;
use Illuminate\Http\Request;

class MailController extends Controller
{
    use my_school_data;

    public function __construct()
    {
        $this->middleware('auth');
    }

    function store_mail()
    {
        /**
         * if request()->status is equal to::
         * 1 => Class
         * 2 => All students
         * 3 => All staff
         * 4 => Individuals
         * 5 => Both Staff and students
         */
        $current = $this->current_session();
        $classes = request()->classes;
        $status = request()->status;
        $individuals = request()->individuals;
        $sent_to = [];
        $user = auth()->user();
        if(! $current ) return $this->error_msg(" Active Academic Session Not Detected... ");
        if( $status == 4 && request()->individuals == "") return $this->error_msg(" Please, Enter User ID before proceeding... ");
        if( $status == 1 && request()->classes == "") return $this->error_msg(" Please Select a Class before proceeding...  ");
        
        if( request()->title == '' || request()->content == '' || request()->type == '') return $this->error_msg(" Empty Field Detected... ");
        if( $status == 1 ) $sent_to = $classes;
        if( $status == 4 ) $sent_to = explode(",", $individuals );
        $data = request()->except(["classes", 'individuals']);
        $data['user_id'] = $user->id;
        $data['school_id'] = $user->school_id;
        $data['term'] = $current->term;
        $data['sessions'] = $current->sessions;
        $data['status'] = $status;
        $data['code'] = $this->random_strings(60);
        $data['sent_to'] = $this->mail_to($status);
        $store_mail = $this->save_main_mail( $data );
        if( $store_mail ) $this->extract_users_and_send_mails_to_inbox( $store_mail, $sent_to );
        $this->activity_log("Sent a ".request()->type ." to ". $this->mail_to($status) );
        return ( ! $store_mail ) ? $this->error_msg() : $this->success_msg();
    }

    function mail_to( $status )
    {
        $response = '';
        if( $status == 1) $response = "a Class";
        if( $status == 2) $response =  "all Students";
        if( $status == 3) $response =  "all Staff";
        if( $status == 4) $response =  "an Individual";
        if( $status == 5) $response =  "all Staff and Students";
        return $response;
    }
    
    function save_main_mail( $data )
    {
        return school_mail::create( $data );
    }

    function fetch_students_by_class($class_, $current_session)
    {
        return $this->my_school(new User)->whereActive(1)->whereStudent(1)->whereTarget_class( $class_ )->whereTarget_session($current_session)->get();
    }

    function fetch_and_store_all_students_mail_inbox($mail)
    {
        $users = $this->my_school(new User)->whereStudent(1)->whereActive(1)->whereTarget_session($mail->sessions)->get()->pluck('id');
        $this->store_users_mail_inbox( $mail, $users);
    }

    function fetch_and_store_all_staff_mail_inbox($mail)
    {
        $users = $this->my_school(new User)->whereStaff(1)->whereActive(1)->get()->pluck("id");
        $this->store_users_mail_inbox( $mail, $users);
    }

    function extract_users_from_class_and_save_inbox( $store_mail, $classes )
    {
        foreach( $classes as &$klass):
            $users_id = $this->fetch_students_by_class($klass , $store_mail->sessions)->pluck('id');
            $this->store_users_mail_inbox( $store_mail, $users_id);
        endforeach;
        unset( $klass );
    }

    function fetch_and_store_both_staff_and_students_mail_inbox($mail)
    {
        $this->fetch_and_store_all_students_mail_inbox( $mail );
        $this->fetch_and_store_all_staff_mail_inbox( $mail );
    }

    function extract_users_and_send_mails_to_inbox( $mail, $sent_to )
    {
        if($mail->status == 1) $this->extract_users_from_class_and_save_inbox( $mail, $sent_to );
        if($mail->status == 2) $this->fetch_and_store_all_students_mail_inbox( $mail );
        if($mail->status == 3) $this->fetch_and_store_all_staff_mail_inbox( $mail );
        if($mail->status == 4) $this->store_users_mail_inbox( $mail, $sent_to );
        if($mail->status == 5) $this->fetch_and_store_both_staff_and_students_mail_inbox( $mail );
    }

    function store_users_mail_inbox($mail, $users_id)
    {
        foreach( $users_id as &$user_id ):
            $this->save_mail_inbox($mail, trim($user_id));
        endforeach;
        unset( $user_id );
        return true;
    }

    function save_mail_inbox( $mail, $user_id )
    {
        $inbox = new school_mail_inbox;
        $inbox->school_id = $mail->school_id;
        $inbox->user_id = $user_id;
        $inbox->school_mail_id = $mail->id;
        $inbox->save();
    }

    function fetch_mail()
    {
        $records = []; 
        $user = auth()->user();
        ( $user->admin ) ? $records = $this->fetch_admin_mails() : $records = $this->fetch_user_mails();
        return $records;
    }
    
    function fetch_admin_mails()
    {
       return $this->my_school( new school_mail)->with('user', 'school_mail_inbox')->latest()->paginate(20);
    }

    function fetch_user_mails()
    {
        return $this->fetch_my_mails()->paginate(20);
    }

    function delete_mail()
    {
        $id = request()->id;
        $mail_ = $this->my_school( new school_mail)->whereId( $id )->first();
        $this->my_school(new school_mail_inbox)->whereSchool_mail_id( $id )->delete();
        $this->activity_log("Deleted a ".$mail_->type ." Mail with Title: ".$mail_->title );
        return ( ! $mail_->delete() ) ? $this->error_msg() : $this->success_msg();
    }

    function view_mail()
    {
        $mail_code = request()->mid;
        $mail = $this->my_school(new school_mail)->with('user')->whereCode($mail_code)->first();
        $this->update_user_has_read_mail(auth()->id(), $mail->id);
        return $mail;
    }

    function update_user_has_read_mail( $user_id, $mail_id )
    {
        $this->my_school(new school_mail_inbox)->whereSchool_mail_id( $mail_id )->whereUser_id($user_id)->update(['is_read' => 1]);
    }

}


