<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Traits\my_school_data;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;

class LoginController extends Controller
{
    use my_school_data;

    public function __construct()
    {
        $this->middleware('guest');
    }

    public function index()
    {
        return view('login');
    }

    public function password_reset_page()
    {
        return view('password_reset');
    }

    public function login_user(Request $request)
    {
        $intending_url = '';//request()->intending_url;
            $this->validate($request, ['id' => 'required', 'password' => 'required' ]);
            ($request->has('remember_me') ) ? $remember = true : $remember = false ;
            $confirm_user = Auth::attempt(request(['id', 'password']), true ); //$remember);
            if (!$confirm_user): return redirect()->back()->withInput()->withErrors(' Invalid Login details...'); endif;
            if( auth()->user()->deleted ){
                Auth::logout();
                return redirect()->back()->withErrors(' Invalid Login details...');
            }
            $this->activity_log(" Logged in to the Portal", 1);
            if( $intending_url != '' ):
                return redirect( $intending_url );
            else:
                return redirect()->route('dashboard');
            endif;      
    }
    
    function getDomainName( $url )
    {
        if( filter_var( $url, FILTER_VALIDATE_URL ) === false )
        {
           return false;
        }
        $urlChenks = parse_url($url);
        return $urlChenks['scheme'].'://'.$urlChenks['host'];
    }

    function reset_password()
    {
        $user_id = request()->user_id;
        //Check if this User has an Email Address
        $user = User::whereId( $user_id )->whereDeleted(0)->first();
        if(! $user ) return back()->withErrors(" Invalid User ID... ");
        if( $user->email == '' || $user->email == null ) return back()->withErrors(" You have No Email Address attached to your User ID, Please Contact Your School Admin/ICT Officer... ");
        $user_email = $user->email;
        $user_name = $user->last_name. " ".$user->first_name." ".$user->other_name;
        $mail_subject = " School Portal Password Reset";
        $new_password = $this->update_user_password( $user );
        $data = ["name" => $user_name, "email"=> $user_email, "user_id" => $user_id, "new_password" => $new_password ];
        Mail::send("emails.reset_password", $data, function($message) use ( $user_email, $user_name, $mail_subject ){
              $message->to($user_email, $user_name)
                      ->subject($mail_subject)
                      ->from("security@app.schoolportal360.com.ng", "SP360");
        });
        //if( ! $send ) return back()->withErrors(" Failed ! ");
        return back()->withSuccess(" We have sent your Password Reset Mail to ". $user->email );
    }

    function update_user_password($user)
    {
        $password = strtoupper( $this->random_strings(10) );
        $user->update(['password' => bcrypt( $password )]);
        return $password;
    }

}




