<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Traits\my_school_data;
use App\models\activity_log;
use App\models\all_grade;
use App\models\all_session;
use App\models\all_term;
use App\models\arm;
use App\models\grade;
use App\models\house;
use App\models\result_setting;
use App\models\resumption_date;
use App\models\sch_class;
use App\models\subject;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{
    use my_school_data;

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        return view('welcome');
    }

    public function logout()
    {
        $this->activity_log("Logged out from the Portal");
        Auth::logout();
        return redirect()->route('login')->withSuccess(' You have Logged out successfully... ');
    }

    function fetch_my_activity_logs()
    {
        $user = auth()->user();
        $all_activities = [];
        $all_activities_last_page = 1;
        $my_activities_ = $this->selected_user(new activity_log, auth()->id() )->latest('updated_at')->paginate(25);
        $my_activities_last_page = $my_activities_->lastpage();
        $my_activities = $my_activities_->groupBy('updated_at');
        if( $user->admin && $user->last_name == "Umeohia" && $user->first_name == "Chidiebere" ):
            $all_activities_ = $this->my_school(new activity_log)->latest('updated_at')->with('user')->paginate(25);
            $all_activities = $all_activities_->groupBy('updated_at');
            $all_activities_last_page = $all_activities_->lastpage();
        endif;
        $data = ['mine' => $my_activities, 'all' => $all_activities , 
                 'my_activities_last_page' => $my_activities_last_page,
                 'all_activities_last_page' => $all_activities_last_page
                ];
        return response()->json( $data );
    }

    public function fetch_user_profile()
    {
         $user = auth()->user();
         (request()->has('user_id')) ? $user = $this->user(new User, request()->user_id ) : $user;
        // $user = $user->only('')
         return ( request()->has('school_info') ) ? response()->json($user->school) : response()->json($user) ;
    }

    function user_selected_columns()
    {
        return [
            'last_name',
            'first_name',
            'other_name',
        ];
    }

    function fetch_all_class_subject_arm_sessions_data()
    {
        $current_session = $this->current_session();
        $all_classes = $this->my_school(new sch_class)->latest()->get();
        $all_arms = $this->my_school(new arm)->latest()->get();
        $all_subjects = $this->my_school(new subject)->orderBy('name')->with('subject_group')->latest()->get();
        $all_sessions = all_session::all();
        $all_terms = all_term::all();
        $all_houses = $this->my_school(new house )->latest()->get();
        $all_grades = all_grade::orderBy('name')->get();
        $result_gradings = $this->my_school(new grade)->latest()->get();
        $admin_result_comments = $this->admin_result_comments()->latest()->get();
        $teacher_result_comments = $this->teacher_result_comments()->latest()->get();
        $resumption_dates = $this->my_school(new resumption_date)->latest()->get();
        $admin_signature  = $this->admin_signature();
        $subject_groups   = $this->get_subject_groups();
        $termly_result_settings = ($value = $this->get_academic_result_settings() ) ? $value : [];
    
        $data = [
                 'all_classes' => $all_classes, 'all_subjects' => $all_subjects, 
                 'all_sessions' => $all_sessions,'all_grades' => $all_grades,
                 'all_arms' => $all_arms, 'all_houses' => $all_houses, 
                 'all_terms' => $all_terms , 'current_session' => $current_session,
                 'result_gradings' => $result_gradings, 'admin_result_comments' => $admin_result_comments,
                 'teacher_result_comments'=> $teacher_result_comments, 'resumption_dates' => $resumption_dates,
                 'admin_signature'=> $admin_signature, 'subject_groups' => $subject_groups,
                 'termly_result_settings' => $termly_result_settings
                ];
        return response()->json($data); 
    }

}
