<?php

namespace App\Http\Controllers\Exams;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\my_school_data;
use App\models\Exams\exam;
use App\models\Exams\exam_question;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class Exam_setupController extends Controller
{
    use my_school_data;

    function store_new_cbt_exam()
    {
        $user = auth()->user();
        $current = $this->current_session();
        if(! $current ) return $this->error_msg(' No Active Academic Session was detected... ');
        if( $this->exam_exists_already( $current ) ) return $this->error_msg(" This Exam has been Created Already...");
        $store = new exam();
        $store->user_id = $user->id;
        $store->sessions = $current->sessions;
        $store->term = $current->term;
        $store->school_id = $user->school_id;
        $store->staff_name = $user->last_name.' '.$user->first_name.' '.$user->other_name;
        $store->classes = request()->classes;
        $store->arms = request()->arms;
        $store->subject = request()->subject;
        $store->type = request()->type;
        $store->daate = request()->daate;
        $store->duration = request()->duration;
        $store->instructions = request()->instructions;
        $store->category = request()->category;
        $store->code = time().'_'.$user->id.'_'.uniqid();
        $store->save();
        if( ! $store ) return $this->error_msg();
        $this->activity_log("Created a New ".request()->type ." Exam for ".request()->classes.' '.request()->arms.' with Subject Title as '. request()->subject );
        return $this->success_msg();
        
    }

    function exam_exists_already($current)
    {
        $find = $this->my_school(new exam)->whereDeleted(0)
                                          ->whereTerm( $current->term )
                                          ->whereSessions( $current->sessions )
                                          ->whereClasses( request()->classes )
                                          ->whereArms( request()->arms )
                                          ->whereSubject( request()->subject )
                                          ->whereType( request()->type )
                                          ->whereCategory( request()->category );
        if( $find->exists() ) return true;
        return false;
    }

    function fetch_created_exams()
    {
        return $this->my_school(new exam)->whereDeleted(0);
    }

    function fetch_my_created_exams()
    {
        $data = $this->fetch_created_exams()->whereUser_id( auth()->id() )
                                            ->latest('updated_at')
                                            ->get();
        return datatables()->of( $data )
                           ->editColumn('published', function($data){
                               if( $data->published ) return "<i class='fa fa-check-circle text-success'></i>";
                               return "<i class='fa fa-ban text-danger'></i>";
                           })
                            ->addColumn('total_questions', function($data){
                              return "<span class='__total_exam_questions-".$data->id."'>".$data->exam_question->count()."</span>";
                            })
                            ->editColumn('classes', function($data){
                               return $data->classes.' '.$data->arms;
                           })
                           ->editColumn('duration', function($data){
                               return $data->duration.' Minutes';
                           })
                           ->addColumn('total_students', function($data){
                               return $data->exam_student->count();
                           })
                           ->addColumn('checkbox', function($data){
                               return "<input type='checkbox' class='checkSingle' name='id[]' value='$data->id'>";
                           })
                           ->addColumn('action', function($data){ 
                               return "<button type='button' class='edit_exam_btn btn btn-sm btn-info' id='$data->code'><i class='fa fa-edit'></i> Edit Exam </button> ".
                                      "<button id='$data->code' type='button' class='view_exam_questions btn btn-sm btn-success'>
                                              <i class='far fa-file-alt'></i> View Questions 
                                      </button>".' '. 
                                      "<button id='$data->type-$data->id' type='button' class='view_student_answers btn btn-warning btn-sm'><i class='fa fa-tv'></i>  View Students Answer </button>";
                           })
                           ->rawColumns(['published', 'checkbox', 'action', 'total_questions'])
                           ->make( true );
    }

    function fetch_all_created_exams()
    {
        $data = $this->fetch_created_exams()->latest('updated_at')->get(); 
        return datatables()->of( $data )
                           ->editColumn('published', function($data){
                               if( $data->published ) return "<i class='fa fa-check-circle text-success'></i>";
                               return "<i class='fa fa-ban text-danger'></i>";
                           })
                           ->addColumn('total_questions', function($data){
                              return "<span class='_total_exam_questions-".$data->id."'>".$data->exam_question->count()."</span>";
                            })
                            ->editColumn('classes', function($data){
                               return $data->classes.' '.$data->arms;
                           })
                           ->addColumn('total_students', function($data){
                               return $data->exam_student->count();
                           })
                           ->editColumn('duration', function($data){
                               return $data->duration.' Minutes';
                           })
                           ->addColumn('checkbox', function($data){
                               return "<input type='checkbox' class='checkSingle2' name='id[]' value='$data->id'>";
                           })
                           ->addColumn('action', function($data){
                               return "<button type='button' class='edit_exam_btn btn btn-sm btn-info' id='$data->code'><i class='fa fa-edit'></i> Edit Exam </button> ".
                                       "<button id='$data->code' type='button' class='view_exam_questions btn btn-sm btn-primary'>
                                              <i class='far fa-file-alt'></i> View Questions 
                                      </button>".' '. 
                                      "<button id='$data->type-$data->id' type='button' class='view_student_answers btn btn-warning btn-sm'><i class='fa fa-tv'></i>  View Students Answer </button>";
                           })
                           ->rawColumns(['published', 'checkbox', 'action', 'total_questions'])
                           ->make( true );
    }

    function delete_cbt_exams()
    {
        $data = request()->id;
        foreach($data as &$id):
           $this->my_school(new exam)->whereId($id)->firstOrFail()->update(['deleted' => 1]);
        endforeach;
        unset($id);
        $msg = ( count($data) == 1) ? "Deleted an Exam " : "Deleted ".count($data)." Exams " ;
        $this->activity_log($msg);
        return $this->success_msg();
    }

    function publish_cbt_exam()
    {
        $data = request()->id;
        foreach( $data as &$id ):
            $this->my_school(new exam)->whereId($id)->firstOrFail()->update(['published' => 1]); 
        endforeach;
        unset($id);
        $msg = ( count($data) == 1) ? "Published an Exam " : "Published ".count($data)." Exams " ;
        $this->activity_log($msg);
        return $this->success_msg();
    }

    function undo_publish_cbt_exam()
    {
        $data = request()->id;
        foreach( $data as &$id):
            $this->my_school(new exam)->whereId($id)->firstOrFail()->update(['published' => 0]); 
        endforeach;
        unset($id);
        $msg = ( count($data) == 1) ? "Undo-Published an Exam " : "Undo-Published ".count($data)." Exams " ;
        $this->activity_log($msg);
        return $this->success_msg();
    }
    
    function fetch_this_exam_questions()
    {
        $exam_code = request()->exam_id; //exam_id = exam code
        return $this->my_school(new exam)->whereCode( $exam_code )->whereDeleted(0)->with(['exam_question'])->first();
    }

    function fetch_single_question()
    {
        $question_id = request()->qid;
        return $this->my_school(new exam_question)->whereId( $question_id )->whereDeleted(0)->first();
    }

    function store_exam_question()
    {
        if(request()->exam_type == 'objective'){
            if( ! request()->correct_answer) return $this->error_msg(" Please, Ensure you have Selected the Correct Answer option before proceeding... ");
        }
        if( ! request()->content ) return $this->error_msg(" Please, Ensure you have entered a Question before proceeding... ");
        $user = auth()->user();
        $store = new exam_question();
        $store->school_id = $user->school_id;
        $store->created_by = $user->last_name.' '.$user->first_name.' '.$user->other_name.' - '.$user->id;
        $store->exam_id = request()->exam_id;
        $store->content = request()->content;
        $store->option1 = request()->option1;
        $store->option2 = request()->option2;
        $store->option3 = request()->option3;
        $store->option4 = request()->option4;
        $store->correct_answer = request()->correct_answer;
        $store->answer_explanation = request()->answer_explanation;
        $store->save();
        if( ! $store ) return $this->error_msg();
        return $this->success_msg();
    }

    function delete_exam_question()
    {
        $question_id = request()->question_id;
        $deleted = $this->user(new exam_question , $question_id )->update(['deleted' => 1]);
        $this->activity_log("Deleted an Exam Question");
        return (! $deleted) ? $this->error_msg() : $this->success_msg();
    }

    function update_exam_question()
    {
        $data = request()->all();
        $user = auth()->user();
        $data['created_by'] = $user->last_name.' '.$user->first_name.' '.$user->other_name;
        $update = $this->user(new exam_question, request()->id )->update( $data );
        if(!$update) return $this->error_msg();
        $this->activity_log("Updated an Exam Question");
        return $this->success_msg();
    }

    function update_cbt_exam()
    {
        $user = auth()->user();
        $data = request()->all();
        $data['staff_name'] = $user->last_name.' '.$user->first_name.' '.$user->other_name;
        $update = $this->user(new exam, request()->id )->update( $data );
        $this->activity_log("Updated an Exam for ". request()->classes.' '.request()->arms.' with Subject as '. request()->subject );
        return (! $update) ? $this->error_msg() : $this->success_msg();
    }
}

