<?php

namespace App\Http\Controllers\Exams;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\my_school_data;
use App\models\Exams\exam;
use App\models\Exams\exam_answer;
use App\models\Exams\exam_question;
use App\models\Exams\exam_student;
use Carbon\Carbon;
use Dotenv\Regex\Success;
use Illuminate\Http\Request;

class ExamController extends Controller 
{
    use my_school_data;

    function fetch_student_available_exams()
    {
        $current = $this->current_session();
        if( ! $current ) return $this->error_msg(" Active Academic Session Not Detected... ");
        return $this->my_school(new exam)->whereTerm( $current->term )
                                         ->whereSessions( $current->sessions )
                                         ->whereClasses( request()->classes )
                                         ->whereDeleted(0)
                                         ->latest()
                                         ->get();                                
    }

    function get_student_exam_detail()
    {
        $find = $this->my_school(new exam_student)->whereUser_id( request()->student_id )
                                                  ->whereExam_id( request()->exam_id )
                                                  ->first();
        $timer = $find->exam_timer( $find->start_time , $find->expected_end_time );
        /***
         * $timer[0] = in secs
         * $timer[1] = Exam start time (Mins:secs)===format
         * $timer[2] = Exam End time (Mins:secs)===format
         */
        $data = [ $find, $timer[0], $timer[1], $timer[2] ];
        return response()->json($data);
    }

    function store_student()
    {
        $user = auth()->user();
        $exam_duration = request()->duration + 1;
        $exam_id = request()->exam_id;
        
        $store = new exam_student();
        $store->user_id = $user->id;
        $store->exam_id = $exam_id;
        $store->school_id = $user->school_id;
        $store->start_time = Carbon::now();
        $store->student_name = $user->last_name." ".$user->first_name." ".$user->other_name;
        $store->expected_end_time = Carbon::now()->addMinutes( $exam_duration );
        $store->student_class = $user->target_class;
        $store->student_arm = $user->target_arm;
        //=== Check if this Student exists already ====//
        $exam = $this->my_school( new exam_student )->whereUser_id( $user->id)->whereExam_id( $exam_id );
        if(! $exam->exists() ){
            $store->save();
            if(! $store ) return $this->error_msg(" Something went wrong, please Reload this Page... ");
            $this->activity_log("Started an Exam with an ID of ". $store->exam_id );
            return $this->success_msg(' You have successfully started this Examination, All the Best in Your Exam... ');
        }
        $this->activity_log("Went back to Continue an Exam with an ID of ". $store->exam_id );
        return $this->success_msg(' Welcome Back... ');
    }

    function store_student_exam_answer()
    {
        $user = auth()->user();
        $is_correct = 0;
        $exam_id = request()->exam_id;
        /***
         * Get Exam student ID of this Student ==///
         */
        $exam_student = $this->my_school(new exam_student)->whereUser_id($user->id)
                                                          ->whereSchool_id($user->school_id)
                                                          ->whereExam_id($exam_id)
                                                          ->first();
        $question_id = request()->question_id;
        $selected_answer = request()->selected_answer;
        $question = $this->user( new exam_question , $question_id );
        $correct_answer = $question->correct_answer ;
        if($correct_answer == $selected_answer ) $is_correct = 1;
        //== Check if this student has Answered this Question before and update it, hence, create it....///
        $check = $this->selected_user(new exam_answer, $user->id )->whereExam_id( $exam_id )->whereExam_question_id( $question_id);
        if($check->exists() ):
            return $this->update_exam_question_answer( $check, $is_correct, $selected_answer, $correct_answer);
        else:
            $store = new exam_answer();
            $store->is_correct = $is_correct;
            $store->correct_answer = $correct_answer;
            $store->selected_answer = $selected_answer;
            $store->exam_question_id = $question_id;
            $store->exam_id = $exam_id;
            $store->school_id = $user->school_id;
            $store->user_id = $user->id;
            $store->exam_student_id = $exam_student->id;
            $store->student_name = $user->last_name." ".$user->first_name." ".$user->other_name;
            $store->save();
            if( ! $store ) return $this->error_msg();
        endif;
        return $this->success_msg(" Answer submitted Succesfully... ");
    }

    function update_exam_question_answer( $model, $is_correct, $selected_answer, $correct_answer )
    {
        $update = $model->update([
            'is_correct' => $is_correct,
            'selected_answer' => $selected_answer,
            'correct_answer' => $correct_answer
        ]);
        if(! $update) return $this->error_msg();
        return $this->success_msg('Answer was updated succesfully... ');
    }

    function get_number_of_total_questions_answered()
    {
        $exam_id = request()->exam_id;
        return $this->selected_user(new exam_answer, auth()->id() )->whereExam_id( $exam_id )->get();
    }

    function get_all_students_who_took_this_exam()
    {
        $exam_id =  request()->exam_id;
        return $this->my_school(new exam_student)->whereExam_id( $exam_id )
                                                 ->with("exam_answer")
                                                 ->with('exam')
                                                 ->latest('updated_at')
                                                 ->orderBy("student_arm")
                                                 ->get();               
    }

    function fetch_student_exam_answers()
    {
        return $this->my_school(new exam_answer )->whereExam_id( request()->exam_id )
                                                 ->whereUser_id( request()->user_id )
                                                 ->with('exam_question')
                                                 ->get();
    }

    function remove_student_from_this_exam()
    {
        $student_id = request()->user_id;
        $exam_id = request()->exam_id;
        $student_exam_id = request()->id;
        $find = $this->my_school(new exam_student)->whereUser_id( $student_id )
                                                  ->whereExam_id( $exam_id )
                                                  ->whereId( $student_exam_id )
                                                  ->first();
        if( ! $find ) return $this->error_msg();
        $student_answers = $this->selected_user(new exam_answer, $student_id)
                                       ->whereExam_id( $exam_id )
                                       ->whereExam_student_id( $student_exam_id );
        $delete_student = $find->delete( request()->id );
        $student_answers->delete();
        $this->activity_log("Deleted a Student with an ID of ($student_id) from an Exam with an ID of $exam_id");
        return (! $delete_student ) ? $this->error_msg() : $this->success_msg();
    }

    function delete_student_answer()
    {
        $user = auth()->user();
        if($user->admin || $user->super_admin ):
        $id = request()->id;
        $delete = $this->user(new exam_answer, $id)->delete( $id );
        return ( ! $delete ) ? $this->error_msg() : $this->success_msg();
        else:
            return $this->error_msg( " Not Authorized... ");
        endif;
    }

}

