<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Controllers\Traits\my_school_data;
use App\User;

class StudentsMgtController extends Controller
{
    use my_school_data;

    function fetch_all_students(Request $request)
    {
        $students=$this->get_current_students();
        if($students):
            if( request()->has('klass')) $students = $students->whereTarget_class( $request->klass );
            if( request()->has('arm') && request()->arm != '') $students = $students->whereTarget_arm( $request->arm );
            $students->orderBy('updated_at', 'desc')->get();
        else:
            $students=[];
        endif;

        return datatables()->of($students)
                           ->addColumn('edit_profile', function ($students) {
                                return ($students->edit_profile) ? " <i class='fa fa-check text-success'></i>" : " <i class='fa fa-ban text-danger'></i>" ;
                            })
                            ->addColumn('checkbox', function ($students) {
                                return ' <input type="checkbox" class="check_btn form-control checkSingle" name="id[]" value=" '.$students->id.'">';
                            })
                            ->editColumn('active', function ($students) {
                                return ($students->active) ? "<i class=' fa fa-check text-success'></i>" :  "<i class='fa fa-ban text-danger'></i>" ;
                            })
                            ->editColumn('target_class', function ($students) {
                                return $students->target_class .' '. $students->target_arm ;
                            })
                           ->addColumn('full_names', function ($students) {
                               $name = strtolower($students->last_name .' '.$students->first_name .' '.$students->other_name);
                                return ucwords($name);
                            })
                            ->addColumn('view_profile', function($students) {
                               return "<button data-target='#student_profile_modal' data-target='modal' type='button' class='btn-sm btn btn-outline-success student_profile_click' id='$students->id'> View </button>";
                            })
                            ->editColumn('updated_at', function($students){
                                return '<span class="font-12">'. date('D, M d, Y - h:i a', strtotime($students->updated_at)) .'</span>';
                            })
                            ->rawColumns(['checkbox', 'active', 'edit_profile', 'view_profile', 'updated_at'])
                            ->make(true);
    }
    
}
