<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\my_school_data;
use App\models\form_teacher;
use App\models\Staff_class;
use App\models\student_attendance;
use App\User;
use Illuminate\Http\Request;

class StaffMgtController extends Controller
{
    use my_school_data;

    function fetch_all_staff(Request $request)
    {
        $staff = $this->get_current_staff();
        if( request()->has('filter_results')):
            if($request->q == 'admins_only') $staff = $this->get_current_staff()->whereAdmin(1);
            if($request->q == 'accountants_only') $staff = $this->get_current_staff()->whereAccountant(1);
        endif;
        $staff->orderBy('updated_at', 'desc')->get();

        return datatables()->of($staff)
                           ->addColumn('edit_profile', function ($staff) {
                                return ($staff->edit_profile) ? " <i class='fa fa-check text-success'></i>" : " <i class='fa fa-ban text-danger'></i>" ;
                            })
                            ->addColumn('checkbox', function ($staff) {
                                return ' <input type="checkbox" class="check_btn form-control checkSingle" name="id[]" value=" '.$staff->id.'">';
                            })
                            ->editColumn('active', function ($staff) {
                                return ($staff->active) ? "<i class=' fa fa-check text-success'></i>" : "<i class='fa fa-ban text-danger'></i>" ;
                            })
                            ->editColumn('admin', function ($staff) {
                                return ($staff->admin) ? "<i class=' fa fa-check text-success'></i>" : "<i class='fa fa-ban text-danger'></i>" ;
                            })
                            ->editColumn('accountant', function ($staff) {
                                return ($staff->accountant) ? "<i class=' fa fa-check text-success'></i>" : "<i class='fa fa-ban text-danger'></i>" ;
                            })
                            ->addColumn('full_names', function ($students) {
                                $name = strtolower($students->last_name .' '.$students->first_name .' '.$students->other_name);
                                 return ucwords($name);
                             })
                            ->addColumn('view_profile', function($staff) {
                                return "<button data-target='#student_profile_modal' data-target='modal' type='button' class='btn-sm btn btn-outline-primary student_profile_click' id='$staff->id'> View </button>";
                            })
                            ->editColumn('updated_at', function($staff){
                                return '<span class="font-12">'. date('D, M d, Y - h:i a', strtotime($staff->updated_at)) .'</span>';
                            })
                            ->rawColumns(['checkbox', 'active', 'edit_profile', 'view_profile', 'admin', 'accountant', 'updated_at'])
                            ->make(true);
    }

    function assign_class_and_subjects_to_staff(Request $request)
    {
        /**
         ** Check if this class and subject has been assigned to a staff already before storing it...
         */
        if( ! $this->validate_class_subject_term_and_session_data( $request->all() ) ) return $this->error_msg(' Please, Ensure all fields are properly selecetd...');
        $check = $this->my_school( new Staff_class )
                      ->whereSubjects($request->subjects)
                      ->whereClasses($request->classes)
                      ->whereTerm($request->term)
                      ->whereArms($request->arms)
                      ->whereSessions($request->sessions);
        if($check->exists()) return $this->error_msg('This Class and Subject has been assigned already for this Selected Term and Session');
        if( ! Staff_class::create( $request->all()) ) return $this->error_msg();
        $this->activity_log('Assigned '.request()->classes.' '.request()->arms.' Class and '.request()->subjects.' Subject to a Staff with an ID of '.request()->user_id );
        return $this->success_msg('Assigned Successfully...');
    }

    function view_all_class_and_subjects_assigned_to_this_staff(Request $request)
    {
        $view = $this->selected_user(new Staff_class, $request->user_id )->latest()->get() ;
        return datatables()->of( $view )
                            ->editColumn('classes', function($view){
                                return $view->classes.' '.$view->arms;
                            })
                            ->editColumn('assigned_by', function($view){
                                return "<span class='font-12'>" . $view->assigned_by. "</span>" ;
                            })
                            ->addColumn('checkbox', function ($view) {
                                return ' <input type="checkbox" class="check_btn form-control checkSingle" name="id[]" value=" '.$view->id.'">';
                            })
                            ->editColumn('created_at', function($view){
                                return '<span class="font-12">'. date('D, M d, Y - h:i a', strtotime($view->created_at)) .'</span>';
                            })
                            ->rawColumns(['checkbox', 'created_at', 'assigned_by'])
                            ->make(true);
    }

    function delete_staff_class_and_subjects(Request $request)
    {
        $data = $request->id;
        foreach($data as &$id):
              if(! $this->user(new Staff_class, $id)->delete() ): continue; endif;
        endforeach;
        unset($id);

        return $this->success_msg('Removed Successfully...'); 
    }

    function store_form_teachers()
    {
        //cHECK IF THIS CLASS HAS BEEN ASSIGNED TO A STAFF ALREADY //
        $check =  $this->my_school(new form_teacher)->whereClasses(request()->classes)
                                                    ->whereArms( request()->arms)->first();
        if($check) return $this->error_msg('This Class has been Assigned already... ') ; 
        $staff_id = explode('/', request()->user_id)[0];
        $staff_name = explode('/', request()->user_id)[1];
        $store = form_teacher::create([
            'school_id' => auth()->user()->school_id,
            'user_id'    => $staff_id,
            'name'       => $staff_name,
            'classes'     => request()->classes,
            'arms'        => request()->arms
        ]);
        $this->activity_log("Added ".$store->name. ' as a Form/Class Teacher of '. $store->classes.' '.$store->arms );
        return (! $store )? $this->error_msg() : $this->success_msg();
    }

    function delete_form_teachers()
    {
        $delete = $this->my_school(new form_teacher)->whereId( request()->id )->delete( request()->id );
        $this->activity_log( "Deleted a Form/Class Teacher ");
        return (! $delete )? $this->error_msg() : $this->success_msg();
    }

    function fetch_form_teachers()
    {
        $form_teachers = $this->my_school(new form_teacher)->latest()->get();
        $all_staff = $this->get_current_staff()->get();
        $data =['form_teachers' => $form_teachers, 'all_staff' =>  $all_staff];
        return response()->json( $data);
    }

    function fetch_all_attendance_records()
    {
        return $this->my_school(new student_attendance)->whereTerm( request()->term)
                                                       ->whereSessions( request()->sessions)
                                                       ->whereClasses( request()->classes)
                                                       ->whereArms( request()->arms )
                                                       ->get()
                                                       ->sortBy('name');
    }
}


