<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\my_school_data;
use App\models\assessment_format;
use App\models\class_annual_final_result;
use App\models\class_annual_subject_result;
use App\models\class_final_result;
use App\models\grade;
use App\models\result_comment;
use App\models\result_setting;
use App\models\resumption_date;
use App\models\sch_session;
use App\models\school_signature;
use App\models\subject_result;
use App\models\teachers_comment;
use App\User;
use Illuminate\Support\Facades\File;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ResultMgtController extends Controller
{
    use my_school_data;

    function available_class_results()
    {
        $current = $this->current_session();
        $available_results = $this->my_school( new subject_result )
                                  ->whereTerm( $current->term )
                                  ->whereSessions( $current->sessions )
                                  ->select('classes', 'arms')
                                  ->groupBy('classes', 'arms')
                                  ->get();
        return response()->json( $available_results );
    }
    
    function upload_signature(Request $request)
    {
        $signature = $this->admin_signature();
        if(! $this->validate_user_photo($request->all(), 'signature')) return $this->error_msg('Please, ensure you are uploading an Image file and it is not more than 2mb...');
        //==== Check if Signature image exists Already and update it, else.. create a new one..
        $img = $request->File('signature');
        $name = uniqid(). '_' . time() . '.jpg';
        $directory_path  = 'uploaded_files/signatures/'.auth()->user()->school_id ;
             if(! File::isDirectory($directory_path) ){
                   File::makeDirectory($directory_path, 0755, true, true);
               };
            $file_path = public_path().'/'.$directory_path.'/'.$name;
            //==== Reduce  Image size
            $this->resize_and_save_image($img, $file_path, false, 300, 250);
        
        if(! $signature ):      
            if(! school_signature::create(['signature'=> $name, 'school_id' => auth()->user()->school_id ])) { return $this->error_msg(); };
        else:
           File::delete('uploaded_files/signatures/'.auth()->user()->school_id.'/'. $signature);
           if( ! $this->my_school(new school_signature)->update(['signature' => $name]) ) return $this->error_msg(); 
        endif;
        $this->activity_log('Updated a Signature');
        return $this->success_msg();
    }

    function store_new_resumption_date(Request $request)
    {
        $this->activity_log('Created a New School Resumption Date');
        return (! resumption_date::updateOrCreate( $request->all() ) )? $this->error_msg() : $this->success_msg();
    }

    function delete_resumption_date(Request $request)
    {
        $this->activity_log('Deleted School Resumption Date');
        return (! resumption_date::destroy( $request->id ) ) ? $this->error_msg() : $this->success_msg();
    }

    function store_result_comment(Request $request)
    {
        return (! result_comment::updateOrCreate( $request->all() ) )? $this->error_msg() : $this->success_msg();
    }

    function delete_result_comment(Request $request)
    {
        return (! result_comment::destroy( $request->id )) ? $this->error_msg() : $this->success_msg();
    }

    function store_result_grading(Request $request)
    {
        $this->activity_log('Created a New Result Grading/Comment format');
        return (! grade::updateOrCreate( $request->all() ) )? $this->error_msg() : $this->success_msg();
    }

    function delete_result_grading(Request $request)
    {
        $this->activity_log('Deleted Result Grading/Comment format');
        return (! grade::destroy( $request->id )) ? $this->error_msg() : $this->success_msg();
    }
    
    function create_new_session(Request $request)
    {
        if(! $this->validate_term_and_session($request->all()) ) return $this->error_msg('Please, ensure all required fields are selected...');
        $this->activity_log('Created a New Term/Session - '.request()->term.' ('.request()->sessions.')' );
        return (! sch_session::updateOrCreate( $request->all() ) )? $this->error_msg() : $this->success_msg();
    }

    function activate_session(Request $request)
    {
        $data = $request->id;
        foreach($data as &$id):
              if(! $this->user(new sch_session, $id)->update(['active'=> 1]) ): continue; endif;
        endforeach;
        unset($id);
        $msg = ( count($data) == 1) ? "Activated a New Term/Session " : "Activated ".count($data)." Terms/Sessions" ;
        $this->activity_log($msg);
        return $this->success_msg('Session Activated Successfully...');
    }

    function de_activate_session(Request $request)
    {
        $data = $request->id;
        foreach($data as &$id):
              if(! $this->user(new sch_session, $id)->update(['active'=> 0]) ): continue; endif;
        endforeach;
        unset($id);
        $msg = ( count($data) == 1) ? "De-Activated a Term/Session " : "De-Activated ".count($data)." Terms/Sessions" ;
        $this->activity_log($msg);
        return $this->success_msg('Session De-activated Successfully...');
    }

    function publish_result(Request $request)
    {
        $data = $request->id;
        foreach($data as &$id):
              if(! $this->user(new sch_session, $id)->update(['result_published' => 1]) ): continue; endif;
        endforeach;
        unset($id);
        $msg = ( count($data) == 1) ? "Published a Termly Result " : "Published ".count($data)." Termly Results " ;
        $this->activity_log( $msg );
        return $this->success_msg('Result Published Successfully...');
    }

    function undo_publish_result(Request $request)  
    {
        $data = $request->id;
        foreach($data as &$id):
              if(! $this->user(new sch_session, $id)->update(['result_published'=> 0]) ): continue; endif;
        endforeach;
        unset($id);
        $msg = ( count($data) == 1) ? "Undo-Published Termly Result " : "Undo-Published ".count($data)." Termly Results " ;
        $this->activity_log( $msg );
        return $this->success_msg('Undo-Published result was Successful...');
    } 

    function delete_term_and_sessions(Request $request)
    {
        $data = $request->id;
        $msg = ( count($data) == 1 ) ? "Deleted a Term/Session " : "Deleted ".count($data)." Terms/Sessions " ;
        $this->activity_log( $msg );
        return (! sch_session::destroy($data) ) ? $this->error_msg() : $this->success_msg() ;
    }
    
    function fetch_sch_sessions()
    {
        $results = $this->my_school(new sch_session)->latest('updated_at')->get();
        return datatables()->of($results)
                           ->addColumn('checkbox', function($results){
                               return "<input type='checkbox' name='id[]' value='$results->id' class='form-control check_btn checkSingle' >" ;
                           })
                           ->editColumn('updated_at', function($results){
                                return '<span class="font-12">' .date('D, M d, Y - h:i a', strtotime($results->updated_at) ) .'</span>';
                           })
                           ->editColumn('active', function($results){
                                return ($results->active) ? "<i class='text-success fa fa-check'></i>" : "<i class='fa fa-ban text-danger'></i>";
                           })
                           ->editColumn('result_published', function($results){
                            return ($results->result_published) ? "<i class='text-success fa fa-check'></i>" : "<i class='fa fa-ban text-danger'></i>";
                            })
                           ->rawColumns(['active', 'updated_at', 'result_published', 'checkbox'])
                           ->make(true);
    }

    function subject_results()
    {  
        return $this->student_subject_results();
    }

    function check_subject_results()
    {
        $results = $this->subject_results()->latest('updated_at')->get();
        return datatables()->of($results)
                           ->editColumn('updated_at', function($results){
                                return '<span class="word_no_wrap font-12">' .date('D, M d, Y - h:i a', strtotime($results->updated_at) ) .'</span>';
                           })
                           ->editColumn('position', function($results){
                                return "<span class='ordinal' id='$results->position'>".$results->position . "</span>";
                           })
                           ->editColumn('classes', function($results){
                            return "<span class='word_no_wrap font-12'>". $results->classes.' '. $results->arms . "</span>";
                            })
                            ->editColumn('teachers_comment', function($results){
                                return "<span class='word_no_wrap font-12'>". $results->teachers_comment . "</span>";
                            })
                            ->editColumn('teachers_name', function($results){
                                $teacher = strtolower( $results->teachers_name );
                                return "<span class='font-12 text-capitalize word_no_wrap'>". ucwords($teacher ). "</span>";
                            })
                           ->AddIndexColumn()
                           ->rawColumns(['position', 'updated_at', 'classes', 'teachers_comment', 'teachers_name'])
                           ->make(true);
    }

    function check_lowest_highest_scores_for_subject_results()
    {
        $lowest_student = ''; $highest_student = ''; $class_average = ''; $total_students = '';
        if( $this->subject_results()->count() )
        {  
            $total_students = $this->subject_results()->count();
            $h_score =  $this->subject_results()->max('total_score');
            $l_score =  $this->subject_results()->min('total_score');
            $lowest_student =  $this->subject_results()->whereTotal_score($l_score)->latest()->first();
            $highest_student = $this->subject_results()->whereTotal_score($h_score)->latest()->first();
            $class_average = $highest_student->class_average;
        }
        $data = ['class_average' => $class_average, 'lowest_student'=> $lowest_student, 
                 'highest_student' => $highest_student, 'total_students' => $total_students 
                ];
        return response()->json($data);
    }

    function get_members_of_this_class_for_annual_result_computing()
    {
        return $this->my_school(new class_final_result)
                    ->whereSessions( request()->sessions )
                    ->whereClasses( request()->classes )
                    ->whereArms( request()->arms );
    }

    function if_exists_student_annual_subject_result($student_id, $subject)
    {
        return $this->student_annual_all_subjects_result($student_id)->whereSubject($subject);
    }

    function student_annual_all_subjects_result($student_id)
    {
        return $this->my_school(new class_annual_subject_result)->whereSessions( request()->sessions )
                                                                ->whereStudent_id($student_id)
                                                                ->whereClasses(request()->classes )
                                                                ->whereArms( request()->arms );
    }

    function get_all_subjects_result_taken_by_this_student($student_id)
    {
        return $this->my_school(new subject_result)->whereStudent_id( $student_id )->whereSessions( request()->sessions );
    }

    function fetch_annual_student_subject_score_for_this_term($student_id, $subject, $term)
    {
        return $this->get_all_subjects_result_taken_by_this_student($student_id)
                    ->whereTerm( $term )
                    ->whereSubjects( $subject )
                    ->first();
    }

    function compile_annual_subject_result($student_id)
    {
         /**
             * Firstly, Refresh (Delete) the entire subject result scores for this request, just incase a staff has deleted a
             * previous subject so as to enable it store a current existing subject ==== 
            */
        $this->student_annual_all_subjects_result($student_id)->delete();
        $grade = ''; 
        $grade_comment = '';
        $grades = $this->my_school(new grade)->get();
        $subjects = $this->get_all_subjects_result_taken_by_this_student($student_id)
                         ->select('subjects')
                         ->groupBy('subjects')
                         ->get()
                         ->pluck('subjects');

        foreach( $subjects as &$user_subject):
            $first_term = $this->fetch_annual_student_subject_score_for_this_term($student_id, $user_subject, 'first term');
            $second_term = $this->fetch_annual_student_subject_score_for_this_term($student_id, $user_subject, 'second term');
            $third_term = $this->fetch_annual_student_subject_score_for_this_term($student_id, $user_subject, 'third term');

            ( $first_term )  ?  $first_term_subject_score  = $first_term->total_score  : $first_term_subject_score  = null;
            ( $second_term ) ?  $second_term_subject_score = $second_term->total_score : $second_term_subject_score = null;
            ( $third_term )  ?  $third_term_subject_score  = $third_term->total_score  : $third_term_subject_score  = null;
            $total_subject_score = $first_term_subject_score + $second_term_subject_score + $third_term_subject_score ;
            $average_score = $total_subject_score / 3;

            /***
             * Set Grades and remarks
             */
            foreach($grades as &$g):
               if($average_score >= $g->min_score && $average_score <= $g->max_score):
                  $grade = $g->grade;
                  $grade_comment = $g->comment;
                else:
                   continue;
                endif;
            endforeach; 
            unset($g);

            $annual_subject_result = $this->if_exists_student_annual_subject_result( $student_id, $user_subject );
        if( $annual_subject_result->exists() ):
            $annual_subject_result->update([
                'first_term_score' => $first_term_subject_score,
                'second_term_score' => $second_term_subject_score,
                'third_term_score' => $third_term_subject_score,
                'total_score' => $total_subject_score,
                'average_score' => $average_score,
                'grade' => $grade,
                'comment' => $grade_comment,
            ]);
        else:
            $store = new class_annual_subject_result;
            $store->student_id = $student_id;
            $store->school_id  = auth()->user()->school_id;
            $store->sessions   = request()->sessions; 
            $store->subject    = $user_subject;
            $store->first_term_score = $first_term_subject_score;
            $store->second_term_score = $second_term_subject_score;
            $store->third_term_score = $third_term_subject_score;
            $store->total_score = $total_subject_score;
            $store->average_score = $average_score;
            $store->grade = $grade;
            $store->comment = $grade_comment;
            $store->classes = request()->classes;
            $store->arms = request()->arms;
            $store->save();
        endif;

        endforeach;
    }

    function update_class_annual_subject_position($students)
    {
            /**
             * Set Positions
             */
            foreach($students as $student_id):
                $subjects = $this->get_all_subjects_result_taken_by_this_student($student_id)
                                 ->select('subjects')
                                 ->groupBy('subjects')
                                 ->get()
                                 ->pluck('subjects');

            foreach( $subjects as $subject ):
            $fetch_students_average_score = $this->my_school(new class_annual_subject_result)
                                                 ->whereSessions( request()->sessions )
                                                 ->whereClasses(request()->classes )
                                                 ->whereSubject($subject)
                                                 ->whereArms( request()->arms )
                                                 ->get()
                                                 ->sortByDesc('average_score')
                                                 ->pluck('average_score')
                                                 ->toArray('average_score');

                $subj = $this->if_exists_student_annual_subject_result($student_id , $subject)->first();
                $average_score = $subj->average_score;
                $position = array_search( $average_score, $fetch_students_average_score ) + 1;
                $position = $this->ordinal( $position );
                $subj->update(['position' => $position]);
            endforeach;  

            endforeach; 
            unset($student_id);
    }

    function annual_subject_score_summation( $student_id, $value = '' )
    {
        $find = $this->my_school( new class_annual_subject_result )->whereSessions( request()->sessions )
                                                                   ->whereClasses( request()->classes )
                                                                   ->whereArms( request()->arms )
                                                                   ->whereStudent_id( $student_id );
        $sums = $find->pluck($value)->sum();
        $total_subject = $find->select('subject')->groupBy('subject')->pluck('subject')->count();
        return [$sums , $total_subject] ;
    }

    function update_class_final_annual_results( $students )
    {
        foreach($students as &$student_id):
            $find = $this->my_school( new class_annual_final_result )->whereStudent_id($student_id)
                                                                   ->whereClasses( request()->classes)
                                                                   ->whereArms( request()->arms )
                                                                   ->whereSessions( request()->sessions)
                                                                   ->first();

            $first_term_subject_score_summation  = $this->annual_subject_score_summation($student_id, 'first_term_score')[0];
            $second_term_subject_score_summation = $this->annual_subject_score_summation($student_id, 'second_term_score')[0];
            $third_term_subject_score_summation  = $this->annual_subject_score_summation($student_id, 'third_term_score')[0];
            $total_subject = $this->annual_subject_score_summation($student_id, 'first_term_score')[1];
            $total_subject_score = $first_term_subject_score_summation + $second_term_subject_score_summation + $third_term_subject_score_summation ;
            ($total_subject_score) ? $average_score = $total_subject_score / ( $total_subject * 3) : $average_score = 0;

            if($find):
                $find->update([
                    'first_term_subject_total' => $first_term_subject_score_summation,
                    'second_term_subject_total' => $second_term_subject_score_summation,
                    'third_term_subject_total' => $third_term_subject_score_summation,
                    'total_subject_score' => $total_subject_score,
                    'total_subject' => $total_subject,
                    'average_score' => $average_score,
                    'total_students' => count($students)
                ]);

            else:
                $store = new class_annual_final_result;
                $store->school_id = auth()->user()->school_id;
                $store->student_id = $student_id;
                $store->sessions = request()->sessions;
                $store->classes = request()->classes;
                $store->arms = request()->arms;
                $store->first_term_subject_total  =  $first_term_subject_score_summation;
                $store->second_term_subject_total =  $second_term_subject_score_summation;
                $store->third_term_subject_total  =  $third_term_subject_score_summation;
                $store->total_subject_score = $total_subject_score;
                $store->total_subject = $total_subject;
                $store->average_score = $average_score;
                $store->total_students = count($students);
                $store->save();
            endif;

        endforeach;
    }

    function fetch_class_annual_results()
    {
        /***
         * 1. Ensure first, second and term result for this class exists already before proceeding 
         *    to check for the annual cummulative
         * 2. Loop through the selected session and class and get all students with there corresponding termly scores.
         */
        $students_id = [];
        ( $_id = $this->request_result_has_student_id() ) ? $students_id = $_id : $students_id = [] ;
        $first_term = "first term";  
        $second_term = "second term"; 
        $third_term = "third term";
        $students = $this->get_members_of_this_class_for_annual_result_computing()->select('student_id')
                                                                                  ->groupBy('student_id')
                                                                                  ->get();
                                                                                  
        if(! $students->count() ) return "<p style='font-family:tahoma; color:red'> Annual Result is not available... </p>";
        $students = $students->pluck('student_id')->toArray();

        $term_group = $this->get_members_of_this_class_for_annual_result_computing()->select('term')
                                                                                    ->groupBy('term')
                                                                                    ->get()
                                                                                    ->pluck('term')
                                                                                    ->toArray();

        //if(! in_array($first_term,  $term_group) )  return  "<p style='font-family:tahoma; color:red'> First Term Result is not Available... </p>";
        //if(! in_array($second_term, $term_group) )  return  "<p style='font-family:tahoma; color:red'> Second Term Result is not Available... </p>";
        //if(! in_array($third_term,  $term_group) )  return  "<p style='font-family:tahoma; color:red'> Third Term Result is not Available... </p>";        

        foreach($students as &$student_id):
            $this->compile_annual_subject_result( $student_id );
        endforeach;
        unset($student_id);

        $this->update_class_annual_subject_position( $students );
        $this->update_class_final_annual_results( $students );

        $fetch_annual_results = $this->my_school(new class_annual_final_result)
                                     ->whereClasses( request()->classes)
                                     ->whereArms( request()->arms )
                                     ->whereSessions( request()->sessions);

        if( count($students_id) ):
            $fetch_annual_results = $fetch_annual_results->whereIn('student_id', $students_id );
        else:
            $fetch_annual_results = $fetch_annual_results->whereIn('student_id', $students );
        endif;

        $fetch_annual_results = $fetch_annual_results->get();

        if(auth()->user()->student):
          if(request()->student_id != auth()->id() ) $fetch_annual_results = [];
        endif;
        $grades = $this->my_school(new grade)->get();   

        return view('results.annual_result_sheet', compact('fetch_annual_results', 'grades') );
    }
    
    function view_class_broad_sheet(Request $request)
    {
        //$this->fetch_class_termly_result($request); 
        $this->kompute_progress_report($request);
        $get_subjects = $this->query_school_data( new subject_result );
        $subjects  = $get_subjects->orderBy('subjects', 'asc')->groupBy('subjects')->pluck('subjects')->toArray();
        $students = $this->query_school_data( new class_final_result )
                         ->with('profile')
                         ->orderBy('class_position')
                         ->get();

        return view('results.class_broad_sheet', compact('subjects', 'students'));
    }

    function kompute_progress_report(Request $request)
    {
        $results = $this->get_available_student_subject_results_with_student_id_for_this_request();
                   $this->compile_class_final_results( $results );
                   $this->update_class_final_result_position( $results );
        ( $_id =  $this->request_result_has_student_id() ) ? $student_id = $_id : $student_id = [];
       return $this->fetch_this_students_class_final_result($student_id)->get();
    }

    function fetch_class_termly_result(Request $request)
    {
        /***
         * 1. Get all student_id available in this query ( class/arm , term and session) and group them 
         * 2. Loop through them to get their individual total_score summation
         * 3. using the total_score summation and the total subjects taken by d student, get the average score
         * 4. store/update this record on class_final_results table  
         * 5. Fetch students result by class or by student_id ( For a specific student );
         ***/
        $user = auth()->user();
        $student_results = $this->kompute_progress_report($request);
        $grades = $this->my_school(new grade)->get();//->sortBy('grade');
        
        if( url()->current() == route('view_class_broadsheet') ){
            return true;
        }
        
        if($user->student):
            //=== Ensure this student fetches only his result, even if he tries to manipulate the student-id from the query
            if( $request->student_id != auth()->id() )  $student_results = [];     
        endif;
        /**
         * ==== Fetch results ====
         * Nb: 
         *  Default template == 1 (shows all CA, H.Scores, L.scores and teachers remarks... )
         *  template 2 = 2 ( Shows all CA only)
         *  template 3 = 3 ( shows 1st and 2nd CA Only )
         *  template 4 = 4 ( shows 1st and 2nd and 3rd CA Only )
         *  template 5 = 5 ( shows CA and Exam only )
         *  ===========
         **/     
        if($user->school->result_template == 2):
               return view('results.student_result_sheet_2', compact('student_results', 'grades'));
        elseif($user->school->result_template == 3):
            return view('results.student_result_sheet_3', compact('student_results', 'grades'));
        elseif($user->school->result_template == 4):
            return view('results.student_result_sheet_4', compact('student_results', 'grades'));
        elseif($user->school->result_template == 5):
            return view('results.student_result_sheet_5', compact('student_results', 'grades'));
        else:
            return view('results.student_result_sheet', compact('student_results', 'grades')); 
        endif;
    }

    function get_available_student_subject_results_with_student_id_for_this_request($student_id='')
    {
        $find = $this->subject_results()
                     ->select( DB::raw('sum(total_score) as total_score'), DB::raw('count(subjects) as total_subjects'), 
                               DB::raw('student_id as student_id'), DB::raw('classes as classes'), DB::raw('arms as arms') ) 
                     ->groupBy('student_id', 'classes', 'arms');
                      if($student_id) return $find->whereStudent_id($student_id)->first();
        return $find->get();
    }

    function compile_class_final_results($results)
    {
        $this->query_school_data( new class_final_result )->delete();
        foreach($results as $student):
             ( $this->fetch_this_students_class_final_result([ $student->student_id  ])->count() ) 
                ? $this->update_class_final_result( $student->student_id, 'update' ) 
                : $this->update_class_final_result( $student->student_id, 'create' ) ;
        endforeach;
    }

    function fetch_this_students_class_final_result( $student_id = [] )
    {
        $student_results = $this->query_school_data( new class_final_result );
        if( count( $student_id ) ) $student_results = $student_results->whereIn( 'Student_id', $student_id );
        return $student_results;
    }

    function update_class_final_result_position( $results )
    {
        foreach( $results as $student ):
            $average_scores = $this->my_school( new class_final_result )
                                   ->whereClasses($student->classes)
                                   ->whereArms($student->arms)
                                   ->whereTerm( request()->term )
                                   ->whereSessions( request()->sessions )
                                   ->get()
                                   ->sortByDesc('average_score')
                                   ->pluck('average_score')
                                   ->toArray();

            $average_score = number_format( $student->total_score / $student->total_subjects, 2 );
            $position = array_search( $average_score, $average_scores ) + 1;
            $position = $this->ordinal( $position );
            $this->fetch_this_students_class_final_result([ $student->student_id ])->update(['class_position' => $position]);
        endforeach;
        return 1;
    }

    function update_class_final_result( $student_id = '', $type = 'create' )
    {
        $student= $this->get_available_student_subject_results_with_student_id_for_this_request( $student_id );
        $remarks = 'Satisfactory';
        $total_students = $this->subject_results()->whereArms( $student->arms )
                                                  ->select('student_id')
                                                  ->groupBy('student_id')
                                                  ->get()
                                                  ->count();

        $average_score = number_format( $student->total_score / $student->total_subjects, 2 );

        if($type != 'create'):
            $this->fetch_this_students_class_final_result([$student_id])
                 ->update([
                           'total_subjects' => $student->total_subjects,
                           'total_students' => $total_students,
                           'total_score'    => $student->total_score,
                           'average_score'  => $average_score,
                        ]);
        else:
            $store = new class_final_result();
            $store->school_id         = auth()->user()->school_id;
            $store->total_subjects    = $student->total_subjects;
            $store->total_students    = $total_students;
            $store->total_score       = $student->total_score;
            $store->average_score     = $average_score;
            $store->term              = request()->term;
            $store->sessions          = request()->sessions;
            $store->arms              = $student->arms;
            $store->classes           = $student->classes;
            $store->student_id        = $student->student_id;
            $store->principal_comment = $remarks;
            $store->save();
        endif;
        return 1;
    }

    function request_result_has_student_id()
    {
        $id = [];
        ( $student_id = request()->student_id ) ? $id = explode(',' , trim( $student_id ) ) : $id ;
        return array_map('trim', $id);
    }

    function update_academic_result_settings()
    {
        $find = $this->my_school( new result_setting );
        if( $find->exists() ):
            $update = $find->update( request()->all() );
        else:
            $update = result_setting::create( request()->all() );
        endif;
        return ( ! $update ) ? $this->error_msg() : $this->success_msg();
    }

    function update_broad_sheet_result_comment()
    {
        if( request()->has('annual_result_comment')){
            $update = $this->update_annual_result_sheet_comment();
            return ( ! $update ) ? $this->error_msg() : $this->success_msg();
        }
        $query = $this->request_data(new teachers_comment )->whereUser_id( request()->user_id )->whereStatus(0);
        if ( $query->exists() ):
            $store = $query->update( request()->except("_token") );
        else:
            $store = teachers_comment::create( request()->all() );
        endif;                                                 
        return ( ! $store ) ? $this->error_msg() : $this->success_msg();
    }

    function update_annual_result_sheet_comment()
    {
        $query = $this->my_school( new teachers_comment )
                      ->whereUser_id( request()->user_id )
                      ->whereSessions( request()->sessions )
                      ->whereClasses( request()->classes )
                      ->whereStatus(1);
        if ( $query->exists() ):
            $store = $query->update( request()->except(["_token", 'annual_result_comment']) );
        else:
            $store = teachers_comment::create( request()->except(["_token", 'annual_result_comment']) );
        endif;
        return $store; 
    }

    function delete_assessment_scores()
    {
        $id =  request()->id;
        $delete = $this->my_school(new assessment_format)->whereId($id)->delete();
        $this->activity_log("Deleted an Assessment score format");
        return (! $delete) ? $this->error_msg() : $this->success_msg();
    }

    function fetch_assessment_scores()
    {
        if( request()->has('query_assesment_score') ):
            $search = new class_final_result();
            return $search->fetch_result_assessment_format( request()->classes, request()->arms );
        else:
            return $this->my_school(new assessment_format)->latest()->get();
        endif;
    }

    function store_assessment_scores()
    {
        $store = assessment_format::updateOrCreate( request()->all());
        $this->activity_log("Created a New Assessment score format");
        return (! $store) ? $this->error_msg() : $this->success_msg();
    }

    function update_annual_result_admin_comment()
    {
        $id = request()->id;
        $update = $this->my_school(new class_annual_final_result)->whereId($id)
                                                                 ->update(['admin_comment' => request()->admin_comment ]);
        return (! $update) ? $this->error_msg() : $this->success_msg();
    }

    function update_annual_result_teachers_comment()
    {
        $id = request()->id;
        $update = $this->my_school(new class_annual_final_result)->whereId($id)
                                                                 ->update(['teachers_comment' => request()->teachers_comment]);
        return (! $update) ? $this->error_msg() : $this->success_msg();
    }
    
}

