<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use App\Http\Controllers\Traits\my_school_data;
use App\Imports\StaffDataImport;
use App\Imports\StudentsDataImport;
use App\User;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class IndexController extends Controller
{
    use my_school_data;

    function reset_password($id)
    {
        $pwd = rand(100000, 999999);
        $user = User::whereId($id)->first();
        if( $user ) $pwd = strtolower( $user->last_name );
        $update = $user->update(['password' => bcrypt( $pwd )]);
        if(! $update ) return $this->error_msg();
        $user_name = $user->last_name.' '. $user->first_name.' '.$user->other_name;
        $this->activity_log("Made a Password Reset for ".$user_name.' with User ID of '.$user->id);
        return $this->success_msg(' Password Changed Successfully... <br/> New Password is now <br/>'. $pwd .'.');
    }

    function make_admin(Request $request)
    {
        $data = $request->id;
        foreach($data as &$user_id):    
              if(! $this->user(new User, $user_id)->update(['admin'=> 1]) ): continue; endif;
        endforeach;
        unset($user_id);
        $msg = ( count($data) == 1) ? "Made a Staff an Admin " : "Made ".count($data)." Staff Admin" ;
        $this->activity_log($msg);
        return $this->success_msg(); 
    }

    function remove_admin(Request $request)
    {
        $data = $request->id;
        foreach($data as &$user_id):    
              if(! $this->user(new User, $user_id)->update(['admin'=> 0]) ): continue; endif;
        endforeach;
        unset($user_id);
        $msg = ( count($data) == 1) ? "Removed a Staff as an Admin " : "Removed ".count($data)." Staff as Admin" ;
        $this->activity_log($msg);
        return $this->success_msg(); 
    }

    function make_accountant(Request $request)
    {
        $data = $request->id;
        foreach($data as &$user_id):    
              if(! $this->user(new User, $user_id)->update(['accountant'=> 1]) ): continue; endif;
        endforeach;
        unset($user_id);
        $msg = ( count($data) == 1) ? "Made a Staff an Accountant" : "Made ".count($data)." Staff Accountants" ;
        $this->activity_log($msg);
        return $this->success_msg(); 
    }

    function remove_accountant(Request $request)
    {
        $data = $request->id;
        foreach($data as &$user_id):    
              if(! $this->user(new User, $user_id)->update(['accountant'=> 0]) ): continue; endif;
        endforeach;
        unset($user_id);
        $msg = ( count($data) == 1) ? "Removed a Staff as an Accountant " : "Removed ".count($data)." Staff as Accountants" ;
        $this->activity_log($msg);
        return $this->success_msg();
    }

    function grant_access_to_user_to_edit_profile(Request $request)
    {
        $data = $request->id;
        foreach($data as &$user_id):    
              if(! $this->user(new User, $user_id)->update(['edit_profile'=> 1]) ): continue; endif;
        endforeach;
        unset($user_id);
        $msg = ( count($data) == 1) ? "Granted a user Access to edit Profile " : "Granted ".count($data)." users Access to edit their Profiles" ;
        $this->activity_log($msg);
        return $this->success_msg('Permission granted successfully...');      
    }

    function deny_access_to_user_to_edit_profile(Request $request)
    {
        $data = $request->id;
        foreach($data as &$user_id):
              if(! $this->user(new User, $user_id)->update(['edit_profile'=> 0]) ): continue; endif;
        endforeach;
        unset($user_id);
        $msg = ( count($data) == 1) ? "Denied a user Access to edit Profile " : "Denied ".count($data)." users Access to edit their Profiles" ;
        $this->activity_log($msg);
        return $this->success_msg('Permission Denied successfully...');  
    }

    function delete_users(Request $request)
    {
        $data = $request->id;
        foreach($data as &$user_id):
              if(! $this->user(new User, $user_id)->update(['deleted' => 1, 'active' => 0 ]) ): continue; endif;
        endforeach;
        unset($user_id);
        $msg = ( count($data) == 1) ? "Deleted a user from the Portal " : "Deleted ".count($data)." users from the Portal" ;
        $this->activity_log($msg);
        return $this->success_msg('Deleted Successfully...');  
    }

    function activate_user(Request $request)
    {
        $data = $request->id;
        foreach($data as &$user_id):
              if(! $this->user(new User, $user_id)->update(['active'=> 1]) ): continue; endif;
        endforeach;
        unset($user_id);
        $msg = ( count($data) == 1) ? "Activated a user " : "Activated ".count($data)." users" ;
        $this->activity_log($msg);
        return $this->success_msg('Activated Successfully...'); 
    }

    function de_activate_user(Request $request)
    {
        $data = $request->id;
        foreach($data as &$user_id):
              if(! $this->user(new User, $user_id)->update(['active'=> 0]) ): continue; endif;
        endforeach;
        unset($user_id);
        $msg = ( count($data) == 1) ? "De-activated a user " : "De-activated ".count($data)." users" ;
        $this->activity_log($msg);
        return $this->success_msg('De-activated Successfully...'); 
    }

    function register_student(Request $request)
    {
        if(! $this->validate_user_data( $request->all() ) ): return $this->error_msg('Please, ensure all Information are very accurate...'); endif;
        $photo_name='';
        $school_id = auth()->user()->school->id;
        if(request()->has('photo')):
            if(! $this->validate_user_photo($request->all()) ) return $this->error_msg('Please, ensure you are Selecting an Image file and it must not be more than 2mb'); 
            
            $img = $request->file('photo');
            $photo_name = $school_id.'_'.uniqid(). '_' . time() . '.jpg';
            $directory_path  = 'uploaded_files/passports/'.auth()->user()->school_id ;
            if(! File::isDirectory($directory_path) ){
                  File::makeDirectory($directory_path);
            };
           $file_path = public_path().'/'.$directory_path.'/'.$photo_name;
           //=== Reduce  Image size
           $this->resize_and_save_image($img, $file_path);
        endif;

        $student_data = request()->except('api_token');
        $student_data["school_id"] = $school_id;
        $student_data["password"] = bcrypt(strtolower($request->last_name));
        $student_data["photo"] = $photo_name;
        $student_data["student"] = 1;

        $store = User::create( $student_data );
        $user_name = $store->last_name.' '. $store->first_name.' '.$store->other_name;
        $this->activity_log("Registered ".$user_name." as a New Student with Student ID of ". $store->id );
          if(! $store) return $this->error_msg();
          return $this->success_msg('Registration was Successful...');
    }
    
    function register_staff(Request $request)
    {
        if(! $this->validate_user_data($request->all() ) ): return $this->error_msg('Please, ensure all Information are very accurate...'); endif;
        $photo_name='';
        $school_id = auth()->user()->school->id;
        if(request()->has('photo')):
            if(! $this->validate_user_photo($request->all()) ) return $this->error_msg('Please, ensure you are Selecting an Image file and it must not be more than 2mb'); 
            
            $img = $request->file('photo');
            $photo_name = $school_id.'_'.uniqid(). '_' . time() . '.jpg';
            $directory_path  = 'uploaded_files/passports/'.auth()->user()->school_id ;
            if(! File::isDirectory($directory_path) ){
                  File::makeDirectory($directory_path);
            };
            $file_path = public_path().'/'.$directory_path.'/'.$photo_name;
            //Reduce  Image size
            $this->resize_and_save_image($img, $file_path);
        endif;

        $staff_data = request()->except('api_token');
        $staff_data["school_id"] = $school_id;
        $staff_data["password"] = bcrypt(strtolower($request->last_name));
        $staff_data["photo"] = $photo_name;
        $staff_data["staff"] = 1;

        $store = User::create( $staff_data );
        $user_name = $store->last_name.' '. $store->first_name.' '.$store->other_name;
        $this->activity_log("Registered ".$user_name." as a New Staff with Staff ID of ". $store->id );
          if(! $store) return $this->error_msg();
          return $this->success_msg(' Registration was Successful...');
    }

    function class_promotion(Request $request)
    {
        $data = $request->id;
        if(empty($data)) return $this->error_msg(' Please, Select Students you wish to promote first before proceeding... ');
        foreach($data as &$user_id):
              if(! $this->user(new User, $user_id)->update([
                  'target_class'=> $request->target_class,
                  'target_arm'=> $request->target_arm,
                  'target_session'=> $request->target_session,
                  ])):
                  continue;
               endif;
        endforeach;
        unset($user_id);
        $msg = ( count($data) == 1) ? "Promoted a Student to a New Class/Session " : "Promoted ".count($data)." Students to a New Class/Session" ;
        $this->activity_log($msg);
        return $this->success_msg(' Class Promotion was Successful... '); 
    }

    public function import_students_via_excel(Request $request)
    {
        $file = $request->File('import_file');
        Excel::import(new StudentsDataImport, $file, '', \Maatwebsite\Excel\Excel::XLSX);
        $this->activity_log("Imported Students Bio-data through Excel format");
        return $this->success_msg();
    }
    
    public function import_staff_via_excel(Request $request)
    {
        $file = $request->File('import_file');
        Excel::import(new StaffDataImport, $file, '', \Maatwebsite\Excel\Excel::XLSX);
        $this->activity_log("Imported Staff Bio-data through Excel format");
        return $this->success_msg();
    }

}

