<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\my_school_data;
use Illuminate\Http\Request;
use App\User;
use App\models\arm;
use App\models\sch_class;
use App\models\subject;
use Illuminate\Support\Facades\DB;
use RuntimeException;

class DashboardController extends Controller 
{
    use my_school_data;

    public function fetch_dashboard_statistics()
    {
        $boys = 0; $girls = 0;
        if( $this->get_current_students() ):
            $boys = $this->get_current_students()->whereGender('male')->count(); 
            $girls = $this->get_current_students()->whereGender('female')->count();
        endif;
        $classes = $this->my_school(new sch_class)->count();
        $subjects = $this->my_school(new subject)->count();
        $arms = $this->my_school(new arm)->count();
        $male_staff = $this->get_current_staff()->whereGender('male')->count();
        $female_staff = $this->get_current_staff()->whereGender('female')->count();
        $class_statistics = $this->get_class_statistics();

        $data = [ 
                  'boys' => $boys, 
                  'girls' => $girls, 
                  'classes' => $classes, 
                  'subjects' => $subjects, 
                  'arms' => $arms, 
                  'male_staff' => $male_staff, 
                  'female_staff' => $female_staff,
                  'class_statistics' => $class_statistics
                ];
        return response()->json($data);
    }

    function get_class_statistics()
    {
        return $this->get_current_students()->select('target_class as classes', 'target_arm as arms', 
                                            DB::raw(' count(case when gender="male" then 1 end) as total_boys, 
                                                                count(case when gender="female" then 1 end) as total_girls, 
                                                                count(*) as total_students ') 
                                                    )
                                            ->groupBy('classes', 'arms')
                                            ->get();
    }

    function fetch_total_revenue_expenses_and_net_profit_amount()
    {
        $revenue = $this->get_all_revenues();
        $expenses = $this->get_all_expenses();
        return response()->json([
            'revenue' => $revenue, 'expenses' => $expenses
        ]);
    }
    
    function get_all_revenues() 
    {
       return $this->total_revenues();
    }

    function get_all_expenses()
    {
       return $this->total_expenses();
    }
}

